/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.build;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.gradle.internal.build.BuildMetaInfo;
import org.jetbrains.kotlin.gradle.internal.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.gradle.internal.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/build/JvmBuildMetaInfo;", "Lorg/jetbrains/kotlin/gradle/internal/build/BuildMetaInfo;", "<init>", "()V", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "excludedProperties", "", "getExcludedProperties", "()Ljava/util/List;", "argumentsListForSpecialCheck", "getArgumentsListForSpecialCheck", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nJvmBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuildMetaInfo.kt\norg/jetbrains/kotlin/build/JvmBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class JvmBuildMetaInfo
extends BuildMetaInfo {
    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter((Object)previousValue, (String)"previousValue");
        if (Intrinsics.areEqual((Object)key, (Object)"METADATA_VERSION_STRING")) {
            int[] previousVersionIntArray;
            int[] currentVersionIntArray;
            if (!(currentVersionIntArray != null ? (currentVersionIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentVersionIntArray[0], currentVersionIntArray[1], currentVersionIntArray[2]};
            JvmMetadataVersion currentVersion = new JvmMetadataVersion(nArray);
            if (!(previousVersionIntArray != null ? (previousVersionIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousVersionIntArray[0], previousVersionIntArray[1], previousVersionIntArray[2]};
            JvmMetadataVersion previousVersion = new JvmMetadataVersion(nArray2);
            return !Intrinsics.areEqual((Object)currentVersion, (Object)previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args2) {
        JvmMetadataVersion jvmMetadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Map resultMap = new LinkedHashMap();
        String string2 = args2.getMetadataVersion();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            jvmMetadataVersion = new JvmMetadataVersion(p0);
        } else {
            jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
        }
        JvmMetadataVersion metadataVersion = jvmMetadataVersion;
        String metadataVersionString = metadataVersion.toString();
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args2), (Map)resultMap);
    }

    @Override
    @NotNull
    public List<String> getExcludedProperties() {
        Object[] objectArray = new String[]{"excludedProperties", "backendThreads", "buildFile", "classpath", "declarationsOutputPath", "defaultScriptExtension", "enableDebugMode", "expression", "internalArguments", "profileCompilerCommand", "repeatCompileModules", "scriptResolverEnvironment", "scriptTemplates", "suppressDeprecatedJvmTargetWarning", "useFastJarFileSystem"};
        return CollectionsKt.plus((Collection)super.getExcludedProperties(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public List<String> getArgumentsListForSpecialCheck() {
        Object[] objectArray = new String[]{"allowNoSourceFiles", "allowUnstableDependencies", "enableJvmPreview", "suppressMissingBuiltinsError"};
        return CollectionsKt.plus((Collection)super.getArgumentsListForSpecialCheck(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

