/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractIntToIntBtree;
import org.jetbrains.kotlin.com.intellij.util.io.CorruptedException;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.Page;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.PageUnsafe;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.impl.PageContentLockingStrategy;
import org.jetbrains.kotlin.com.intellij.util.io.stats.BTreeStatistics;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public final class IntToIntBtreeLockFree
extends AbstractIntToIntBtree {
    private static final boolean CACHE_ROOT_NODE_BUFFER = SystemProperties.getBooleanProperty("idea.btree.cache.root.node.buffer", true);
    private static final int HAS_ZERO_KEY_MASK = -16777216;
    private static final int UNDEFINED_ADDRESS = -1;
    private static final int DEFAULT_PAGE_SIZE = 0x100000;
    private static final boolean DO_SANITY_CHECK = false;
    private static final boolean DO_DUMP = false;
    private final int pageSize;
    private final short maxInteriorNodes;
    private final short maxLeafNodes;
    private final short maxLeafNodesInHash;
    private final BtreeRootNode root;
    private int height;
    private int maxStepsSearchedInHash;
    private int totalHashStepsSearched;
    private int hashSearchRequests;
    private int pagesCount;
    private int hashedPagesCount;
    private int count;
    private int movedMembersCount;
    private boolean hasZeroKey;
    private int zeroKeyValue;
    private final PagedFileStorageWithRWLockedPageContent storage;
    private final int metaDataLeafPageLength;
    private final int hashPageCapacity;
    private BtreeIndexNodeView myAccessNodeView;
    private int myLastGetKey;
    private int myOptimizedInserts;
    private boolean myCanUseLastKey;

    public IntToIntBtreeLockFree(int pageSize, @NotNull Path file2, @NotNull StorageLockContext storageLockContext, boolean initial, PageContentLockingStrategy.SharedLockLockingStrategy lockingStrategy) throws IOException {
        if (file2 == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(0);
        }
        if (storageLockContext == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(1);
        }
        this.pageSize = pageSize;
        if (initial) {
            Files.deleteIfExists(file2);
        }
        this.storage = PagedFileStorageWithRWLockedPageContent.createWithDefaults(file2, storageLockContext, SystemProperties.getIntProperty("idea.IntToIntBtree.page.size", 0x100000), IOUtil.useNativeByteOrderForByteBuffers(), lockingStrategy);
        this.root = new BtreeRootNode();
        if (initial) {
            this.root.setAddress(-1);
        }
        int i2 = (this.pageSize - 8) / 8 - 1;
        assert (i2 < Short.MAX_VALUE && i2 % 2 == 0);
        this.maxInteriorNodes = (short)i2;
        this.maxLeafNodes = (short)i2;
        ++i2;
        while (!IntToIntBtreeLockFree.isPrime(i2)) {
            i2 -= 2;
        }
        this.hashPageCapacity = i2;
        int metaPageLen = 8;
        i2 = (int)((double)this.hashPageCapacity * 0.9);
        if ((i2 & 1) == 1) {
            ++i2;
        }
        this.metaDataLeafPageLength = metaPageLen;
        assert (i2 > 0 && i2 % 2 == 0);
        this.maxLeafNodesInHash = (short)i2;
    }

    private void doAllocateRoot() throws IOException {
        this.nextPage();
        this.root.setAddress(0);
        this.root.getNodeView().setIndexLeaf(true);
    }

    @Override
    public void persistVars(@NotNull AbstractIntToIntBtree.BtreeDataStorage storage, boolean toDisk) throws IOException {
        if (storage == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(2);
        }
        int i2 = storage.persistInt(0, this.height | (this.hasZeroKey ? -16777216 : 0), toDisk);
        this.hasZeroKey = (i2 & 0xFF000000) != 0;
        this.height = i2 & 0xFFFFFF;
        this.pagesCount = storage.persistInt(4, this.pagesCount, toDisk);
        this.movedMembersCount = storage.persistInt(8, this.movedMembersCount, toDisk);
        this.maxStepsSearchedInHash = storage.persistInt(12, this.maxStepsSearchedInHash, toDisk);
        this.count = storage.persistInt(16, this.count, toDisk);
        this.hashSearchRequests = storage.persistInt(20, this.hashSearchRequests, toDisk);
        this.totalHashStepsSearched = storage.persistInt(24, this.totalHashStepsSearched, toDisk);
        this.hashedPagesCount = storage.persistInt(28, this.hashedPagesCount, toDisk);
        this.root.setAddress(storage.persistInt(32, this.root.address, toDisk));
        this.zeroKeyValue = storage.persistInt(36, this.zeroKeyValue, toDisk);
    }

    private static boolean isPrime(int val) {
        if (val % 2 == 0) {
            return false;
        }
        int maxDivisor = (int)Math.sqrt(val);
        for (int i2 = 3; i2 <= maxDivisor; i2 += 2) {
            if (val % i2 != 0) continue;
            return false;
        }
        return true;
    }

    private int nextPage() throws IOException {
        int pageStart = (int)this.storage.length();
        this.storage.putInt(pageStart + this.pageSize - 4, 0);
        ++this.pagesCount;
        return pageStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(int key, int @NotNull [] result2) throws IOException {
        if (result2 == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(3);
        }
        assert (result2.length > 0) : "result.length must be >0";
        if (key == 0) {
            if (this.hasZeroKey) {
                result2[0] = this.zeroKeyValue;
                return true;
            }
            return false;
        }
        if (this.root.address == -1) {
            return false;
        }
        Page root2 = this.initAccessNodeView();
        try {
            int index = this.myAccessNodeView.locate(key, false);
            if (index < 0) {
                this.myCanUseLastKey = true;
                this.myLastGetKey = key;
                boolean bl = false;
                return bl;
            }
            this.myCanUseLastKey = false;
            result2[0] = this.myAccessNodeView.addressAt(index);
        }
        finally {
            this.myAccessNodeView.disposePage();
            if (root2 != null) {
                root2.release();
            }
        }
        return true;
    }

    private Page initAccessNodeView() throws IOException {
        PageUnsafe page;
        int rootAddress = this.root.address;
        if (CACHE_ROOT_NODE_BUFFER) {
            BtreeIndexNodeView node2 = this.root.getNodeView();
            node2.acquirePage();
            page = node2.page;
        } else {
            page = null;
        }
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(rootAddress, true, page);
        } else {
            this.myAccessNodeView.initTraversal(rootAddress, page);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int key, int value2) throws IOException {
        if (key == 0) {
            this.hasZeroKey = true;
            this.zeroKeyValue = value2;
            return;
        }
        boolean canUseLastKey = this.myCanUseLastKey;
        if (canUseLastKey) {
            this.myCanUseLastKey = false;
            if (key == this.myLastGetKey && !this.myAccessNodeView.myHasFullPagesAlongPath) {
                ++this.myOptimizedInserts;
                ++this.count;
                try {
                    this.myAccessNodeView.insert(key, value2);
                }
                finally {
                    this.myAccessNodeView.disposePage();
                }
                return;
            }
        }
        this.doPut(key, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(int key, int value2) throws IOException {
        if (this.root.address == -1) {
            this.doAllocateRoot();
        }
        Page root2 = this.initAccessNodeView();
        try {
            int index = this.myAccessNodeView.locate(key, true);
            if (index < 0) {
                ++this.count;
                this.myAccessNodeView.insert(key, value2);
            } else {
                this.myAccessNodeView.setAddressAt(index, value2);
            }
        }
        finally {
            this.myAccessNodeView.disposePage();
            if (root2 != null) {
                root2.release();
            }
        }
    }

    @Override
    public void doClose() throws IOException {
        BtreeIndexNodeView rootNode = this.root.nodeView;
        rootNode.disposePage();
        this.storage.close();
    }

    @Override
    public void doFlush() throws IOException {
        this.storage.force();
    }

    @Override
    public boolean processMappings(@NotNull AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(4);
        }
        this.doFlush();
        if (this.hasZeroKey && !processor.process(0, this.zeroKeyValue)) {
            return false;
        }
        if (this.root.address == -1) {
            return true;
        }
        this.root.syncWithStore();
        return this.processLeafPages(this.root.getNodeView(), processor);
    }

    @Override
    @NotNull
    public BTreeStatistics getStatistics() throws IOException {
        int leafPages = this.height == 3 ? this.pagesCount - (1 + this.root.getNodeView().getChildrenCount() + 1) : (this.height == 2 ? this.pagesCount - 1 : 1);
        return new BTreeStatistics(this.pagesCount, this.count, this.height, this.movedMembersCount, leafPages, this.maxStepsSearchedInHash, this.hashSearchRequests, this.totalHashStepsSearched, this.pageSize, this.storage.length());
    }

    private boolean processLeafPages(@NotNull BtreeIndexNodeView node2, @NotNull AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(5);
        }
        if (node2 == null) {
            IntToIntBtreeLockFree.$$$reportNull$$$0(6);
        }
        if (node2.isIndexLeaf()) {
            return node2.processMappings(processor);
        }
        int[] childrenAddresses = new int[node2.getChildrenCount() + 1];
        for (int i2 = 0; i2 < childrenAddresses.length; ++i2) {
            childrenAddresses[i2] = -node2.addressAt(i2);
        }
        if (childrenAddresses.length > 0) {
            try (BtreeIndexNodeView child = new BtreeIndexNodeView(true);){
                for (int childrenAddress : childrenAddresses) {
                    child.setAddress(childrenAddress);
                    if (this.processLeafPages(child, processor)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/IntToIntBtreeLockFree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "persistVars";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processMappings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafPages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class BtreeRootNode {
        int address;
        final BtreeIndexNodeView nodeView;
        boolean initialized;

        private BtreeRootNode() {
            this.nodeView = new BtreeIndexNodeView(false);
        }

        void setAddress(int _address) {
            this.address = _address;
            this.initialized = false;
        }

        void syncWithStore() throws IOException {
            this.nodeView.setAddress(this.address);
            this.initialized = true;
        }

        BtreeIndexNodeView getNodeView() throws IOException {
            if (!this.initialized) {
                this.syncWithStore();
            }
            return this.nodeView;
        }
    }

    private final class BtreeIndexNodeView
    implements Closeable {
        static final int INTERIOR_SIZE = 8;
        static final int KEY_OFFSET = 4;
        private boolean isIndexLeaf;
        private boolean isHashedLeaf;
        private static final int LARGE_MOVE_THRESHOLD = 5;
        static final int RESERVED_META_PAGE_LEN = 8;
        static final int FLAGS_SHIFT = 24;
        static final int LENGTH_SHIFT = 8;
        static final int LENGTH_MASK = 65535;
        private int address = -1;
        private int addressInBuffer;
        private short myChildrenCount = (short)-1;
        private PageUnsafe page;
        private boolean isSharedPage;
        private final boolean keepPageAcquiredUntilDispose;
        private boolean myHasFullPagesAlongPath;
        private static final int HASH_FREE = 0;
        static final int INDEX_LEAF_MASK = 1;
        static final int HASHED_LEAF_MASK = 2;
        private static final boolean useDoubleHash = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFlag(int mask, boolean flag2) throws IOException {
            mask <<= 24;
            this.acquirePage();
            try {
                int anInt = this.page.getInt(this.addressInBuffer);
                anInt = flag2 ? (anInt |= mask) : (anInt &= ~mask);
                this.page.putInt(this.addressInBuffer, anInt);
            }
            finally {
                this.releasePage();
            }
        }

        BtreeIndexNodeView(boolean keepPageAcquiredUntilDispose) {
            this.keepPageAcquiredUntilDispose = keepPageAcquiredUntilDispose;
        }

        BtreeIndexNodeView(int address, boolean keepPageAcquiredUntilDispose, PageUnsafe sharedBuffer) throws IOException {
            this.keepPageAcquiredUntilDispose = keepPageAcquiredUntilDispose;
            this.initTraversal(address, sharedBuffer);
        }

        private short getChildrenCount() {
            return this.myChildrenCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setChildrenCount(short value2) throws IOException {
            this.myChildrenCount = value2;
            this.acquirePage();
            try {
                ByteBuffer pageBuffer = this.page.rawPageBuffer();
                int myValue = pageBuffer.getInt(this.addressInBuffer);
                myValue &= 0xFF000000;
                this.page.putInt(this.addressInBuffer, myValue |= value2 << 8);
            }
            finally {
                this.releasePage();
            }
        }

        private void setNextPage(int nextPage) throws IOException {
            this.putInt(4, nextPage);
        }

        private int getNextPage() throws IOException {
            this.acquirePage();
            try {
                int n = this.getInt(4);
                return n;
            }
            finally {
                this.releasePage();
            }
        }

        private int getInt(int address) throws IOException {
            this.acquirePage();
            try {
                int n = this.page.getInt(this.addressInBuffer + address);
                return n;
            }
            finally {
                this.releasePage();
            }
        }

        private void putInt(int offset, int value2) throws IOException {
            this.acquirePage();
            try {
                this.page.putInt(this.addressInBuffer + offset, value2);
            }
            finally {
                this.releasePage();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer getBytes(int address, int length) throws IOException {
            this.acquirePage();
            try {
                ByteBuffer duplicate = this.page.duplicate();
                int newPosition = address + this.addressInBuffer;
                duplicate.position(newPosition);
                duplicate.limit(newPosition + length);
                ByteBuffer byteBuffer = duplicate;
                return byteBuffer;
            }
            finally {
                this.releasePage();
            }
        }

        private void putBytes(int address, ByteBuffer buffer) throws IOException {
            this.acquirePage();
            try {
                this.page.putFromBuffer(buffer, address + this.addressInBuffer);
            }
            finally {
                this.releasePage();
            }
        }

        void setAddress(int _address) throws IOException {
            this.setAddress(_address, null);
        }

        void setAddress(int _address, PageUnsafe sharedBuffer) throws IOException {
            this.address = _address;
            this.addressInBuffer = IntToIntBtreeLockFree.this.storage.toOffsetInPage(this.address);
            this.disposePage();
            if (sharedBuffer != null) {
                this.page = sharedBuffer;
                this.isSharedPage = true;
            }
            this.syncWithStore();
        }

        private void syncWithStore() throws IOException {
            this.acquirePage();
            try {
                this.doInitFlags(this.page.getInt(this.addressInBuffer));
            }
            finally {
                this.releasePage();
            }
        }

        private void acquirePage() throws IOException {
            boolean acquiredSuccessfully;
            if (this.isSharedPage) {
                return;
            }
            if (this.page == null) {
                this.page = (PageUnsafe)IntToIntBtreeLockFree.this.storage.pageByOffset(this.address, false);
            } else if (!this.keepPageAcquiredUntilDispose && !(acquiredSuccessfully = this.page.tryAcquire(this))) {
                this.page = (PageUnsafe)IntToIntBtreeLockFree.this.storage.pageByOffset(this.address, false);
            }
        }

        private void releasePage() {
            if (this.isSharedPage) {
                return;
            }
            if (!this.keepPageAcquiredUntilDispose) {
                this.page.release();
            }
        }

        private void disposePage() {
            try {
                if (this.isSharedPage) {
                    this.isSharedPage = false;
                    return;
                }
                if (this.page != null && this.keepPageAcquiredUntilDispose) {
                    this.page.release();
                }
            }
            finally {
                this.page = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int search(int value2) throws IOException {
            if (this.isIndexLeaf() && this.isHashedLeaf()) {
                return this.hashIndex(value2);
            }
            this.acquirePage();
            try {
                ByteBuffer pageBuffer = this.page.rawPageBuffer();
                int n = ObjectUtils.binarySearch(0, this.getChildrenCount(), mid -> {
                    int key = this.keyAtGivenLocksAndBufferAcquired(pageBuffer, mid);
                    return Integer.compare(key, value2);
                });
                return n;
            }
            finally {
                this.releasePage();
            }
        }

        int addressAt(int i2) throws IOException {
            return this.getInt(this.indexToOffset(i2));
        }

        private void setAddressAt(int i2, int value2) throws IOException {
            int offset = this.indexToOffset(i2);
            this.putInt(offset, value2);
        }

        private int indexToOffset(int i2) {
            return i2 * 8 + (this.isHashedLeaf() ? IntToIntBtreeLockFree.this.metaDataLeafPageLength : 8);
        }

        private int keyAt(int i2) {
            try {
                return this.getInt(this.indexToOffset(i2) + 4);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private int keyAtGivenLocksAndBufferAcquired(ByteBuffer pageBuffer, int slotIndex) {
            int keyOffsetInNode = this.indexToOffset(slotIndex) + 4;
            return this.getIntGivenLocksAndBufferAcquired(pageBuffer, keyOffsetInNode);
        }

        private int addressAtGivenLocksAndBufferAcquired(ByteBuffer pageBuffer, int slotIndex) {
            int offsetInNode = this.indexToOffset(slotIndex);
            return this.getIntGivenLocksAndBufferAcquired(pageBuffer, offsetInNode);
        }

        private int getIntGivenLocksAndBufferAcquired(ByteBuffer pageBuffer, int offsetInNode) {
            return pageBuffer.getInt(this.addressInBuffer + offsetInNode);
        }

        private void setKeyAt(int i2, int value2) throws IOException {
            int offset = this.indexToOffset(i2) + 4;
            this.putInt(offset, value2);
        }

        boolean isIndexLeaf() {
            return this.isIndexLeaf;
        }

        private void doInitFlags(int flags) {
            this.myChildrenCount = (short)(flags >>> 8 & 0xFFFF);
            flags = flags >> 24 & 0xFF;
            this.isHashedLeaf = BitUtil.isSet(flags, 2);
            this.isIndexLeaf = BitUtil.isSet(flags, 1);
        }

        void setIndexLeaf(boolean value2) throws IOException {
            this.isIndexLeaf = value2;
            this.setFlag(1, value2);
        }

        private boolean isHashedLeaf() {
            return this.isHashedLeaf;
        }

        void setHashedLeaf() throws IOException {
            this.isHashedLeaf = true;
            this.setFlag(2, true);
        }

        short getMaxChildrenCount() {
            return this.isIndexLeaf() ? (this.isHashedLeaf() ? IntToIntBtreeLockFree.this.maxLeafNodesInHash : IntToIntBtreeLockFree.this.maxLeafNodes) : IntToIntBtreeLockFree.this.maxInteriorNodes;
        }

        boolean isFull() {
            short childrenCount = this.getChildrenCount();
            if (!this.isIndexLeaf()) {
                childrenCount = (short)(childrenCount + 1);
            }
            return childrenCount == this.getMaxChildrenCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processMappings(AbstractIntToIntBtree.KeyValueProcessor processor) throws IOException {
            assert (this.isIndexLeaf());
            this.acquirePage();
            try {
                ByteBuffer pageBuffer = this.page.rawPageBuffer();
                if (this.isHashedLeaf()) {
                    int offset = this.addressInBuffer + this.indexToOffset(0);
                    for (int slotNo = 0; slotNo < IntToIntBtreeLockFree.this.hashPageCapacity; ++slotNo) {
                        int value2;
                        int key = pageBuffer.getInt(offset + 4);
                        if (key != 0 && !processor.process(key, value2 = pageBuffer.getInt(offset))) {
                            boolean bl = false;
                            return bl;
                        }
                        offset += 8;
                    }
                } else {
                    int childrenCount = this.getChildrenCount();
                    for (int childNo = 0; childNo < childrenCount; ++childNo) {
                        int value3;
                        int key = this.keyAtGivenLocksAndBufferAcquired(pageBuffer, childNo);
                        if (processor.process(key, value3 = this.addressAtGivenLocksAndBufferAcquired(pageBuffer, childNo))) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.releasePage();
            }
        }

        public void initTraversal(int address, PageUnsafe sharedBuffer) throws IOException {
            this.myHasFullPagesAlongPath = false;
            this.setAddress(address, sharedBuffer);
        }

        @Override
        public void close() {
            this.disposePage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int splitNode(int parentAddress) throws IOException {
            boolean indexLeaf = this.isIndexLeaf();
            boolean hashedLeaf = this.isHashedLeaf();
            short recordCount = this.getChildrenCount();
            try (BtreeIndexNodeView parent = null;){
                if (parentAddress != 0) {
                    parent = new BtreeIndexNodeView(parentAddress, true, null);
                }
                short maxIndex = (short)(this.getMaxChildrenCount() / 2);
                try (BtreeIndexNodeView newIndexNode = new BtreeIndexNodeView(IntToIntBtreeLockFree.this.nextPage(), true, null);){
                    int medianKey;
                    this.syncWithStore();
                    if (parent != null) {
                        parent.syncWithStore();
                    }
                    IntToIntBtreeLockFree.this.root.syncWithStore();
                    newIndexNode.setIndexLeaf(indexLeaf);
                    int nextPage = this.getNextPage();
                    this.setNextPage(newIndexNode.address);
                    newIndexNode.setNextPage(nextPage);
                    if (indexLeaf && hashedLeaf) {
                        HashLeafData hashLeafData = new HashLeafData(this, recordCount);
                        int[] keys = hashLeafData.keys;
                        hashLeafData.clean();
                        Int2IntMap map2 = hashLeafData.values;
                        int avg = keys.length / 2;
                        medianKey = keys[avg];
                        --IntToIntBtreeLockFree.this.hashedPagesCount;
                        this.setChildrenCount((short)0);
                        newIndexNode.setChildrenCount((short)0);
                        for (int i2 = 0; i2 < avg; ++i2) {
                            int key = keys[i2];
                            this.insert(key, map2.get(key));
                            key = keys[avg + i2];
                            newIndexNode.insert(key, map2.get(key));
                        }
                    } else {
                        short recordCountInNewNode = (short)(recordCount - maxIndex);
                        newIndexNode.setChildrenCount(recordCountInNewNode);
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(maxIndex), recordCountInNewNode * 8);
                        newIndexNode.putBytes(newIndexNode.indexToOffset(0), buffer);
                        if (indexLeaf) {
                            medianKey = newIndexNode.keyAt(0);
                        } else {
                            newIndexNode.setAddressAt(recordCountInNewNode, this.addressAt(recordCount));
                            maxIndex = (short)(maxIndex - 1);
                            medianKey = this.keyAt(maxIndex);
                        }
                        this.setChildrenCount(maxIndex);
                    }
                    if (parent != null) {
                        parent.insert(medianKey, -newIndexNode.address);
                    } else {
                        int newRootAddress = IntToIntBtreeLockFree.this.nextPage();
                        newIndexNode.syncWithStore();
                        this.syncWithStore();
                        IntToIntBtreeLockFree.this.root.setAddress(newRootAddress);
                        parentAddress = newRootAddress;
                        BtreeIndexNodeView rootNodeView = IntToIntBtreeLockFree.this.root.getNodeView();
                        rootNodeView.setChildrenCount((short)1);
                        rootNodeView.setKeyAt(0, medianKey);
                        rootNodeView.setAddressAt(0, -this.address);
                        rootNodeView.setAddressAt(1, -newIndexNode.address);
                    }
                }
            }
            return parentAddress;
        }

        void dump(String s) throws IOException {
        }

        private void immediateDump(String s) throws IOException {
            int maxIndex = this.getChildrenCount();
            System.out.println(s + " @" + this.address);
            for (int i2 = 0; i2 < maxIndex; ++i2) {
                System.out.print(this.addressAt(i2) + " " + this.keyAt(i2) + " ");
            }
            if (!this.isIndexLeaf()) {
                System.out.println(this.addressAt(maxIndex));
            } else {
                System.out.println();
            }
        }

        private int locate(int valueHC, boolean split) throws IOException {
            int searched = 0;
            int parentAddress = 0;
            int maxHeight = IntToIntBtreeLockFree.this.height + 1;
            while (true) {
                if (this.isFull()) {
                    if (split) {
                        if ((parentAddress = this.splitNode(parentAddress)) != 0) {
                            this.setAddress(parentAddress);
                        }
                        --searched;
                    } else {
                        this.myHasFullPagesAlongPath = true;
                    }
                }
                int i2 = this.search(valueHC);
                if (++searched > maxHeight) {
                    throw new CorruptedException(IntToIntBtreeLockFree.this.storage.getFile());
                }
                if (this.isIndexLeaf()) {
                    IntToIntBtreeLockFree.this.height = Math.max(IntToIntBtreeLockFree.this.height, searched);
                    return i2;
                }
                int address = i2 < 0 ? this.addressAt(-i2 - 1) : this.addressAt(i2 + 1);
                parentAddress = this.address;
                this.setAddress(-address);
            }
        }

        private void insert(int valueHC, int newValueId) throws IOException {
            short recordCount = this.getChildrenCount();
            boolean indexLeaf = this.isIndexLeaf();
            if (indexLeaf) {
                if (recordCount == 0) {
                    this.setHashedLeaf();
                    ++IntToIntBtreeLockFree.this.hashedPagesCount;
                }
                if (this.isHashedLeaf()) {
                    int index = this.hashIndex(valueHC);
                    if (index < 0) {
                        index = -index - 1;
                    }
                    this.setKeyAt(index, valueHC);
                    this.setAddressAt(index, newValueId);
                    this.setChildrenCount((short)(recordCount + 1));
                    return;
                }
            }
            int medianKeyInParent = this.search(valueHC);
            int index = -medianKeyInParent - 1;
            this.setChildrenCount((short)(recordCount + 1));
            int itemsToMove = recordCount - index;
            IntToIntBtreeLockFree.this.movedMembersCount += itemsToMove;
            if (indexLeaf) {
                if (itemsToMove > 5) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(index), itemsToMove * 8);
                    this.putBytes(this.indexToOffset(index + 1), buffer);
                } else {
                    for (int i2 = recordCount - 1; i2 >= index; --i2) {
                        this.setKeyAt(i2 + 1, this.keyAt(i2));
                        this.setAddressAt(i2 + 1, this.addressAt(i2));
                    }
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index, newValueId);
            } else {
                this.setAddressAt(recordCount + 1, this.addressAt(recordCount));
                if (itemsToMove > 5) {
                    int elementsAfterIndex = recordCount - index - 1;
                    if (elementsAfterIndex > 0) {
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(index + 1), elementsAfterIndex * 8);
                        this.putBytes(this.indexToOffset(index + 2), buffer);
                    }
                } else {
                    for (int i3 = recordCount - 1; i3 > index; --i3) {
                        this.setKeyAt(i3 + 1, this.keyAt(i3));
                        this.setAddressAt(i3 + 1, this.addressAt(i3));
                    }
                }
                if (index < recordCount) {
                    this.setKeyAt(index + 1, this.keyAt(index));
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index + 1, newValueId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int hashIndex(int value2) throws IOException {
            this.acquirePage();
            try {
                ByteBuffer pageBuffer = this.page.rawPageBuffer();
                int length = IntToIntBtreeLockFree.this.hashPageCapacity;
                int hash = value2 & Integer.MAX_VALUE;
                int index = hash % length;
                int keyAtIndex = this.keyAtGivenLocksAndBufferAcquired(pageBuffer, index);
                IntToIntBtreeLockFree.this.hashSearchRequests++;
                int total = 0;
                if (keyAtIndex != value2 && keyAtIndex != 0) {
                    int probe = 1 + hash % (length - 2);
                    do {
                        if ((index -= probe) < 0) {
                            index += length;
                        }
                        keyAtIndex = this.keyAtGivenLocksAndBufferAcquired(pageBuffer, index);
                        if (++total <= length) continue;
                        throw new CorruptedException(IntToIntBtreeLockFree.this.storage.getFile());
                    } while (keyAtIndex != value2 && keyAtIndex != 0);
                }
                IntToIntBtreeLockFree.this.maxStepsSearchedInHash = Math.max(IntToIntBtreeLockFree.this.maxStepsSearchedInHash, total);
                IntToIntBtreeLockFree.this.totalHashStepsSearched += total;
                int n = keyAtIndex == 0 ? -index - 1 : index;
                return n;
            }
            finally {
                this.releasePage();
            }
        }

        private final class HashLeafData {
            final BtreeIndexNodeView nodeView;
            final int[] keys;
            final Int2IntMap values;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            HashLeafData(BtreeIndexNodeView _nodeView, int recordCount) throws IOException {
                this.nodeView = _nodeView;
                int offset = this.nodeView.addressInBuffer + this.nodeView.indexToOffset(0);
                this.keys = new int[recordCount];
                this.values = new Int2IntOpenHashMap(recordCount);
                int[] keyNumber = new int[]{0};
                for (int i2 = 0; i2 < IntToIntBtreeLockFree.this.hashPageCapacity; ++i2) {
                    this.nodeView.acquirePage();
                    try {
                        int key = this.nodeView.page.getInt(offset + 4);
                        if (key != 0) {
                            int value2 = this.nodeView.page.getInt(offset);
                            if (keyNumber[0] == this.keys.length) {
                                throw new CorruptedException(IntToIntBtreeLockFree.this.storage.getFile());
                            }
                            int n = keyNumber[0];
                            keyNumber[0] = n + 1;
                            this.keys[n] = key;
                            this.values.put(key, value2);
                        }
                    }
                    finally {
                        this.nodeView.releasePage();
                    }
                    offset += 8;
                }
                Arrays.sort(this.keys);
            }

            private void clean() throws IOException {
                for (int i2 = 0; i2 < IntToIntBtreeLockFree.this.hashPageCapacity; ++i2) {
                    this.nodeView.setKeyAt(i2, 0);
                }
            }
        }
    }
}

