/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import java.io.Flushable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.indexing.StorageException;
import org.jetbrains.kotlin.com.intellij.util.indexing.ValueContainer;

public interface IndexStorage<Key, Value>
extends Flushable {
    public void addValue(Key var1, int var2, Value var3) throws StorageException;

    public void removeAllValues(@NotNull Key var1, int var2) throws StorageException;

    default public void updateValue(Key key, int inputId, Value newValue) throws StorageException {
        this.removeAllValues(key, inputId);
        this.addValue(key, inputId, newValue);
    }

    public void clear() throws StorageException;

    @NotNull
    public ValueContainer<Value> read(Key var1) throws StorageException;

    public void clearCaches();

    public void close() throws StorageException;

    @Override
    public void flush() throws IOException;

    public boolean isDirty();
}

