/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ElementOrder<T> {
    private final Type myType;
    @Nullable
    private final Comparator<T> myComparator;

    private ElementOrder(Type type, @Nullable Comparator<T> comparator) {
        this.myType = Objects.requireNonNull(type);
        this.myComparator = comparator;
        assert (type == Type.SORTED == (comparator != null));
    }

    public static <S> ElementOrder<S> unordered() {
        return new ElementOrder(Type.UNORDERED, null);
    }

    public static <S> ElementOrder<S> stable() {
        return new ElementOrder(Type.STABLE, null);
    }

    public static <S> ElementOrder<S> insertion() {
        return new ElementOrder(Type.INSERTION, null);
    }

    public static <S extends Comparable<? super S>> ElementOrder<S> natural() {
        return new ElementOrder(Type.SORTED, Comparator.naturalOrder());
    }

    public static <S> ElementOrder<S> sorted(Comparator<S> comparator) {
        return new ElementOrder<S>(Type.SORTED, Objects.requireNonNull(comparator));
    }

    public Type type() {
        return this.myType;
    }

    public Comparator<T> comparator() {
        if (this.myComparator != null) {
            return this.myComparator;
        }
        throw new UnsupportedOperationException("This ordering does not define a comparator.");
    }

    public boolean equals(@Nullable Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (!(obj2 instanceof ElementOrder)) {
            return false;
        }
        ElementOrder other = (ElementOrder)obj2;
        return this.myType == other.myType && Objects.equals(this.myComparator, other.myComparator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myType, this.myComparator});
    }

    public String toString() {
        return "ElementOrder{myType=" + (Object)((Object)this.myType) + ", myComparator=" + this.myComparator + '}';
    }

    public static enum Type {
        UNORDERED,
        STABLE,
        INSERTION,
        SORTED;

    }
}

