/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.reflect;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMap;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingSet;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.reflect.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.reflect.TypeToInstanceMap;
import org.jetbrains.kotlin.com.google.common.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.DoNotCall;

@ElementTypesAreNonnullByDefault
public final class MutableTypeToInstanceMap<B>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends @NonNull B>, B> backingMap = Maps.newHashMap();

    @Override
    @CheckForNull
    public <T extends B> T getInstance(Class<T> type) {
        return this.trustedGet(TypeToken.of(type));
    }

    @Override
    @CheckForNull
    public <T extends B> T getInstance(TypeToken<T> type) {
        return this.trustedGet(type.rejectTypeVariables());
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(Class<@NonNull T> type, @ParametricNullness T value2) {
        return this.trustedPut(TypeToken.of(type), value2);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(TypeToken<@NonNull T> type, @ParametricNullness T value2) {
        return this.trustedPut(type.rejectTypeVariables(), value2);
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public B put(TypeToken<? extends @NonNull B> key, @ParametricNullness B value2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public void putAll(Map<? extends TypeToken<? extends @NonNull B>, ? extends B> map2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    public Set<Map.Entry<TypeToken<? extends @NonNull B>, B>> entrySet() {
        return UnmodifiableEntry.transformEntries(super.entrySet());
    }

    @Override
    protected Map<TypeToken<? extends @NonNull B>, B> delegate() {
        return this.backingMap;
    }

    @CheckForNull
    private <T extends B> T trustedPut(TypeToken<@NonNull T> type, @ParametricNullness T value2) {
        return (T)this.backingMap.put(type, value2);
    }

    @CheckForNull
    private <T extends B> T trustedGet(TypeToken<T> type) {
        return (T)this.backingMap.get(type);
    }

    private static final class UnmodifiableEntry<K, V>
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        static <K, V> Set<Map.Entry<K, V>> transformEntries(final Set<Map.Entry<K, V>> entries2) {
            return new ForwardingSet<Map.Entry<K, V>>(){

                @Override
                protected Set<Map.Entry<K, V>> delegate() {
                    return entries2;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return UnmodifiableEntry.transformEntries(super.iterator());
                }

                @Override
                public Object[] toArray() {
                    Object[] result2 = this.standardToArray();
                    return result2;
                }

                @Override
                public <T> T[] toArray(T[] array2) {
                    return this.standardToArray(array2);
                }
            };
        }

        private static <K, V> Iterator<Map.Entry<K, V>> transformEntries(Iterator<Map.Entry<K, V>> entries2) {
            return Iterators.transform(entries2, UnmodifiableEntry::new);
        }

        private UnmodifiableEntry(Map.Entry<K, V> delegate2) {
            this.delegate = Preconditions.checkNotNull(delegate2);
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V value2) {
            throw new UnsupportedOperationException();
        }
    }
}

