/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Converter;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.base.Strings;
import org.jetbrains.kotlin.com.google.common.primitives.DoublesMethodsForWeb;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Doubles
extends DoublesMethodsForWeb {
    public static final int BYTES = 8;
    @GwtIncompatible
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    private Doubles() {
    }

    public static int hashCode(double value2) {
        return Double.valueOf(value2).hashCode();
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static boolean isFinite(double value2) {
        return Double.NEGATIVE_INFINITY < value2 && value2 < Double.POSITIVE_INFINITY;
    }

    public static boolean contains(double[] array2, double target2) {
        for (double value2 : array2) {
            if (value2 != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(double[] array2, double target2) {
        return Doubles.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(double[] array2, double target2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] array2, double[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array2, double target2) {
        return Doubles.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(double[] array2, double target2, int start2, int end) {
        for (int i2 = end - 1; i2 >= start2; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double min(double ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        double min = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            min = Math.min(min, array2[i2]);
        }
        return min;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double max(double ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        double max = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            max = Math.max(max, array2[i2]);
        }
        return max;
    }

    public static double constrainToRange(double value2, double min, double max) {
        if (min <= max) {
            return Math.min(Math.max(value2, min), max);
        }
        throw new IllegalArgumentException(Strings.lenientFormat("min (%s) must be less than or equal to max (%s)", min, max));
    }

    public static double[] concat(double[] ... arrays) {
        int length = 0;
        for (double[] array2 : arrays) {
            length += array2.length;
        }
        double[] result2 = new double[length];
        int pos = 0;
        for (double[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static Converter<String, Double> stringConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static double[] ensureCapacity(double[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, double ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 12);
        builder.append(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(double[] array2) {
        Preconditions.checkNotNull(array2);
        Doubles.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(double[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Doubles.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(double[] array2) {
        Preconditions.checkNotNull(array2);
        Doubles.reverse(array2, 0, array2.length);
    }

    public static void reverse(double[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            double tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(double[] array2, int distance) {
        Doubles.rotate(array2, distance, 0, array2.length);
    }

    public static void rotate(double[] array2, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m = -distance % length;
        m = m < 0 ? m + length : m;
        int newFirstIndex = m + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Doubles.reverse(array2, fromIndex, newFirstIndex);
        Doubles.reverse(array2, newFirstIndex, toIndex);
        Doubles.reverse(array2, fromIndex, toIndex);
    }

    public static double[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        double[] array2 = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).doubleValue();
        }
        return array2;
    }

    public static List<Double> asList(double ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(backingArray);
    }

    @GwtIncompatible
    private static Pattern fpPattern() {
        String decimal = "(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)";
        String completeDec = decimal + "(?:[eE][+-]?\\d+#)?[fFdD]?";
        String hex = "(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)";
        String completeHex = "0[xX]" + hex + "[pP][+-]?\\d+#[fFdD]?";
        String fpPattern = "[+-]?(?:NaN|Infinity|" + completeDec + "|" + completeHex + ")";
        fpPattern = fpPattern.replace("#", "+");
        return Pattern.compile(fpPattern);
    }

    @CheckForNull
    @GwtIncompatible
    public static Double tryParse(String string) {
        if (FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        DoubleArrayAsList(double[] array2) {
            this(array2, 0, array2.length);
        }

        DoubleArrayAsList(double[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Double get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfDouble spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@CheckForNull Object target2) {
            return target2 instanceof Double && Doubles.indexOf(this.array, (Double)target2, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Double && (i2 = Doubles.indexOf(this.array, (Double)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Double && (i2 = Doubles.lastIndexOf(this.array, (Double)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int index, Double element) {
            Preconditions.checkElementIndex(index, this.size());
            double oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList that = (DoubleArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Doubles.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        double[] toDoubleArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] left, double[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Double.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Doubles.lexicographicalComparator()";
        }
    }

    private static final class DoubleConverter
    extends Converter<String, Double>
    implements Serializable {
        static final Converter<String, Double> INSTANCE = new DoubleConverter();
        private static final long serialVersionUID = 1L;

        private DoubleConverter() {
        }

        @Override
        protected Double doForward(String value2) {
            return Double.valueOf(value2);
        }

        @Override
        protected String doBackward(Double value2) {
            return value2.toString();
        }

        public String toString() {
            return "Doubles.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

