/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleSdk;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u0012H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XcodeEnvironment;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getBuildType", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "builtProductsDir", "Ljava/io/File;", "getBuiltProductsDir", "()Ljava/io/File;", "embeddedFrameworksDir", "getEmbeddedFrameworksDir", "frameworkSearchDir", "getFrameworkSearchDir", "sign", "", "getSign", "()Ljava/lang/String;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getTargets", "()Ljava/util/List;", "userScriptSandboxingEnabled", "", "getUserScriptSandboxingEnabled", "()Z", "readEnvVariable", "name", "toString", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nXcodeEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcodeEnvironment.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/XcodeEnvironment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class XcodeEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String XCODE_ENVIRONMENT_OVERRIDE_KEY = "kotlin.envOverride";

    public XcodeEnvironment(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final NativeBuildType getBuildType() {
        String string = this.readEnvVariable("CONFIGURATION");
        if (string == null) {
            return null;
        }
        String configuration2 = string;
        Object object = XcodeEnvironment._get_buildType_$toNativeBuildType(configuration2);
        if (object == null) {
            String string2 = this.readEnvVariable("KOTLIN_FRAMEWORK_BUILD_TYPE");
            object = string2 != null ? XcodeEnvironment._get_buildType_$toNativeBuildType(string2) : null;
        }
        return object;
    }

    @NotNull
    public final List<KonanTarget> getTargets() {
        String[] stringArray;
        String string = this.readEnvVariable("SDK_NAME");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String sdk = string;
        Object object = this.readEnvVariable("ARCHS");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
            return CollectionsKt.emptyList();
        }
        Object archs = object;
        return AppleSdk.INSTANCE.defineNativeTargets(sdk, (List<String>)archs);
    }

    @Nullable
    public final File getFrameworkSearchDir() {
        String string = this.readEnvVariable("CONFIGURATION");
        if (string == null) {
            return null;
        }
        String configuration2 = string;
        String string2 = this.readEnvVariable("SDK_NAME");
        if (string2 == null) {
            return null;
        }
        String sdk = string2;
        return new File(configuration2, sdk);
    }

    @Nullable
    public final File getBuiltProductsDir() {
        File file;
        String string = this.readEnvVariable("BUILT_PRODUCTS_DIR");
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            file = new File(p0);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getEmbeddedFrameworksDir() {
        String string = this.readEnvVariable("TARGET_BUILD_DIR");
        if (string == null) {
            return null;
        }
        String xcodeTargetBuildDir = string;
        String string2 = this.readEnvVariable("FRAMEWORKS_FOLDER_PATH");
        if (string2 == null) {
            return null;
        }
        String xcodeFrameworksFolderPath = string2;
        return new File(xcodeTargetBuildDir, xcodeFrameworksFolderPath).getAbsoluteFile();
    }

    @Nullable
    public final String getSign() {
        return this.readEnvVariable("EXPANDED_CODE_SIGN_IDENTITY");
    }

    public final boolean getUserScriptSandboxingEnabled() {
        return Intrinsics.areEqual((Object)this.readEnvVariable("ENABLE_USER_SCRIPT_SANDBOXING"), (Object)"YES");
    }

    private final String readEnvVariable(String name2) {
        ExtraPropertiesExtension extraPropertiesExtension = this.project.getExtensions().getExtraProperties();
        Intrinsics.checkNotNullExpressionValue((Object)extraPropertiesExtension, (String)"project.extensions.extraProperties");
        Object object = GradleUtilsKt.getOrNull(extraPropertiesExtension, "kotlin.envOverride." + name2);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = System.getenv(name2);
        }
        return string;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n        XcodeEnvironment:\n          buildType=" + this.getBuildType() + "\n          targets=" + this.getTargets() + "\n          frameworkSearchDir=" + this.getFrameworkSearchDir() + "\n          builtProductDir=" + this.getBuiltProductsDir() + "\n          embeddedFrameworksDir=" + this.getEmbeddedFrameworksDir() + "\n          sign=" + this.getSign() + "\n          userScriptSandboxingEnabled=" + this.getUserScriptSandboxingEnabled() + "\n    "));
    }

    private static final NativeBuildType _get_buildType_$toNativeBuildType(String $this$_get_buildType__u24toNativeBuildType) {
        String string = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)$this$_get_buildType__u24toNativeBuildType);
        return Intrinsics.areEqual((Object)string, (Object)"debug") ? NativeBuildType.DEBUG : (Intrinsics.areEqual((Object)string, (Object)"release") ? NativeBuildType.RELEASE : null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XcodeEnvironment$Companion;", "", "()V", "XCODE_ENVIRONMENT_OVERRIDE_KEY", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

