/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB5\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\"\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000ej\b\u0012\u0004\u0012\u00020\t`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "logger", "Lorg/gradle/api/logging/Logger;", "delegate", "acceptableMessageSeverity", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "kotlinPluginVersion", "", "(Lorg/gradle/api/logging/Logger;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Ljava/lang/String;)V", "errors", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "clear", "", "flush", "files", "", "Ljava/io/File;", "hasErrors", "", "report", "error", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "severity", "message", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGradleErrorMessageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleErrorMessageCollector.kt\norg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class GradleErrorMessageCollector
implements MessageCollector {
    @NotNull
    private final KotlinLogger logger;
    @Nullable
    private final MessageCollector delegate;
    @NotNull
    private final List<CompilerMessageSeverity> acceptableMessageSeverity;
    @Nullable
    private final String kotlinPluginVersion;
    @NotNull
    private final ArrayList<String> errors;

    public GradleErrorMessageCollector(@NotNull KotlinLogger logger, @Nullable MessageCollector delegate2, @NotNull List<? extends CompilerMessageSeverity> acceptableMessageSeverity, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(acceptableMessageSeverity, (String)"acceptableMessageSeverity");
        this.logger = logger;
        this.delegate = delegate2;
        this.acceptableMessageSeverity = acceptableMessageSeverity;
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.errors = new ArrayList();
    }

    public /* synthetic */ GradleErrorMessageCollector(KotlinLogger kotlinLogger2, MessageCollector messageCollector, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            messageCollector = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)CompilerMessageSeverity.EXCEPTION);
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(kotlinLogger2, messageCollector, (List<? extends CompilerMessageSeverity>)list, string);
    }

    public GradleErrorMessageCollector(@NotNull Logger logger, @Nullable MessageCollector delegate2, @NotNull List<? extends CompilerMessageSeverity> acceptableMessageSeverity, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(acceptableMessageSeverity, (String)"acceptableMessageSeverity");
        this(new GradleKotlinLogger(logger, null, 2, null), delegate2, acceptableMessageSeverity, kotlinPluginVersion);
    }

    public /* synthetic */ GradleErrorMessageCollector(Logger logger, MessageCollector messageCollector, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            messageCollector = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)CompilerMessageSeverity.EXCEPTION);
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(logger, messageCollector, (List<? extends CompilerMessageSeverity>)list, string);
    }

    public void clear() {
        MessageCollector messageCollector = this.delegate;
        if (messageCollector != null) {
            messageCollector.clear();
        }
        this.errors.clear();
    }

    public final void report(@NotNull Throwable error, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.report(CompilerMessageSeverity.EXCEPTION, error.getMessage() + '\n' + ExceptionsKt.stackTraceToString((Throwable)error), location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageCollector messageCollector = this.delegate;
        if (messageCollector != null) {
            messageCollector.report(severity, message2, location);
        }
        if (this.acceptableMessageSeverity.contains(severity)) {
            ArrayList<String> arrayList = this.errors;
            synchronized (arrayList) {
                boolean bl = false;
                boolean bl2 = this.errors.add(message2);
            }
        }
    }

    public boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@NotNull Set<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (!this.hasErrors()) {
            return;
        }
        for (File file : files2) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                if (this.kotlinPluginVersion != null) {
                    String string;
                    String version2 = string;
                    boolean bl2 = false;
                    it.append("kotlin version: " + version2 + '\n');
                }
                for (String error : this.errors) {
                    it.append("error message: " + error + "\n\n");
                }
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.logger.debug(((Collection)this.errors).size() + " errors were stored into file " + file.getAbsolutePath());
        }
        this.clear();
    }
}

