/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Map;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingObject;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMapEntry<K, V>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    @Override
    protected abstract Map.Entry<K, V> delegate();

    @Override
    @ParametricNullness
    public K getKey() {
        return this.delegate().getKey();
    }

    @Override
    @ParametricNullness
    public V getValue() {
        return this.delegate().getValue();
    }

    @Override
    @ParametricNullness
    public V setValue(@ParametricNullness V value2) {
        return this.delegate().setValue(value2);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardEquals(@CheckForNull Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    protected int standardHashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    protected String standardToString() {
        return this.getKey() + "=" + this.getValue();
    }
}

