/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.reflect;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.base.Function;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMap;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingSet;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.reflect.TypeToInstanceMap;
import org.jetbrains.kotlin.com.google.common.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@Beta
public final class MutableTypeToInstanceMap<B>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends B>, B> backingMap = Maps.newHashMap();

    @Override
    public <T extends B> @Nullable T getInstance(Class<T> type) {
        return this.trustedGet(TypeToken.of(type));
    }

    @Override
    public <T extends B> @Nullable T getInstance(TypeToken<T> type) {
        return this.trustedGet(type.rejectTypeVariables());
    }

    @Override
    @CanIgnoreReturnValue
    public <T extends B> @Nullable T putInstance(Class<T> type, @Nullable T value2) {
        return this.trustedPut(TypeToken.of(type), value2);
    }

    @Override
    @CanIgnoreReturnValue
    public <T extends B> @Nullable T putInstance(TypeToken<T> type, @Nullable T value2) {
        return this.trustedPut(type.rejectTypeVariables(), value2);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public B put(TypeToken<? extends B> key, B value2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends TypeToken<? extends B>, ? extends B> map2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    public Set<Map.Entry<TypeToken<? extends B>, B>> entrySet() {
        return UnmodifiableEntry.transformEntries(super.entrySet());
    }

    @Override
    protected Map<TypeToken<? extends B>, B> delegate() {
        return this.backingMap;
    }

    private <T extends B> @Nullable T trustedPut(TypeToken<T> type, @Nullable T value2) {
        return (T)this.backingMap.put(type, value2);
    }

    private <T extends B> @Nullable T trustedGet(TypeToken<T> type) {
        return (T)this.backingMap.get(type);
    }

    private static final class UnmodifiableEntry<K, V>
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        static <K, V> Set<Map.Entry<K, V>> transformEntries(final Set<Map.Entry<K, V>> entries2) {
            return new ForwardingSet<Map.Entry<K, V>>(){

                @Override
                protected Set<Map.Entry<K, V>> delegate() {
                    return entries2;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return UnmodifiableEntry.transformEntries(super.iterator());
                }

                @Override
                public Object[] toArray() {
                    return this.standardToArray();
                }

                @Override
                public <T> T[] toArray(T[] array2) {
                    return this.standardToArray(array2);
                }
            };
        }

        private static <K, V> Iterator<Map.Entry<K, V>> transformEntries(Iterator<Map.Entry<K, V>> entries2) {
            return Iterators.transform(entries2, new Function<Map.Entry<K, V>, Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> apply(Map.Entry<K, V> entry2) {
                    return new UnmodifiableEntry(entry2);
                }
            });
        }

        private UnmodifiableEntry(Map.Entry<K, V> delegate2) {
            this.delegate = Preconditions.checkNotNull(delegate2);
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V setValue(V value2) {
            throw new UnsupportedOperationException();
        }
    }
}

