/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.google.common.collect.Hashing;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.collect.RegularImmutableAsList;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(new Object[0], 0, null, 0);
    private final transient Object[] elements;
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements, int hashCode, Object[] table, int mask) {
        this.elements = elements;
        this.table = table;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    @Override
    public boolean contains(@Nullable Object target2) {
        Object[] table = this.table;
        if (target2 == null || table == null) {
            return false;
        }
        int i2 = Hashing.smearedHash(target2);
        Object candidate;
        while ((candidate = table[i2 &= this.mask]) != null) {
            if (candidate.equals(target2)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.elements.length;
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        System.arraycopy(this.elements, 0, dst, offset, this.elements.length);
        return offset + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

