/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks.artifact;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinArtifactConfig;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J!\u0010\u000f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0010\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\rH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/artifact/KotlinArtifactConfigImpl;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinArtifactConfig;", "artifactName", "", "(Ljava/lang/String;)V", "getArtifactName", "()Ljava/lang/String;", "modules", "", "", "getModules", "()Ljava/util/Set;", "addModule", "", "project", "setModules", "", "([Ljava/lang/Object;)V", "validate", "kotlin-gradle-plugin_common"})
public abstract class KotlinArtifactConfigImpl
implements KotlinArtifactConfig {
    @NotNull
    private final String artifactName;
    @NotNull
    private final Set<Object> modules;

    public KotlinArtifactConfigImpl(@NotNull String artifactName) {
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        this.artifactName = artifactName;
        this.modules = new LinkedHashSet();
    }

    @NotNull
    public String getArtifactName() {
        return this.artifactName;
    }

    @NotNull
    public Set<Object> getModules() {
        return this.modules;
    }

    public void setModules(Object ... project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.getModules().clear();
        CollectionsKt.addAll((Collection)this.getModules(), (Object[])project);
    }

    public void addModule(@NotNull Object project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.getModules().add(project);
    }

    protected void validate() {
        if (!(!((Collection)this.getModules()).isEmpty())) {
            boolean bl = false;
            String string = "Native artifact '" + this.getArtifactName() + "' wasn't configured because it requires at least one module for linking";
            throw new IllegalStateException(string.toString());
        }
    }
}

