/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.report.HttpReportService;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/report/HttpReportServiceImpl;", "Lorg/jetbrains/kotlin/gradle/report/HttpReportService;", "Ljava/io/Serializable;", "httpSettings", "Lorg/jetbrains/kotlin/gradle/report/HttpReportSettings;", "(Lorg/jetbrains/kotlin/gradle/report/HttpReportSettings;)V", "url", "", "password", "user", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "invalidUrl", "", "requestPreviousFailed", "checkResponseAndLog", "", "connection", "Ljava/net/HttpURLConnection;", "log", "Lorg/gradle/api/logging/Logger;", "sendData", "data", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nHttpService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpService.kt\norg/jetbrains/kotlin/gradle/report/HttpReportServiceImpl\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,82:1\n17#2,6:83\n*E\n*S KotlinDebug\n*F\n+ 1 HttpService.kt\norg/jetbrains/kotlin/gradle/report/HttpReportServiceImpl\n*L\n45#1,6:83\n*E\n"})
public final class HttpReportServiceImpl
implements HttpReportService,
Serializable {
    @NotNull
    private final String url;
    @Nullable
    private final String password;
    @Nullable
    private final String user;
    private boolean invalidUrl;
    private boolean requestPreviousFailed;

    public HttpReportServiceImpl(@NotNull String url, @Nullable String password, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.password = password;
        this.user = user;
    }

    public HttpReportServiceImpl(@NotNull HttpReportSettings httpSettings) {
        Intrinsics.checkNotNullParameter((Object)httpSettings, (String)"httpSettings");
        this(httpSettings.getUrl(), httpSettings.getPassword(), httpSettings.getUser());
    }

    private final void checkResponseAndLog(HttpURLConnection connection, Logger log) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n < 300 : false);
        if (isResponseBad) {
            String message2 = "Failed to send statistic to " + connection.getURL() + " with " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            if (!this.requestPreviousFailed) {
                log.warn(message2);
            } else {
                log.debug(message2);
            }
            this.requestPreviousFailed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(@NotNull Object data, @NotNull Logger log) {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.invalidUrl) {
            return;
        }
        try {
            URLConnection uRLConnection = new URL(this.url).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        catch (IOException e) {
            log.warn("Unable to open connection to " + this.url + ": " + e.getMessage());
            this.invalidUrl = true;
            return;
        }
        HttpURLConnection connection = httpURLConnection;
        try {
            Object auth;
            Charset charset;
            Object object;
            if (this.user != null && this.password != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = (this.user + ':' + this.password).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n           \u2026password}\".toByteArray())");
                object = byArray2;
                charset = Charsets.UTF_8;
                auth = new String((byte[])object, charset);
                connection.addRequestProperty("Authorization", "Basic " + (String)auth);
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object = null;
            try {
                OutputStream it = (OutputStream)auth;
                boolean bl2 = false;
                String string = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(data)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                charset = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object);
            }
            connection.connect();
            this.checkResponseAndLog(connection, log);
        }
        catch (Exception e) {
            log.debug("Unexpected exception happened " + e.getMessage() + ": " + e.getStackTrace());
            this.checkResponseAndLog(connection, log);
        }
        finally {
            connection.disconnect();
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        log.debug("Report statistic by http takes " + elapsedTime + " ms");
    }
}

