/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.graph.MapIteratorCache;

class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    private volatile transient @Nullable CacheEntry<K, V> cacheEntry1;
    private volatile transient @Nullable CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    public V get(@Nullable Object key) {
        V value = this.getIfCached(key);
        if (value != null) {
            return value;
        }
        value = this.getWithoutCaching(key);
        if (value != null) {
            this.addToCache(key, value);
        }
        return value;
    }

    @Override
    protected V getIfCached(@Nullable Object key) {
        Object value = super.getIfCached(key);
        if (value != null) {
            return value;
        }
        CacheEntry<K, V> entry2 = this.cacheEntry1;
        if (entry2 != null && entry2.key == key) {
            return entry2.value;
        }
        entry2 = this.cacheEntry2;
        if (entry2 != null && entry2.key == key) {
            this.addToCache(entry2);
            return entry2.value;
        }
        return null;
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key, V value) {
        this.addToCache(new CacheEntry<K, V>(key, value));
    }

    private void addToCache(CacheEntry<K, V> entry2) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry2;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

