/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.work.NormalizeLineEndings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeCInteropRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.internal.IdeaKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.DefaultCInteropSettings;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.GradleKpmVariantCompilationDataInternalKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.targets.native.tasks.CInteropRunnerExecutionContextFactoryKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.gradle.utils.KlibUtilsKt;
import org.jetbrains.kotlin.konan.CompilerVersion;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010G\u001a\u00020HH\u0007R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\rR\u0011\u0010#\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010+\u001a\u00020,8G\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010/\u001a\u0002008G\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b6\u0010&R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138G\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0015R\u0013\u00109\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0018R\u0013\u0010=\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0011R\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001cR\u0013\u0010A\u001a\u0004\u0018\u00010\u000f8G\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0011R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CInteropProcess;", "Lorg/gradle/api/DefaultTask;", "settings", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "allHeadersDirs", "", "Ljava/io/File;", "getAllHeadersDirs", "()Ljava/util/Set;", "baseKlibName", "", "getBaseKlibName", "()Ljava/lang/String;", "compilerOpts", "", "getCompilerOpts", "()Ljava/util/List;", "defFile", "getDefFile", "()Ljava/io/File;", "destinationDir", "Lorg/gradle/api/provider/Provider;", "getDestinationDir", "()Lorg/gradle/api/provider/Provider;", "setDestinationDir", "(Lorg/gradle/api/provider/Provider;)V", "extraOpts", "getExtraOpts", "headerFilterDirs", "getHeaderFilterDirs", "headers", "Lorg/gradle/api/file/FileCollection;", "getHeaders", "()Lorg/gradle/api/file/FileCollection;", "interopName", "getInteropName", "isInIdeaSync", "", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "konanVersion", "Lorg/jetbrains/kotlin/konan/CompilerVersion;", "getKonanVersion", "()Lorg/jetbrains/kotlin/konan/CompilerVersion;", "libDirectories", "Ljava/nio/file/Path;", "libraries", "getLibraries", "linkerOpts", "getLinkerOpts", "moduleName", "getModuleName", "outputFile", "getOutputFile", "outputFileName", "getOutputFileName", "outputFileProvider", "getOutputFileProvider", "packageName", "getPackageName", "runnerSettings", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings;", "getSettings", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "processInterop", "", "kotlin-gradle-plugin_common"})
public class CInteropProcess
extends DefaultTask {
    @Internal
    @NotNull
    private final DefaultCInteropSettings settings;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ExecOperations execOperations;
    @Internal
    public Provider<File> destinationDir;
    @NotNull
    private final KonanTarget konanTarget;
    @NotNull
    private final CompilerVersion konanVersion;
    @NotNull
    private final String interopName;
    @NotNull
    private final String baseKlibName;
    @NotNull
    private final String outputFileName;
    @NotNull
    private final String moduleName;
    @NotNull
    private final KotlinNativeToolRunner.Settings runnerSettings;
    @OutputFile
    @NotNull
    private final Provider<File> outputFileProvider;
    @NotNull
    private final List<Path> libDirectories;
    private final boolean isInIdeaSync;

    /*
     * WARNING - void declaration
     */
    @Inject
    public CInteropProcess(@NotNull DefaultCInteropSettings settings, @NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        void $this$outputFileName_u24lambda_u242;
        CompilerOutputKind $this$baseKlibName_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.settings = settings;
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.konanTarget = this.settings.getCompilation().getKonanTarget();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.konanVersion = NativeToolRunnersKt.getKonanVersion(project);
        this.interopName = this.settings.getName();
        CInteropProcess cInteropProcess = this;
        CInteropProcess cInteropProcess2 = this;
        boolean bl = false;
        KotlinCompilationData it = ((CInteropProcess)((Object)$this$baseKlibName_u24lambda_u241)).settings.getCompilation();
        boolean bl2 = false;
        String compilationPrefix = GradleKpmVariantCompilationDataInternalKt.isMainCompilationData(it) ? $this$baseKlibName_u24lambda_u241.getProject().getName() : it.getCompilationPurpose();
        cInteropProcess2.baseKlibName = compilationPrefix + "-cinterop-" + ((CInteropProcess)((Object)$this$baseKlibName_u24lambda_u241)).interopName;
        $this$baseKlibName_u24lambda_u241 = CompilerOutputKind.LIBRARY;
        cInteropProcess2 = this;
        boolean bl3 = false;
        cInteropProcess2.outputFileName = this.baseKlibName + $this$outputFileName_u24lambda_u242.suffix(this.konanTarget);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.moduleName = KlibUtilsKt.klibModuleName(project2, this.baseKlibName);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        this.runnerSettings = KotlinNativeToolRunner.Settings.Companion.fromProject(project3);
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ CInteropProcess this$0;
            {
                this.this$0 = $receiver;
            }

            public final File call() {
                Object object = this.this$0.getDestinationDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destinationDir.get()");
                return FilesKt.resolve((File)((File)object), (String)this.this$0.getOutputFileName());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider { desti\u2026resolve(outputFileName) }");
        this.outputFileProvider = provider;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        this.libDirectories = KotlinNativeTasksKt.access$buildLibDirectories(project4);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        this.isInIdeaSync = IdeaKt.isInIdeaSync(project5);
    }

    @NotNull
    public final DefaultCInteropSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Provider<File> getDestinationDir() {
        Provider<File> provider = this.destinationDir;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDir");
        return null;
    }

    public final void setDestinationDir(@NotNull Provider<File> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.destinationDir = provider;
    }

    @Input
    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.konanTarget;
    }

    @Input
    @NotNull
    public final CompilerVersion getKonanVersion() {
        return this.konanVersion;
    }

    @Input
    @NotNull
    public final String getInteropName() {
        return this.interopName;
    }

    @Input
    @NotNull
    public final String getBaseKlibName() {
        return this.baseKlibName;
    }

    @Internal
    @NotNull
    public final String getOutputFileName() {
        return this.outputFileName;
    }

    @Input
    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @Internal
    @NotNull
    public final File getOutputFile() {
        Object object = this.outputFileProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFileProvider.get()");
        return (File)object;
    }

    @NotNull
    public final Provider<File> getOutputFileProvider() {
        return this.outputFileProvider;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NormalizeLineEndings
    @NotNull
    public final File getDefFile() {
        Object object = this.settings.getDefFileProperty().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settings.defFileProperty.get()");
        return (File)object;
    }

    @Optional
    @Input
    @Nullable
    public final String getPackageName() {
        return this.settings.getPackageName();
    }

    @Input
    @NotNull
    public final List<String> getCompilerOpts() {
        return this.settings.getCompilerOpts();
    }

    @Input
    @NotNull
    public final List<String> getLinkerOpts() {
        return this.settings.getLinkerOpts();
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @NormalizeLineEndings
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getHeaders() {
        return this.settings.getHeaders();
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final Set<File> getAllHeadersDirs() {
        Set set2 = this.settings.getIncludeDirs().getAllHeadersDirs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settings.includeDirs.allHeadersDirs.files");
        return set2;
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final Set<File> getHeaderFilterDirs() {
        Set set2 = this.settings.getIncludeDirs().getHeaderFilterDirs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settings.includeDirs.headerFilterDirs.files");
        return set2;
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @NormalizeLineEndings
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getLibraries() {
        return KotlinNativeTasksKt.access$filterOutPublishableInteropLibs(this.settings.getDependencyFiles(), this.libDirectories);
    }

    @Input
    @NotNull
    public final List<String> getExtraOpts() {
        return this.settings.getExtraOpts();
    }

    @TaskAction
    public final void processInterop() {
        File it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it2;
        List list2;
        List $this$processInterop_u24lambda_u248 = list2 = (List)new ArrayList();
        boolean bl = false;
        String string = this.getOutputFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile.absolutePath");
        KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u248, "-o", string);
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u248, "-target", this.konanTarget.getVisibleName());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u248, "-def", this.getDefFile().getCanonicalPath());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u248, "-pkg", this.getPackageName());
        KotlinNativeTasksKt.addFileArgs($this$processInterop_u24lambda_u248, "-header", this.getHeaders());
        Iterable $this$forEach$iv = this.getCompilerOpts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl2 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u248, "-compiler-option", it2);
        }
        $this$forEach$iv = this.getLinkerOpts();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl3 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u248, "-linker-option", it2);
        }
        Set set2 = this.getLibraries().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"libraries.files");
        $this$forEach$iv = KotlinNativeTasksKt.filterKlibsPassedToCompiler(set2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File library2 = (File)element$iv;
            boolean bl4 = false;
            String string2 = library2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"library.absolutePath");
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u248, "-library", string2);
        }
        $this$forEach$iv = this.getAllHeadersDirs();
        String string3 = "-compiler-option";
        List list3 = $this$processInterop_u24lambda_u248;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add("-I" + it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string3, (Iterable<String>)collection);
        $this$map$iv = this.getHeaderFilterDirs();
        string3 = "-headerFilterAdditionalSearchPrefix";
        list3 = $this$processInterop_u24lambda_u248;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string3, (Iterable<String>)collection);
        if (KotlinNativeTargetPresetKt.isAtLeast(this.konanVersion, 1, 4, 0)) {
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u248, "-Xmodule-name", this.moduleName);
        }
        $this$processInterop_u24lambda_u248.addAll((Collection)this.getExtraOpts());
        List args = list2;
        this.getOutputFile().getParentFile().mkdirs();
        Task task2 = (Task)this;
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KotlinNativeCInteropRunner.Companion.run(CInteropRunnerExecutionContextFactoryKt.createExecutionContext(KotlinNativeCInteropRunner.Companion, task2, this.isInIdeaSync, this.runnerSettings, KotlinToolRunner.GradleExecutionContext.Companion.fromTaskContext(this.objectFactory, this.execOperations, logger)), args);
    }
}

