/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.tasks.DummyFrameworkTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\bH\u0002J0\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0002J.\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00042\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\b\u0010\"\u001a\u00020\u0018H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/DummyFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "destinationDir", "Ljava/io/File;", "getDestinationDir", "()Ljava/io/File;", "dummyFrameworkPath", "", "getDummyFrameworkPath", "()Ljava/lang/String;", "frameworkDir", "getFrameworkDir", "frameworkName", "Lorg/gradle/api/provider/Provider;", "getFrameworkName", "()Lorg/gradle/api/provider/Provider;", "setFrameworkName", "(Lorg/gradle/api/provider/Provider;)V", "useDynamicFramework", "", "getUseDynamicFramework", "setUseDynamicFramework", "copyFrameworkFile", "", "relativeFrom", "relativeTo", "copyFrameworkTextFile", "transform", "Lkotlin/Function1;", "copyResource", "from", "to", "copyTextResource", "create", "kotlin-gradle-plugin"})
public class DummyFrameworkTask
extends DefaultTask {
    @OutputDirectory
    @NotNull
    private final File destinationDir;
    @Input
    public Provider<String> frameworkName;
    @Input
    public Provider<Boolean> useDynamicFramework;

    public DummyFrameworkTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.destinationDir = KotlinCocoapodsPluginKt.getCocoapodsBuildDirs(project).getFramework();
    }

    @NotNull
    public final File getDestinationDir() {
        return this.destinationDir;
    }

    @NotNull
    public final Provider<String> getFrameworkName() {
        Provider<String> provider = this.frameworkName;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frameworkName");
        return null;
    }

    public final void setFrameworkName(@NotNull Provider<String> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.frameworkName = provider;
    }

    @NotNull
    public final Provider<Boolean> getUseDynamicFramework() {
        Provider<Boolean> provider = this.useDynamicFramework;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"useDynamicFramework");
        return null;
    }

    public final void setUseDynamicFramework(@NotNull Provider<Boolean> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.useDynamicFramework = provider;
    }

    private final File getFrameworkDir() {
        return FilesKt.resolve((File)this.destinationDir, (String)Intrinsics.stringPlus((String)((String)this.getFrameworkName().get()), (Object)".framework"));
    }

    private final String getDummyFrameworkPath() {
        Object object = this.getUseDynamicFramework().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"useDynamicFramework.get()");
        String staticOrDynamic = (Boolean)object != false ? "dynamic" : "static";
        return "/cocoapods/" + staticOrDynamic + "/dummy.framework/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(String from, File to) {
        to.getParentFile().mkdirs();
        Closeable closeable = new FileOutputStream(to);
        Throwable throwable = null;
        try {
            long l;
            FileOutputStream file = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = ((Object)((Object)this)).getClass().getResourceAsStream(from);
            Throwable throwable2 = null;
            try {
                InputStream resource = (InputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
                l = ByteStreamsKt.copyTo$default((InputStream)resource, (OutputStream)file, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyTextResource(String from, File to, Function1<? super String, String> transform) {
        to.getParentFile().mkdirs();
        Object object = to;
        Object object2 = Charsets.UTF_8;
        File file = object;
        int n = 8192;
        boolean bl = false;
        Object object3 = file;
        boolean bl2 = false;
        Object object4 = object3;
        boolean bl3 = false;
        object4 = new FileOutputStream((File)object4);
        bl3 = false;
        object3 = new OutputStreamWriter((OutputStream)object4, (Charset)object2);
        bl2 = false;
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter file2 = (PrintWriter)object;
            boolean bl4 = false;
            Closeable closeable = ((Object)((Object)this)).getClass().getResourceAsStream(from);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                object4 = it;
                Charset charset = Charsets.UTF_8;
                TextStreamsKt.forEachLine((Reader)new InputStreamReader((InputStream)object4, charset), (Function1)((Function1)new Function1<String, Unit>(file2, transform){
                    final /* synthetic */ PrintWriter $file;
                    final /* synthetic */ Function1<String, String> $transform;
                    {
                        this.$file = $file;
                        this.$transform = $transform;
                        super(1);
                    }

                    public final void invoke(@NotNull String str) {
                        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                        this.$file.println((String)this.$transform.invoke((Object)str));
                    }
                }));
                object3 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    static /* synthetic */ void copyTextResource$default(DummyFrameworkTask dummyFrameworkTask, String string, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTextResource");
        }
        if ((n & 4) != 0) {
            function1 = copyTextResource.1.INSTANCE;
        }
        dummyFrameworkTask.copyTextResource(string, file, (Function1<? super String, String>)function1);
    }

    private final void copyFrameworkFile(String relativeFrom, String relativeTo) {
        this.copyResource(Intrinsics.stringPlus((String)this.getDummyFrameworkPath(), (Object)relativeFrom), FilesKt.resolve((File)this.getFrameworkDir(), (String)relativeTo));
    }

    static /* synthetic */ void copyFrameworkFile$default(DummyFrameworkTask dummyFrameworkTask, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyFrameworkFile");
        }
        if ((n & 2) != 0) {
            string2 = string;
        }
        dummyFrameworkTask.copyFrameworkFile(string, string2);
    }

    private final void copyFrameworkTextFile(String relativeFrom, String relativeTo, Function1<? super String, String> transform) {
        this.copyTextResource(Intrinsics.stringPlus((String)this.getDummyFrameworkPath(), (Object)relativeFrom), FilesKt.resolve((File)this.getFrameworkDir(), (String)relativeTo), transform);
    }

    static /* synthetic */ void copyFrameworkTextFile$default(DummyFrameworkTask dummyFrameworkTask, String string, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyFrameworkTextFile");
        }
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 4) != 0) {
            function1 = copyFrameworkTextFile.1.INSTANCE;
        }
        dummyFrameworkTask.copyFrameworkTextFile(string, string2, (Function1<? super String, String>)function1);
    }

    @TaskAction
    public final void create() {
        Object object = this.destinationDir;
        File $this$create_u24lambda_u2d4 = object;
        boolean bl = false;
        FilesKt.deleteRecursively((File)$this$create_u24lambda_u2d4);
        $this$create_u24lambda_u2d4.mkdirs();
        DummyFrameworkTask.copyFrameworkFile$default(this, "Info.plist", null, 2, null);
        object = this.getFrameworkName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"frameworkName.get()");
        this.copyFrameworkFile("dummy", (String)object);
        DummyFrameworkTask.copyFrameworkFile$default(this, "Headers/placeholder.h", null, 2, null);
        DummyFrameworkTask.copyFrameworkTextFile$default(this, "Modules/module.modulemap", null, (Function1)new Function1<String, String>(this){
            final /* synthetic */ DummyFrameworkTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it, (Object)"framework module dummy {")) {
                    Object object = this.this$0.getFrameworkName().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"frameworkName.get()");
                    string = StringsKt.replace$default((String)it, (String)"dummy", (String)((String)object), (boolean)false, (int)4, null);
                } else {
                    string = it;
                }
                return string;
            }
        }, 2, null);
    }
}

