/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.ExecAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.ExecKt;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmApi;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmDependency;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolved.KotlinCompilationNpmResolution;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnBasics;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnEntryRegistry;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnLock;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnPlugin;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JL\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 J\u001e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0004R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnBasics;", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmApi;", "()V", "nonTransitiveResolvedDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency;", "", "Ljava/io/File;", "transitiveResolvedDependencies", "resolveDependency", "npmResolution", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolved/KotlinCompilationNpmResolution;", "dependency", "transitive", "", "setup", "", "project", "Lorg/gradle/api/Project;", "yarnExec", "services", "Lorg/gradle/internal/service/ServiceRegistry;", "logger", "Lorg/gradle/api/logging/Logger;", "nodeJs", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "command", "", "isStandalone", "dir", "description", "args", "", "yarnLockReadTransitiveDependencies", "nodeWorkDir", "srcDependenciesList", "", "kotlin-gradle-plugin"})
public abstract class YarnBasics
implements NpmApi {
    @NotNull
    private final Map<NpmDependency, Set<File>> nonTransitiveResolvedDependencies = new LinkedHashMap();
    @NotNull
    private final Map<NpmDependency, Set<File>> transitiveResolvedDependencies = new LinkedHashMap();

    @Override
    public void setup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        YarnPlugin.Companion.apply(project).executeSetup$kotlin_gradle_plugin();
    }

    public final void yarnExec(@NotNull ServiceRegistry services, @NotNull Logger logger, @NotNull NodeJsRootExtension nodeJs, @NotNull String command, boolean isStandalone, @NotNull File dir2, @NotNull String description, @NotNull List<String> args) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)nodeJs, (String)"nodeJs");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        ExecKt.execWithProgress$default(services, description, false, (Function1)new Function1<ExecAction, Unit>(args, logger, nodeJs, isStandalone, command, dir2){
            final /* synthetic */ List<String> $args;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ NodeJsRootExtension $nodeJs;
            final /* synthetic */ boolean $isStandalone;
            final /* synthetic */ String $command;
            final /* synthetic */ File $dir;
            {
                this.$args = $args;
                this.$logger = $logger;
                this.$nodeJs = $nodeJs;
                this.$isStandalone = $isStandalone;
                this.$command = $command;
                this.$dir = $dir;
                super(1);
            }

            public final void invoke(@NotNull ExecAction exec2) {
                Intrinsics.checkNotNullParameter((Object)exec2, (String)"exec");
                List arguments2 = CollectionsKt.plus((Collection)this.$args, (Object)(this.$logger.isDebugEnabled() ? "--verbose" : ""));
                String nodeExecutable2 = ((NodeJsEnv)this.$nodeJs.requireConfigured()).getNodeExecutable();
                exec2.environment("PATH", (Object)(nodeExecutable2 + File.pathSeparator + System.getenv("PATH")));
                if (this.$isStandalone) {
                    exec2.setExecutable(this.$command);
                    exec2.setArgs(arguments2);
                } else {
                    exec2.setExecutable(nodeExecutable2);
                    exec2.setArgs(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.$command), (Iterable)arguments2));
                }
                exec2.setWorkingDir(this.$dir);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<File> resolveDependency(@NotNull KotlinCompilationNpmResolution npmResolution, @NotNull NpmDependency dependency2, boolean transitive) {
        Intrinsics.checkNotNullParameter((Object)npmResolution, (String)"npmResolution");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Set<File> files = (transitive ? this.transitiveResolvedDependencies : this.nonTransitiveResolvedDependencies).get(dependency2);
        if (files != null) {
            return files;
        }
        NpmProject npmProject2 = npmResolution.getNpmProject();
        Set all = new LinkedHashSet();
        Object object = npmProject2.resolve$kotlin_gradle_plugin(dependency2.getKey());
        if (object != null) {
            File file;
            File it = file = object;
            boolean bl = false;
            if (it.isFile()) {
                all.add(it);
            }
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            if (StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null)) {
                File kjsmDir;
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
                String baseName2 = StringsKt.removeSuffix((String)string2, (CharSequence)".js");
                File metaJs = new File(Intrinsics.stringPlus((String)baseName2, (Object)".meta.js"));
                if (metaJs.isFile()) {
                    all.add(metaJs);
                }
                if ((kjsmDir = new File(baseName2)).isDirectory()) {
                    void $this$forEach$iv;
                    Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)kjsmDir)), (Function1)resolveDependency.1.1.INSTANCE);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File it2 = (File)element$iv;
                        boolean bl2 = false;
                        all.add(it2);
                    }
                }
            }
        }
        object = this.nonTransitiveResolvedDependencies;
        object.put(dependency2, all);
        if (transitive) {
            Iterable $this$forEach$iv = dependency2.getDependencies$kotlin_gradle_plugin();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set<File> set2;
                NpmDependency it = (NpmDependency)element$iv;
                boolean bl = false;
                Set<File> files2 = set2 = this.resolveDependency(npmResolution, it, transitive);
                boolean bl3 = false;
                all.addAll((Collection)files2);
            }
            object = this.transitiveResolvedDependencies;
            object.put((NpmDependency)dependency2, (Set<File>)all);
        }
        return all;
    }

    protected final void yarnLockReadTransitiveDependencies(@NotNull File nodeWorkDir, @NotNull Collection<NpmDependency> srcDependenciesList) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)nodeWorkDir, (String)"nodeWorkDir");
        Intrinsics.checkNotNullParameter(srcDependenciesList, (String)"srcDependenciesList");
        File it = file2 = FilesKt.resolve((File)nodeWorkDir, (String)"yarn.lock");
        boolean bl = false;
        File file3 = file = it.isFile() ? file2 : null;
        if (file == null) {
            return;
        }
        File yarnLock2 = file;
        YarnEntryRegistry entryRegistry = new YarnEntryRegistry(yarnLock2);
        Map visited = new LinkedHashMap();
        Iterable $this$forEach$iv = srcDependenciesList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NpmDependency src = (NpmDependency)element$iv;
            boolean bl2 = false;
            YarnBasics.yarnLockReadTransitiveDependencies$resolveRecursively(visited, entryRegistry, src);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void yarnLockReadTransitiveDependencies$resolveRecursively(Map<NpmDependency, NpmDependency> visited, YarnEntryRegistry entryRegistry, NpmDependency src) {
        void $this$mapTo$iv;
        if (src.getScope() == NpmDependency.Scope.PEER) {
            return;
        }
        NpmDependency copy = visited.get(src);
        if (copy != null) {
            src.setResolvedVersion$kotlin_gradle_plugin(copy.getResolvedVersion$kotlin_gradle_plugin());
            src.setIntegrity$kotlin_gradle_plugin(copy.getIntegrity$kotlin_gradle_plugin());
            src.getDependencies$kotlin_gradle_plugin().addAll((Collection<NpmDependency>)copy.getDependencies$kotlin_gradle_plugin());
            return;
        }
        Map<NpmDependency, NpmDependency> map = visited;
        map.put(src, src);
        YarnLock.Entry deps = entryRegistry.find(src.getKey(), src.getVersion());
        src.setResolvedVersion$kotlin_gradle_plugin(deps.getVersion());
        src.setIntegrity$kotlin_gradle_plugin(deps.getIntegrity());
        Iterable iterable = deps.getDependencies();
        Collection destination$iv = src.getDependencies$kotlin_gradle_plugin();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string;
            void dep;
            YarnLock.Dependency dependency2 = (YarnLock.Dependency)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            PackageJson.ScopedName scopedName = dep.getScopedName();
            NpmDependency child = new NpmDependency(src.getProject$kotlin_gradle_plugin(), scopedName.toString(), (string = dep.getVersion()) == null ? "*" : string, null, false, 24, null);
            child.setParent$kotlin_gradle_plugin(src);
            YarnBasics.yarnLockReadTransitiveDependencies$resolveRecursively(visited, entryRegistry, child);
            NpmDependency npmDependency = child;
            collection.add(npmDependency);
        }
    }
}

