/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.testing.mocha;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.process.ProcessForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesClientSettings;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesTestExecutionSpec;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.NpmVersions;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.StringsKt;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectKt;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTest;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTestFramework;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinTestRunnerCliArgs;
import org.jetbrains.kotlin.gradle.targets.js.testing.mocha.KotlinMocha;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005H\u0002J.\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.2\u0006\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/mocha/KotlinMocha;", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTestFramework;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "basePath", "", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;Ljava/lang/String;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "isTeamCity", "", "()Z", "isTeamCity$delegate", "Lkotlin/Lazy;", "npmProject", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "project", "Lorg/gradle/api/Project;", "requiredNpmDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "getRequiredNpmDependencies", "()Ljava/util/Set;", "settingsState", "getSettingsState", "()Ljava/lang/String;", "timeout", "getTimeout", "setTimeout", "(Ljava/lang/String;)V", "versions", "Lorg/jetbrains/kotlin/gradle/targets/js/NpmVersions;", "cliArg", "", "cli", "value", "createAdapterJs", "Ljava/io/File;", "file", "createTestExecutionSpec", "Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessagesTestExecutionSpec;", "task", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;", "forkOptions", "Lorg/gradle/process/ProcessForkOptions;", "nodeJsArgs", "", "debug", "getPath", "Companion", "kotlin-gradle-plugin"})
public final class KotlinMocha
implements KotlinJsTestFramework {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient KotlinJsCompilation compilation;
    @NotNull
    private final String basePath;
    @NotNull
    private final transient Project project;
    @NotNull
    private final NpmProject npmProject;
    @NotNull
    private final NpmVersions versions;
    @NotNull
    private final Lazy isTeamCity$delegate;
    @NotNull
    private String timeout;
    @NotNull
    public static final String ADAPTER_NODEJS = "adapter-nodejs.js";
    @NotNull
    private static final String DEFAULT_TIMEOUT = "2s";

    public KotlinMocha(@NotNull KotlinJsCompilation compilation2, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)compilation2, (String)"compilation");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.compilation = compilation2;
        this.basePath = basePath;
        this.project = this.getCompilation().getTarget().getProject();
        this.npmProject = NpmProjectKt.getNpmProject(this.getCompilation());
        Project project = this.project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.versions = NodeJsRootPlugin.Companion.apply(project).getVersions();
        this.isTeamCity$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinMocha this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Gradle gradle = KotlinMocha.access$getProject$p(this.this$0).getGradle();
                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                return ConfigurationCacheKt.isConfigurationCacheAvailable(gradle) ? KotlinMocha.access$getProject$p(this.this$0).getProviders().gradleProperty("teamcity").forUseAtConfigurationTime().isPresent() : KotlinMocha.access$getProject$p(this.this$0).hasProperty("teamcity");
            }
        }));
        this.timeout = DEFAULT_TIMEOUT;
    }

    @Override
    @NotNull
    public KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    private final boolean isTeamCity() {
        Lazy lazy = this.isTeamCity$delegate;
        Object var2_2 = null;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public String getSettingsState() {
        return "mocha";
    }

    @Override
    @NotNull
    public Set<RequiredKotlinJsDependency> getRequiredNpmDependencies() {
        Object[] objectArray = new RequiredKotlinJsDependency[]{this.versions.getKotlinJsTestRunner(), this.versions.getMocha(), this.versions.getSourceMapSupport(), this.versions.getFormatUtil()};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getPath() {
        return Intrinsics.stringPlus((String)this.basePath, (Object)":kotlinMocha");
    }

    @NotNull
    public final String getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.timeout = string;
    }

    @Override
    @NotNull
    public TCServiceMessagesTestExecutionSpec createTestExecutionSpec(@NotNull KotlinJsTest task, @NotNull ProcessForkOptions forkOptions, @NotNull List<String> nodeJsArgs, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)forkOptions, (String)"forkOptions");
        Intrinsics.checkNotNullParameter(nodeJsArgs, (String)"nodeJsArgs");
        String string = task.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
        TCServiceMessagesClientSettings clientSettings2 = new TCServiceMessagesClientSettings(string, task.getTargetName(), true, false, createTestExecutionSpec.clientSettings.1.INSTANCE, true, false, this.isTeamCity(), 72, null);
        KotlinTestRunnerCliArgs cliArgs = new KotlinTestRunnerCliArgs(null, task.getIncludePatterns(), task.getExcludePatterns(), null, 9, null);
        String mocha = this.npmProject.require("mocha/bin/mocha");
        String string2 = ((RegularFile)task.getInputFileProperty().get()).getAsFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.inputFileProperty.get().asFile.toString()");
        String file = string2;
        File adapter = this.createAdapterJs(file);
        Object object = new String[]{"--require", this.npmProject.require("source-map-support/register.js")};
        Object $this$createTestExecutionSpec_u24lambda_u2d0 = object = CollectionsKt.mutableListOf((Object[])object);
        boolean bl = false;
        if (debug) {
            $this$createTestExecutionSpec_u24lambda_u2d0.add("--inspect-brk");
        }
        $this$createTestExecutionSpec_u24lambda_u2d0.add(mocha);
        String string3 = adapter.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"adapter.canonicalPath");
        $this$createTestExecutionSpec_u24lambda_u2d0.add(string3);
        $this$createTestExecutionSpec_u24lambda_u2d0.addAll((Collection)cliArgs.toList());
        $this$createTestExecutionSpec_u24lambda_u2d0.addAll((Collection)this.cliArg("--reporter", "kotlin-test-js-runner/mocha-kotlin-reporter.js"));
        if (debug) {
            $this$createTestExecutionSpec_u24lambda_u2d0.add("--no-timeout");
        } else {
            $this$createTestExecutionSpec_u24lambda_u2d0.addAll((Collection)this.cliArg("--timeout", this.getTimeout()));
        }
        Object args = object;
        return new TCServiceMessagesTestExecutionSpec(forkOptions, (List<String>)args, false, clientSettings2);
    }

    private final List<String> cliArg(String cli, String value) {
        List list2;
        String string = value;
        if (string == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            Object[] objectArray = new String[]{cli, it};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File createAdapterJs(String file) {
        File adapterJs = FilesKt.resolve((File)this.npmProject.getDir(), (String)ADAPTER_NODEJS);
        Object object = adapterJs;
        Object object2 = Charsets.UTF_8;
        File file2 = object;
        int n = 8192;
        boolean bl = false;
        Object object3 = file2;
        boolean bl2 = false;
        Object object4 = object3;
        boolean bl3 = false;
        object4 = new FileOutputStream((File)object4);
        bl3 = false;
        object3 = new OutputStreamWriter((OutputStream)object4, (Charset)object2);
        bl2 = false;
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter writer = (PrintWriter)object;
            boolean bl4 = false;
            String adapter = this.npmProject.require("kotlin-test-js-runner/kotlin-test-nodejs-runner.js");
            String escapedFile = StringsKt.jsQuoted(file);
            writer.println("require(" + StringsKt.jsQuoted(adapter) + ')');
            writer.println("module.exports = require(" + escapedFile + ')');
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return adapterJs;
    }

    @Override
    public boolean getNodeModulesRequired() {
        return KotlinJsTestFramework.DefaultImpls.getNodeModulesRequired(this);
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinMocha $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/mocha/KotlinMocha$Companion;", "", "()V", "ADAPTER_NODEJS", "", "DEFAULT_TIMEOUT", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

