/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.utils.Printer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/report/TextTable;", "", "columnNames", "", "", "([Ljava/lang/String;)V", "columnsCount", "", "maxLengths", "", "rows", "Ljava/util/ArrayList;", "", "addRow", "", "row", "printTo", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "kotlin-gradle-plugin"})
final class TextTable {
    @NotNull
    private final ArrayList<List<String>> rows;
    private final int columnsCount;
    @NotNull
    private final int[] maxLengths;

    public TextTable(String ... columnNames) {
        Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
        this.rows = new ArrayList();
        this.columnsCount = columnNames.length;
        int n = 0;
        int n2 = this.columnsCount;
        int[] nArray = new int[n2];
        TextTable textTable = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = columnNames[n3].length();
        }
        textTable.maxLengths = nArray;
        this.rows.add(ArraysKt.toList((Object[])columnNames));
    }

    public final void addRow(String ... row) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        boolean bl2 = bl = row.length == this.columnsCount;
        if (!bl) {
            boolean bl3 = false;
            String string = "Row size " + row.length + " differs from columns count " + this.columnsCount;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rows.add(ArraysKt.toList((Object[])row));
        String[] stringArray = row;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            String col = stringArray[i];
            this.maxLengths[i2] = Math.max(this.maxLengths[i2], col.length());
        }
    }

    public final void printTo(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        for (List<String> row : this.rows) {
            Intrinsics.checkNotNullExpressionValue(row, (String)"row");
            String rowStr2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)row), (CharSequence)"|", null, null, (int)0, null, (Function1)((Function1)new Function1<IndexedValue<? extends String>, CharSequence>(this){
                final /* synthetic */ TextTable this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IndexedValue<String> $dstr$i$col) {
                    Intrinsics.checkNotNullParameter($dstr$i$col, (String)"$dstr$i$col");
                    int i = $dstr$i$col.component1();
                    String col = (String)$dstr$i$col.component2();
                    return StringsKt.padEnd((String)col, (int)TextTable.access$getMaxLengths$p(this.this$0)[i], (char)' ');
                }
            }), (int)30, null);
            String[] stringArray = new String[]{rowStr2};
            p.println(stringArray);
        }
    }

    public static final /* synthetic */ int[] access$getMaxLengths$p(TextTable $this) {
        return $this.maxLengths;
    }
}

