/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.File;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteEnumWhenTracker;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteInlineConstTracker;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bH\u0016J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'2\u0006\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0(H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016JE\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0014\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0A0'H\u0016J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001a0'H\u0016J\u0010\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020$H\u0002J3\u0010H\u001a\b\u0012\u0004\u0012\u0002HI0'\"\u0004\b\u0000\u0010I2\b\b\u0002\u0010J\u001a\u00020K2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HI0'0\u0012H\u0082\bJ3\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0'\"\u0004\b\u0000\u0010I2\b\b\u0002\u0010J\u001a\u00020K2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HI0'0\u0012H\u0082\bJ!\u0010N\u001a\u00020\u00132\b\b\u0002\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ!\u0010O\u001a\u00020\u00132\b\b\u0002\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ\b\u0010P\u001a\u00020\u0013H\u0014J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010R\u001a\u0004\u0018\u00010)H\u0016JS\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010R\u001a\u0004\u0018\u00010)2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010T\u001a\b\u0012\u0004\u0012\u00020,0A2\u0006\u0010U\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u00020\u0013H\u0014J\b\u0010X\u001a\u00020\u0013H\u0014J\u0018\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0'2\b\u0010R\u001a\u0004\u0018\u00010)H\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020Z0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020Z0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J&\u0010]\u001a\b\u0012\u0004\u0012\u00020^0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020aH\u0016J&\u0010b\u001a\b\u0012\u0004\u0012\u00020c0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020aH\u0016J\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020e0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020$0'2\u0006\u0010g\u001a\u00020$H\u0016J\u000e\u0010h\u001a\b\u0012\u0004\u0012\u00020Z0'H\u0016J\b\u0010i\u001a\u00020\u0013H\u0002J\b\u0010j\u001a\u00020\u0013H\u0002J<\u0010k\u001a\b\u0012\u0004\u0012\u0002HI0'\"\u0004\b\u0000\u0010I2\u0006\u0010*\u001a\u00020\u000e2\u001d\u0010L\u001a\u0019\u0012\u0004\u0012\u00020m\u0012\n\u0012\b\u0012\u0004\u0012\u0002HI0'0l\u00a2\u0006\u0002\bnH\u0082\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getRegistry", "()Ljava/rmi/registry/Registry;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "checkCompilerId", "", "expectedCompilerId", "classesFqNamesByFiles", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "", "sessionId", "sourceFiles", "Ljava/io/File;", "clearJarCache", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "getClients", "", "getDaemonInfo", "getDaemonOptions", "getKotlinVersion", "getUsedMemory", "gracefulShutdown", "onAnotherThread", "ifAlive", "R", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "body", "ifAliveExclusive", "ifAliveExclusiveUnit", "ifAliveUnit", "initiateElections", "leaseCompileSession", "aliveFlagPath", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "registerClient", "", "releaseCompileSession", "releaseReplSession", "replCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "replStateId", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "replCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "scheduleShutdown", "graceful", "shutdown", "shutdownNow", "shutdownWithDelay", "withValidRepl", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n+ 2 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 5 IncrementalJvmCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJvmCompilerRunnerKt\n+ 6 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1108:1\n1083#1,2:1121\n1085#1:1135\n1080#1,5:1136\n1085#1:1153\n1080#1,5:1154\n1085#1:1171\n1080#1,5:1172\n1085#1:1189\n1083#1,2:1190\n1085#1:1204\n1080#1,5:1205\n1085#1:1222\n1083#1,2:1223\n1085#1:1237\n1083#1,2:1238\n1085#1:1252\n1080#1,5:1256\n1085#1:1278\n1097#1,2:1279\n1099#1:1293\n1083#1,2:1294\n1085#1:1308\n1080#1,5:1309\n1085#1:1336\n1080#1,5:1337\n1085#1:1740\n1083#1,2:1741\n1085#1:1755\n1083#1,2:1756\n655#1:1767\n1085#1:1783\n1083#1,2:1784\n655#1:1795\n1085#1:1811\n1083#1,2:1812\n655#1:1823\n1085#1:1839\n1087#1,2:1840\n1089#1,2:1851\n1092#1:1856\n1087#1,2:1857\n1089#1,2:1868\n1092#1:1873\n1087#1,2:1874\n1089#1,2:1885\n1092#1:1890\n1087#1,2:1891\n1089#1:1902\n1090#1:1910\n1092#1:1914\n634#2:1109\n518#2,2:1110\n517#2,6:1112\n636#2:1118\n524#2:1119\n637#2:1120\n496#2,12:1123\n496#2,12:1141\n496#2,12:1159\n496#2,12:1177\n496#2,12:1192\n496#2,12:1210\n496#2,12:1225\n496#2,12:1240\n496#2,9:1261\n505#2,3:1275\n496#2,12:1281\n496#2,12:1296\n496#2,9:1314\n518#2,2:1323\n517#2,8:1325\n505#2,3:1333\n496#2,9:1342\n295#2,25:1351\n320#2:1384\n388#2,3:1385\n518#2,2:1388\n517#2,6:1390\n391#2,6:1396\n415#2,4:1402\n397#2:1408\n321#2,2:1409\n420#2:1413\n422#2,34:1419\n399#2,5:1453\n524#2:1458\n405#2:1459\n327#2:1461\n388#2,3:1462\n518#2,2:1465\n517#2,6:1467\n391#2,6:1473\n415#2,4:1479\n397#2:1483\n328#2,11:1484\n420#2:1497\n422#2,34:1503\n399#2,5:1537\n524#2:1542\n405#2:1543\n342#2,5:1544\n347#2:1558\n388#2,3:1559\n518#2,2:1562\n517#2,6:1564\n391#2,6:1570\n415#2,4:1576\n397#2:1580\n348#2,8:1581\n420#2:1591\n422#2,34:1597\n399#2,5:1631\n524#2:1636\n405#2:1637\n360#2:1639\n361#2:1649\n388#2,3:1650\n518#2,2:1653\n517#2,6:1655\n391#2,6:1661\n415#2,4:1667\n397#2:1671\n362#2,8:1672\n420#2:1682\n422#2,34:1688\n399#2,5:1722\n524#2:1727\n405#2:1728\n374#2,7:1730\n505#2,3:1737\n496#2,12:1743\n496#2,9:1758\n634#2:1768\n518#2,2:1769\n517#2,6:1771\n636#2:1777\n524#2:1778\n637#2:1779\n505#2,3:1780\n496#2,9:1786\n634#2:1796\n518#2,2:1797\n517#2,6:1799\n636#2:1805\n524#2:1806\n637#2:1807\n505#2,3:1808\n496#2,9:1814\n634#2:1824\n518#2,2:1825\n517#2,6:1827\n636#2:1833\n524#2:1834\n637#2:1835\n505#2,3:1836\n496#2,9:1842\n505#2,3:1853\n496#2,9:1859\n505#2,3:1870\n496#2,9:1876\n505#2,3:1887\n496#2,9:1893\n505#2,3:1911\n496#2,12:1917\n496#2,12:1929\n496#2,12:1941\n496#2,12:1953\n1726#3,3:1253\n1855#3:1903\n1855#3,2:1905\n1856#3:1907\n1855#3,2:1908\n90#4,5:1270\n44#4,2:1406\n46#4,2:1411\n90#4,5:1414\n46#4,2:1495\n90#4,5:1498\n46#4,2:1589\n90#4,5:1592\n46#4,2:1680\n90#4,5:1683\n120#5,8:1376\n129#5:1460\n119#5,9:1549\n129#5:1638\n70#6,9:1640\n80#6:1729\n1#7:1904\n13579#8,2:1915\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n*L\n664#1:1121,2\n664#1:1135\n668#1:1136,5\n668#1:1153\n676#1:1154,5\n676#1:1171\n680#1:1172,5\n680#1:1189\n686#1:1190,2\n686#1:1204\n692#1:1205,5\n692#1:1222\n697#1:1223,2\n697#1:1237\n705#1:1238,2\n705#1:1252\n720#1:1256,5\n720#1:1278\n722#1:1279,2\n722#1:1293\n727#1:1294,2\n727#1:1308\n741#1:1309,5\n741#1:1336\n753#1:1337,5\n753#1:1740\n816#1:1741,2\n816#1:1755\n833#1:1756,2\n834#1:1767\n833#1:1783\n840#1:1784,2\n841#1:1795\n840#1:1811\n849#1:1812,2\n850#1:1823\n849#1:1839\n863#1:1840,2\n863#1:1851,2\n863#1:1856\n885#1:1857,2\n885#1:1868,2\n885#1:1873\n903#1:1874,2\n903#1:1885,2\n903#1:1890\n917#1:1891,2\n917#1:1902\n917#1:1910\n917#1:1914\n655#1:1109\n655#1:1110,2\n655#1:1112,6\n655#1:1118\n655#1:1119\n655#1:1120\n664#1:1123,12\n668#1:1141,12\n676#1:1159,12\n680#1:1177,12\n686#1:1192,12\n692#1:1210,12\n697#1:1225,12\n705#1:1240,12\n720#1:1261,9\n720#1:1275,3\n722#1:1281,12\n727#1:1296,12\n741#1:1314,9\n742#1:1323,2\n742#1:1325,8\n741#1:1333,3\n753#1:1342,9\n754#1:1351,25\n754#1:1384\n754#1:1385,3\n754#1:1388,2\n754#1:1390,6\n754#1:1396,6\n754#1:1402,4\n754#1:1408\n754#1:1409,2\n754#1:1413\n754#1:1419,34\n754#1:1453,5\n754#1:1458\n754#1:1459\n754#1:1461\n754#1:1462,3\n754#1:1465,2\n754#1:1467,6\n754#1:1473,6\n754#1:1479,4\n754#1:1483\n754#1:1484,11\n754#1:1497\n754#1:1503,34\n754#1:1537,5\n754#1:1542\n754#1:1543\n754#1:1544,5\n754#1:1558\n754#1:1559,3\n754#1:1562,2\n754#1:1564,6\n754#1:1570,6\n754#1:1576,4\n754#1:1580\n754#1:1581,8\n754#1:1591\n754#1:1597,34\n754#1:1631,5\n754#1:1636\n754#1:1637\n754#1:1639\n754#1:1649\n754#1:1650,3\n754#1:1653,2\n754#1:1655,6\n754#1:1661,6\n754#1:1667,4\n754#1:1671\n754#1:1672,8\n754#1:1682\n754#1:1688,34\n754#1:1722,5\n754#1:1727\n754#1:1728\n754#1:1730,7\n753#1:1737,3\n816#1:1743,12\n833#1:1758,9\n834#1:1768\n834#1:1769,2\n834#1:1771,6\n834#1:1777\n834#1:1778\n834#1:1779\n833#1:1780,3\n840#1:1786,9\n841#1:1796\n841#1:1797,2\n841#1:1799,6\n841#1:1805\n841#1:1806\n841#1:1807\n840#1:1808,3\n849#1:1814,9\n850#1:1824\n850#1:1825,2\n850#1:1827,6\n850#1:1833\n850#1:1834\n850#1:1835\n849#1:1836,3\n863#1:1842,9\n863#1:1853,3\n885#1:1859,9\n885#1:1870,3\n903#1:1876,9\n903#1:1887,3\n917#1:1893,9\n917#1:1911,3\n1084#1:1917,12\n1088#1:1929,12\n1098#1:1941,12\n1102#1:1953,12\n716#1:1253,3\n938#1:1903\n941#1:1905,2\n938#1:1907\n972#1:1908,2\n720#1:1270,5\n754#1:1406,2\n754#1:1411,2\n754#1:1414,5\n754#1:1495,2\n754#1:1498,5\n754#1:1589,2\n754#1:1592,5\n754#1:1680,2\n754#1:1683,5\n754#1:1376,8\n754#1:1460\n754#1:1549,9\n754#1:1638\n754#1:1640,9\n754#1:1729\n997#1:1915,2\n*E\n"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.onShutdown = onShutdown;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        CompileService stub = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase this_$iv = this;
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase this_$iv$iv = this_$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == CompileService.Companion.getNO_SESSION()) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                return object;
            }
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy;
        try {
            Object object2;
            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<String>("Kotlin daemon on port " + this.getPort());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getLog().info("getDaemonJVMOptions: " + this.daemonJVMOptions);
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.daemonJVMOptions);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info("Registered a client alive file: " + aliveFlagPath);
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    int $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 + ", session alive file: " + aliveFlagPath);
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info("cleaning after session " + sessionId);
                    ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl3 = false;
                        this.clearJarCache();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    boolean withGC$iv = true;
                    boolean $i$f$usedMemory = false;
                    System.gc();
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2;
                    boolean bl3 = false;
                    if (graceful) {
                        bl2 = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl2 = true;
                    }
                    boolean res = bl2;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var5_5.lock();
        try {
            block13: {
                block12: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block12;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    block14: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        this_$iv = this;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block14;
                        v1 = null;
                        ** GOTO lbl-1000
                    }
                    v1 = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                    if (v1 == null) {
                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var14_16 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v2 = var14_16;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var16_19 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var16_19 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var16_19;
            }
            var6_7 = v0;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var8_8 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var8_8.lock();
        try {
            block94: {
                block93: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block93;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block94;
                }
                try {
                    block96: {
                        block95: {
                            $i$a$-ifAlive$default-CompileServiceImpl$compile$1 = false;
                            this_$iv = this;
                            $i$f$compileImpl = false;
                            $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                            var17_19 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$2 = false;
                            messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , p1);
                            p1 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = false;
                            daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , p1);
                            targetPlatform$iv = compilationOptions.getTargetPlatform();
                            CompileServiceImplBase.access$getLog(this_$iv).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                case 1: {
                                    v1 = (CLICompiler)new K2JVMCompiler();
                                    break;
                                }
                                case 2: {
                                    v1 = (CLICompiler)new K2JSCompiler();
                                    break;
                                }
                                case 3: {
                                    v1 = (CLICompiler)new K2MetadataCompiler();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compiler$iv = v1;
                            k2PlatformArgs$iv = (CommonCompilerArguments)compiler$iv.createArguments();
                            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv), (boolean)false, (int)4, null);
                            argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                            if (argumentParseError$iv == null) break block95;
                            MessageCollector.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                            v2 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                            break block96;
                        }
                        block22 : switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[compilationOptions.getCompilerMode().ordinal()]) {
                            case 1: {
                                (Object)servicesFacade;
                                p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade;
                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = false;
                                enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                                $i$f$withIC = false;
                                isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                try {
                                    if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                        k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                    }
                                    $i$a$-withIC-CompileServiceImplBase$compileImpl$1$1$iv = false;
                                    var30_45 = this_$iv;
                                    tracer$iv$iv = null;
                                    $i$f$doCompile = false;
                                    $this$doCompile_u24lambda_u2412$iv$iv = this_$iv$iv;
                                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("alive!");
                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                    $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl84
                                    v3 = null;
                                    ** GOTO lbl88
lbl84:
                                    // 1 sources

                                    v3 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v3 != null) ** GOTO lbl88
                                    v4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                    ** GOTO lbl187
lbl88:
                                    // 2 sources

                                    session$iv$iv$iv = v3;
                                    try {
                                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                        it$iv$iv = session$iv$iv$iv;
                                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                        eventManager$iv$iv = new EventManagerImpl();
                                        try {
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("trying get exitCode");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                            $i$f$checkedCompile = false;
                                            try {
                                                var45_112 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                obj$iv$iv$iv$iv = null;
                                                $i$f$withMeasure = false;
                                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                var50_137 = rpcProfiler$iv$iv;
                                                eventManger$iv = eventManager$iv$iv;
                                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = profiler$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = eventManger$iv;
                                                p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$4 = false;
                                                services$iv = this.createCompileServices((CompilerCallbackServicesFacade)p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                                res$iv$iv$iv$iv = compiler$iv.exec(messageCollector$iv, services$iv, (CommonToolArguments)k2PlatformArgs$iv).getCode();
                                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    withGC$iv$iv$iv$iv = false;
                                                    $i$f$usedMemory = false;
                                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                    v5 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                } else {
                                                    v5 = 0L;
                                                }
                                                endMem$iv$iv$iv = v5;
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                    rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                    v6 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                    rt$iv$iv$iv$iv = "%+d";
                                                    var59_169 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                    v7 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(var59_169, ((Object[])var59_169).length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"format(this, *args)");
                                                    it$iv$iv$iv = v6.append(v7).append(" kb)").toString();
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    for (Object var59_169 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                        obj$iv$iv$iv = var59_169.getKey();
                                                        counters$iv$iv$iv = (PerfCounters)var59_169.getValue();
                                                        it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                        daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    }
                                                }
                                                v8 = res$iv$iv$iv;
                                            }
                                            catch (Throwable e$iv$iv$iv) {
                                                v9 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                v10 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                v11 = e$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"e.stackTrace");
                                                v12 = v10.append(ArraysKt.joinToString$default((Object[])v11, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                    v13 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                    v14 = e$iv$iv$iv.getCause();
                                                    Intrinsics.checkNotNull((Object)v14);
                                                    v15 = v14.getStackTrace();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"e.cause!!.stackTrace");
                                                    v16 = v13.append(ArraysKt.joinToString$default((Object[])v15, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                } else {
                                                    v16 = "";
                                                }
                                                v9.log(Level.SEVERE, v12.append(v16).toString());
                                                throw e$iv$iv$iv;
                                            }
                                            exitCode$iv$iv = ((Number)v8).intValue();
                                            exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                        }
                                        finally {
                                            eventManager$iv$iv.fireCompilationFinished();
                                        }
                                        var65_195 = exitCode$iv$iv;
                                        v4 = var65_195;
                                    }
                                    finally {
                                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                    }
lbl187:
                                    // 2 sources

                                    var18_22 = v4;
                                    v2 = var18_22;
                                    break;
                                }
                                finally {
                                    IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                }
                            }
                            case 2: {
                                enabled$iv$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u2412$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId == CompileService.Companion.getNO_SESSION()) {
                                    v17 = null;
                                } else {
                                    v17 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v17 == null) {
                                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                        break;
                                    }
                                }
                                session$iv$iv$iv = v17;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            eventManager$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            (EventManager)eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                            exitCode$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, (CommonToolArguments)k2PlatformArgs$iv);
                                            perfString$iv = compiler$iv.getDefaultPerformanceManager().renderCompilerPerformance();
                                            v18 = compilationResults;
                                            if (v18 != null) {
                                                it$iv = eventManger$iv = v18;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                rt$iv$iv$iv$iv = new String[]{perfString$iv};
                                                it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])rt$iv$iv$iv$iv));
                                                v19 = eventManger$iv;
                                            } else {
                                                v19 = null;
                                            }
                                            res$iv$iv$iv$iv = exitCode$iv.getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v20 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v20 = 0L;
                                            }
                                            endMem$iv$iv$iv = v20;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v21 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv$iv = "%+d";
                                                obj$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                v22 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(obj$iv$iv$iv, obj$iv$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"format(this, *args)");
                                                it$iv$iv$iv = v21.append(v22).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                    it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v23 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v24 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v25 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            v26 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"e.stackTrace");
                                            v27 = v25.append(ArraysKt.joinToString$default((Object[])v26, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v28 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v29 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v29);
                                                v30 = v29.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"e.cause!!.stackTrace");
                                                v31 = v28.append(ArraysKt.joinToString$default((Object[])v30, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v31 = "";
                                            }
                                            v24.log(Level.SEVERE, v27.append(v31).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v23).intValue();
                                        exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                    }
                                    var18_22 = exitCode$iv$iv;
                                    v2 = var18_22;
                                    break;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
                            }
                            case 3: {
                                gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions;
                                gradleIncrementalServicesFacade$iv = servicesFacade;
                                switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                    case 1: {
                                        enabled$iv$iv = true;
                                        $i$f$withIC = false;
                                        isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                        IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withIC$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                            it$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2412$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl342
                                            v32 = null;
                                            ** GOTO lbl346
lbl342:
                                            // 1 sources

                                            v32 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v32 != null) ** GOTO lbl346
                                            v33 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl455
lbl346:
                                            // 2 sources

                                            session$iv$iv$iv = v32;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2412$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        exitCode$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                                        v34 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                                        v35 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v35);
                                                        var68_206 = gradleIncrementalArgs$iv;
                                                        var69_208 = v35;
                                                        var70_210 = gradleIncrementalServicesFacade$iv;
                                                        var71_214 = messageCollector$iv;
                                                        var72_216 = gradleIncrementalArgs$iv;
                                                        var73_218 = v34;
                                                        var74_220 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v36 = b;
                                                        Intrinsics.checkNotNull((Object)v36);
                                                        var76_224 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v36, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(var74_220, var73_218, var72_216, var71_214, var76_224).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v37 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v37 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v37;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v38 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            rt$iv$iv$iv$iv = "%+d";
                                                            it$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v39 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(it$iv$iv$iv, ((Object[])it$iv$iv$iv).length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"format(this, *args)");
                                                            it$iv$iv$iv = v38.append(v39).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                            for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v40 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v41 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v42 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v43 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"e.stackTrace");
                                                        v44 = v42.append(ArraysKt.joinToString$default((Object[])v43, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v45 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v46 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v46);
                                                            v47 = v46.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"e.cause!!.stackTrace");
                                                            v48 = v45.append(ArraysKt.joinToString$default((Object[])v47, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v48 = "";
                                                        }
                                                        v41.log(Level.SEVERE, v44.append(v48).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v40).intValue();
                                                    exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var18_22 = exitCode$iv$iv;
                                                v33 = var18_22;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl455:
                                            // 2 sources

                                            var70_210 = v33;
                                            v2 = var70_210;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                        }
                                    }
                                    case 2: {
                                        enabled$iv$iv = true;
                                        $i$f$withJsIC = false;
                                        isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                                        IncrementalCompilation.setIsEnabledForJs((boolean)true);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                            this_$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2412$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2412$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl483
                                            v49 = null;
                                            ** GOTO lbl487
lbl483:
                                            // 1 sources

                                            v49 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v49 != null) ** GOTO lbl487
                                            v50 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl596
lbl487:
                                            // 2 sources

                                            session$iv$iv$iv = v49;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2412$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2412$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        $this$withMeasure$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                                        v51 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                                        v52 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v52);
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = gradleIncrementalArgs$iv;
                                                        c = v52;
                                                        b = gradleIncrementalServicesFacade$iv;
                                                        var71_215 = messageCollector$iv;
                                                        var72_217 = gradleIncrementalArgs$iv;
                                                        var73_219 = v51;
                                                        var74_221 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v53 = b;
                                                        Intrinsics.checkNotNull((Object)v53);
                                                        var76_225 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v53, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(var74_221, var73_219, var72_217, var71_215, var76_225).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v54 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v54 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v54;
                                                        CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v55 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            var56_167 = "%+d";
                                                            it$iv$iv$iv /* !! */  = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v56 = String.format(var56_167, Arrays.copyOf(it$iv$iv$iv /* !! */ , it$iv$iv$iv /* !! */ .length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v56, (String)"format(this, *args)");
                                                            it$iv$iv$iv /* !! */  = v55.append(v56).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv /* !! */ );
                                                            CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv /* !! */ );
                                                            for (Map.Entry var60_174 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = var60_174.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)var60_174.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v57 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v58 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                                        v59 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v60 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v60, (String)"e.stackTrace");
                                                        v61 = v59.append(ArraysKt.joinToString$default((Object[])v60, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v62 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v63 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v63);
                                                            v64 = v63.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v64, (String)"e.cause!!.stackTrace");
                                                            v65 = v62.append(ArraysKt.joinToString$default((Object[])v64, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v65 = "";
                                                        }
                                                        v58.log(Level.SEVERE, v61.append(v65).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v57).intValue();
                                                    var65_202 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var18_22 = var65_202;
                                                v50 = var18_22;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl596:
                                            // 2 sources

                                            var70_212 = v50;
                                            v2 = var70_212;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                                        }
                                    }
                                }
                                throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform$iv);
                            }
                            default: {
                                throw new IllegalStateException("Unknown compilation mode " + compilationOptions.getCompilerMode());
                            }
                        }
                    }
                    var78_227 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var78_227 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var78_227;
            }
            var9_10 = v0;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasInlineConstTracker()) {
            builder.register(InlineConstTracker.class, (Object)new RemoteInlineConstTracker(facade, rpcProfiler));
        }
        if (facade.hasEnumWhenTracker()) {
            builder.register(EnumWhenTracker.class, (Object)new RemoteEnumWhenTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, eventManager, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv).readLock();
        var5_5.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl-1000
                    }
                    v1 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (v1 == null) {
                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            v3 = session$iv$iv;
                            v4 = v3 != null ? v3.getData() : null;
                            if (v4 == null) {
                                v4 = null;
                            }
                            if (v4 != null) {
                                $this$replCreateState_u24lambda_u2423_u24lambda_u2422 = (KotlinJvmReplService)v4;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v5 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u2423_u24lambda_u2422.createRemoteState(this.getPort()));
                            } else {
                                v5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            var22_25 = v5;
                            v2 = var22_25;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var23_27 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var23_27 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var23_27;
            }
            var6_7 = v0;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block14: {
                    boolean bl = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block14;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    CompileService.CallResult callResult4;
                    block12: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block17: {
                            block16: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) break block16;
                                clientOrSessionProxy = null;
                                break block17;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block17;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block12;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block19: {
                                block18: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block18;
                                    KotlinJvmReplService $this$replCheck_u24lambda_u2425_u24lambda_u2424 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl2 = false;
                                    callResult5 = $this$replCheck_u24lambda_u2425_u24lambda_u2424.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCheckResult>($this$replCheck_u24lambda_u2425_u24lambda_u2424, codeLine){
                                        final /* synthetic */ KotlinJvmReplService $this_withValidRepl;
                                        final /* synthetic */ ReplCodeLine $codeLine;
                                        {
                                            this.$this_withValidRepl = $receiver;
                                            this.$codeLine = $codeLine;
                                            super(1);
                                        }

                                        @NotNull
                                        public final ReplCheckResult invoke(@NotNull IReplStageState<?> state) {
                                            Intrinsics.checkNotNullParameter(state, (String)"state");
                                            return this.$this_withValidRepl.check(state, this.$codeLine);
                                        }
                                    });
                                    if (callResult5 != null) break block19;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult7 = callResult5;
                            callResult4 = callResult7;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block14: {
                    boolean bl = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block14;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    CompileService.CallResult callResult4;
                    block12: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block17: {
                            block16: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) break block16;
                                clientOrSessionProxy = null;
                                break block17;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block17;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block12;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block19: {
                                block18: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block18;
                                    KotlinJvmReplService $this$replCompile_u24lambda_u2427_u24lambda_u2426 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl2 = false;
                                    callResult5 = $this$replCompile_u24lambda_u2427_u24lambda_u2426.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCompileResult>($this$replCompile_u24lambda_u2427_u24lambda_u2426, codeLine){
                                        final /* synthetic */ KotlinJvmReplService $this_withValidRepl;
                                        final /* synthetic */ ReplCodeLine $codeLine;
                                        {
                                            this.$this_withValidRepl = $receiver;
                                            this.$codeLine = $codeLine;
                                            super(1);
                                        }

                                        @NotNull
                                        public final ReplCompileResult invoke(@NotNull IReplStageState<?> state) {
                                            Intrinsics.checkNotNullParameter(state, (String)"state");
                                            return this.$this_withValidRepl.compile(state, this.$codeLine);
                                        }
                                    });
                                    if (callResult5 != null) break block19;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult7 = callResult5;
                            callResult4 = callResult7;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block24: {
            block23: {
                block22: {
                    block27: {
                        if (this.getState().getDelayedShutdownQueued().get()) {
                            return;
                        }
                        anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                        var2_2 = this;
                        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                        $i$f$ifAliveUnit = false;
                        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
                        var5_5.lock();
                        $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                        this_$iv$iv = this_$iv;
                        $i$f$ifAliveChecksImpl = false;
                        curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv >= minAliveness$iv.ordinal()) break block27;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl61
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block22;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var5_5.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block23;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var5_5.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block24;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var5_5.unlock();
            return;
        }
        try {
            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
lbl61:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv) {
            throw $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv;
        }
        finally {
            var5_5.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
        var5_5.lock();
        try {
            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
            this_$iv$iv = this_$iv;
            $i$f$ifAliveChecksImpl = false;
            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                (CompileService.CallResult)new CompileService.CallResult.Dying();
            } else {
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var10_18 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_16 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var6_10 = Unit.INSTANCE;
        }
        finally {
            var5_5.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initiateElections() {
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    this.getLog().info("initiate elections");
                    List aliveWithOpts2 = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)((Function2)new Function2<File, Integer, Boolean>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull File file, int p) {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"<anonymous parameter 0>");
                            return p != this.this$0.getPort();
                        }
                    }), (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final void invoke(@NotNull DaemonReportCategory daemonReportCategory, @NotNull String msg) {
                            Intrinsics.checkNotNullParameter((Object)((Object)daemonReportCategory), (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                            this.this$0.getLog().info(msg);
                        }
                    })));
                    Comparator comparator = new DaemonJVMOptionsMemoryComparator();
                    comparator = new Comparator(comparator){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            DaemonWithMetadata it = (DaemonWithMetadata)a;
                            DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                            bl = false;
                            DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                            return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
                        }
                    };
                    Comparator comparator2 = new FileAgeComparator();
                    Comparator comparator3 = new Comparator(comparator, comparator2){
                        final /* synthetic */ Comparator $this_thenBy;
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$this_thenBy = $receiver;
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                Comparator comparator = this.$comparator;
                                boolean bl = false;
                                DaemonWithMetadata it = (DaemonWithMetadata)b;
                                File file = it.getRunFile();
                                bl = false;
                                File file2 = it.getRunFile();
                                n = comparator.compare(file, file2);
                            }
                            return n;
                        }
                    };
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts2, (Comparator)comparator3);
                    if (daemonWithMetadata != null) {
                        DaemonWithMetadata bestDaemonWithMetadata = daemonWithMetadata;
                        boolean bl4 = false;
                        DaemonJVMOptions fattestOpts = bestDaemonWithMetadata.getJvmOptions();
                        if (DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.daemonJVMOptions) && new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) < 0) {
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            Iterable $this$forEach$iv = aliveWithOpts2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                DaemonWithMetadata daemonWithMetadata2 = (DaemonWithMetadata)element$iv;
                                boolean bl5 = false;
                                CompileService daemon = daemonWithMetadata2.component1();
                                File runFile = daemonWithMetadata2.component2();
                                try {
                                    CompileService.CallResult<List<String>> callResult;
                                    CompileService.CallResult<List<String>> it = callResult = daemon.getClients();
                                    boolean bl6 = false;
                                    CompileService.CallResult<List<String>> callResult2 = it.isGood() ? callResult : null;
                                    if (callResult2 != null) {
                                        it = callResult2;
                                        boolean bl7 = false;
                                        Iterable $this$forEach$iv2 = it.get();
                                        boolean $i$f$forEach2 = false;
                                        for (Object element$iv2 : $this$forEach$iv2) {
                                            String clientAliveFile = (String)element$iv2;
                                            boolean bl8 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + FilesKt.normalize((File)runFile).getAbsolutePath() + "'): " + e.getMessage());
                                }
                            }
                        } else if (DaemonParamsKt.memorywiseFitsInto(this.daemonJVMOptions, fattestOpts) && new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) > 0) {
                            CompileService.CallResult<List<String>> callResult;
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            CompileService.CallResult<List<String>> it = callResult = this.getClients();
                            boolean bl9 = false;
                            CompileService.CallResult<List<String>> callResult3 = it.isGood() ? callResult : null;
                            if (callResult3 != null) {
                                it = callResult3;
                                boolean bl10 = false;
                                Iterable $this$forEach$iv = it.get();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl11 = false;
                                    bestDaemonWithMetadata.getDaemon().registerClient(it2);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                        }
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Runtime $this$shutdownNow_u24lambda_u2442 = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2442.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2442.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2442.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
        Handler[] handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"log.handlers");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                TimerTask $this$shutdownWithDelay_u24lambda_u2445 = this;
                boolean bl = false;
                this.this$0.getState().getDelayedShutdownQueued().set(false);
                if (this.$currentClientsCount$inlined == this.this$0.getState().getClientsCounter() && this.$currentCompilationsCount$inlined == this.this$0.getCompilationsCounter().get() && this.$currentSessionId$inlined == this.this$0.getState().getSessions().getLastSessionId()) {
                    void this_$iv;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info("Invalid state for graceful shutdown: " + this.toAlivenessName(this.getState().getAlive().get()));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void run() {
                    void this_$iv;
                    TimerTask $this$gracefulShutdown_u24lambda_u2447 = this;
                    boolean bl = false;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    @Override
    public void clearJarCache() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCache_u24lambda_u2448 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCache_u24lambda_u2448.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCache_u24lambda_u2448.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCache_u24lambda_u2448.idleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        if (this$0.getState().getSessions().isEmpty()) {
            this$0.shutdownWithDelay();
        } else {
            this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
            this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
            this$0.getLog().info("Some sessions are active, waiting for them to finish");
            this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
        }
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

