/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompiledPackagePart;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.PackageMetadata;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalDataProvider;", "Lorg/jetbrains/kotlin/incremental/js/IncrementalDataProvider;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "compiledPackageParts", "", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "getCompiledPackageParts", "()Ljava/util/Map;", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "headerMetadata", "", "getHeaderMetadata", "()[B", "metadataVersion", "", "getMetadataVersion", "()[I", "packageMetadata", "", "getPackageMetadata", "getRpcProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "serializedIrFiles", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "getSerializedIrFiles", "kotlin-daemon"})
public final class RemoteIncrementalDataProvider
implements IncrementalDataProvider {
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final Profiler rpcProfiler;

    public RemoteIncrementalDataProvider(@NotNull CompilerCallbackServicesFacade facade, @NotNull Profiler rpcProfiler) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)rpcProfiler, (String)"rpcProfiler");
        this.facade = facade;
        this.rpcProfiler = rpcProfiler;
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final Profiler getRpcProfiler() {
        return this.rpcProfiler;
    }

    @NotNull
    public Map<File, IrTranslationResultValue> getSerializedIrFiles() {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"not implemented"));
    }

    @NotNull
    public byte[] getHeaderMetadata() {
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        byte[] res$iv = this.getFacade().incrementalDataProvider_getHeaderMetadata();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public Map<File, TranslationResultValue> getCompiledPackageParts() {
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = this.getFacade().incrementalDataProvider_getCompiledPackageParts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompiledPackagePart it = (CompiledPackagePart)element$iv;
            boolean bl2 = false;
            TranslationResultValue prev = result.put(new File(it.getFilePath()), new TranslationResultValue(it.getMetadata(), it.getBinaryAst(), it.getInlineData()));
            boolean bl3 = prev == null;
            if (bl3) continue;
            boolean bl4 = false;
            String string = "compiledPackageParts: duplicated entry for file `" + it.getFilePath() + '`';
            throw new IllegalStateException(string.toString());
        }
        Map res$iv = result;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public int[] getMetadataVersion() {
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        int[] res$iv = this.getFacade().incrementalDataProvider_getMetadataVersion();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public Map<String, byte[]> getPackageMetadata() {
        Profiler $this$withMeasure$iv = this.rpcProfiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = this.getFacade().incrementalDataProvider_getPackageMetadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackageMetadata it = (PackageMetadata)element$iv;
            boolean bl2 = false;
            byte[] prev = result.put(it.getPackageName(), it.getMetadata());
            boolean bl3 = prev == null;
            if (bl3) continue;
            boolean bl4 = false;
            String string = "packageMetadata: duplicated entry for package `" + it.getPackageName() + '`';
            throw new IllegalStateException(string.toString());
        }
        Map res$iv = result;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }
}

