/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.MultifileFacadeFileEntry;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/FileCodegen;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateMultifileFacade", "", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.entrypoint"})
final class FileCodegen
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private final boolean generateMultifileFacade;

    public FileCodegen(@NotNull JvmBackendContext context, boolean generateMultifileFacade) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.generateMultifileFacade = generateMultifileFacade;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        boolean isMultifileFacade = irFile.getFileEntry() instanceof MultifileFacadeFileEntry;
        if (isMultifileFacade == this.generateMultifileFacade) {
            for (IrDeclaration loweredClass : irFile.getDeclarations()) {
                if (!(loweredClass instanceof IrClass)) {
                    throw new AssertionError((Object)("File-level declaration should be IrClass after JvmLower, got: " + RenderIrElementKt.render(loweredClass)));
                }
                ClassCodegen.Companion.getOrCreate$default(ClassCodegen.Companion, (IrClass)loweredClass, this.context, null, 4, null).generate();
            }
        }
    }
}

