/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InheritanceImplUtil {
    private static final Logger LOG = Logger.getInstance(InheritanceImplUtil.class);

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(0);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(1);
        }
        if (baseClass instanceof PsiAnonymousClass || baseClass.getManager().areElementsEquivalent(baseClass, candidateClass)) {
            return false;
        }
        if (!checkDeep) {
            return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, false, null);
        }
        GlobalSearchScope scope2 = candidateClass.getResolveScope();
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(baseClass, candidateClass, scope2, PsiSubstitutor.EMPTY) != null;
    }

    static boolean hasObjectQualifiedName(@NotNull PsiClass candidateClass) {
        if (candidateClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(2);
        }
        if (!"Object".equals(candidateClass.getName())) {
            return false;
        }
        PsiElement parent2 = candidateClass.getParent();
        return parent2 instanceof PsiJavaFile && "java.lang".equals(((PsiJavaFile)parent2).getPackageName());
    }

    private static boolean isInheritor(@NotNull PsiManager manager, @NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep, @Nullable Set<PsiClass> checkedClasses) {
        PsiClass objectClass;
        if (manager == null) {
            InheritanceImplUtil.$$$reportNull$$$0(3);
        }
        if (candidateClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(4);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(5);
        }
        if (candidateClass instanceof PsiAnonymousClass) {
            PsiClass baseCandidateClass = ((PsiAnonymousClass)candidateClass).getBaseClassType().resolve();
            if (baseCandidateClass != null) {
                if (!checkDeep) {
                    return manager.areElementsEquivalent(baseCandidateClass, baseClass);
                }
                return InheritanceUtil.isInheritorOrSelf(baseCandidateClass, baseClass, true);
            }
            return false;
        }
        if (checkDeep && LOG.isDebugEnabled()) {
            LOG.debug("Using uncached version for " + candidateClass.getQualifiedName() + " and " + baseClass);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (InheritanceImplUtil.hasObjectQualifiedName(baseClass) && manager.areElementsEquivalent(baseClass, objectClass = facade.findClass("java.lang.Object", candidateClass.getResolveScope()))) {
            if (manager.areElementsEquivalent(candidateClass, objectClass)) {
                return false;
            }
            if (checkDeep || candidateClass.isInterface()) {
                return true;
            }
            return manager.areElementsEquivalent(candidateClass.getSuperClass(), objectClass);
        }
        if (!checkDeep) {
            if (candidateClass instanceof PsiCompiledElement) {
                boolean isBaseInterface;
                String baseQName = baseClass.getQualifiedName();
                if (baseQName == null) {
                    return false;
                }
                if ("java.lang.Enum".equals(baseQName) && candidateClass.isEnum()) {
                    return facade.findClass(baseQName, candidateClass.getResolveScope()) != null;
                }
                if ("java.lang.annotation.Annotation".equals(baseQName) && candidateClass.isAnnotationType()) {
                    return facade.findClass(baseQName, candidateClass.getResolveScope()) != null;
                }
                boolean isCandidateInterface = candidateClass.isInterface();
                if (isCandidateInterface == (isBaseInterface = baseClass.isInterface()) && InheritanceImplUtil.checkReferenceListWithQualifiedNamesInClsClass(baseQName, candidateClass.getExtendsList(), facade)) {
                    return true;
                }
                return isBaseInterface && !isCandidateInterface && InheritanceImplUtil.checkReferenceListWithQualifiedNamesInClsClass(baseQName, candidateClass.getImplementsList(), facade);
            }
            boolean isCandidateInterface = candidateClass.isInterface();
            boolean isBaseInterface = baseClass.isInterface();
            String baseName = baseClass.getName();
            if (isCandidateInterface == isBaseInterface) {
                return PsiClassImplUtil.isInExtendsList(candidateClass, baseClass, baseName, manager);
            }
            if (!isCandidateInterface) {
                return PsiClassImplUtil.isInReferenceList(candidateClass.getImplementsList(), baseClass, baseName, manager);
            }
            return false;
        }
        return InheritanceImplUtil.isInheritorWithoutCaching(manager, candidateClass, baseClass, checkedClasses);
    }

    private static boolean checkReferenceListWithQualifiedNamesInClsClass(@NotNull String baseQName, @Nullable PsiReferenceList extList, @NotNull JavaPsiFacade facade) {
        PsiJavaCodeReferenceElement[] referenceElements;
        if (baseQName == null) {
            InheritanceImplUtil.$$$reportNull$$$0(6);
        }
        if (facade == null) {
            InheritanceImplUtil.$$$reportNull$$$0(7);
        }
        if (extList != null && (referenceElements = extList.getReferenceElements()).length != 0) {
            GlobalSearchScope scope2 = extList.getResolveScope();
            for (PsiJavaCodeReferenceElement ref : referenceElements) {
                if (!Objects.equals(PsiNameHelper.getQualifiedClassName(ref.getQualifiedName(), false), baseQName) || facade.findClass(baseQName, scope2) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritorWithoutCaching(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @Nullable Set<PsiClass> checkedClasses) {
        if (manager == null) {
            InheritanceImplUtil.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(9);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(10);
        }
        if (manager.areElementsEquivalent(aClass, baseClass)) {
            return false;
        }
        if (aClass.isInterface() && !baseClass.isInterface()) {
            return false;
        }
        if (checkedClasses == null) {
            checkedClasses = new HashSet<PsiClass>();
        }
        checkedClasses.add(aClass);
        return InheritanceImplUtil.checkInheritor(manager, aClass.getExtendsListTypes(), baseClass, checkedClasses) || InheritanceImplUtil.checkInheritor(manager, aClass.getImplementsListTypes(), baseClass, checkedClasses);
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, PsiClassType @NotNull [] supers, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            InheritanceImplUtil.$$$reportNull$$$0(11);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(12);
        }
        if (checkedClasses == null) {
            InheritanceImplUtil.$$$reportNull$$$0(13);
        }
        if (supers == null) {
            InheritanceImplUtil.$$$reportNull$$$0(14);
        }
        for (PsiClassType aSuper : supers) {
            PsiClass aClass = aSuper.resolve();
            if (aClass == null || !InheritanceImplUtil.checkInheritor(manager, aClass, baseClass, checkedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            InheritanceImplUtil.$$$reportNull$$$0(15);
        }
        if (aClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(16);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(17);
        }
        if (checkedClasses == null) {
            InheritanceImplUtil.$$$reportNull$$$0(18);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (manager.areElementsEquivalent(baseClass, aClass)) {
            return true;
        }
        if (checkedClasses.contains(aClass)) {
            return false;
        }
        return InheritanceImplUtil.isInheritor(manager, aClass, baseClass, true, checkedClasses);
    }

    public static boolean isInheritorDeep(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, @Nullable PsiClass classToByPass) {
        if (candidateClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(19);
        }
        if (baseClass == null) {
            InheritanceImplUtil.$$$reportNull$$$0(20);
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        HashSet<PsiClass> checkedClasses = null;
        if (classToByPass != null) {
            checkedClasses = new HashSet<PsiClass>();
            checkedClasses.add(classToByPass);
        }
        return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, true, checkedClasses);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateClass";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedClasses";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/InheritanceImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasObjectQualifiedName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReferenceListWithQualifiedNamesInClsClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritorWithoutCaching";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInheritor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritorDeep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

