/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;
import org.jetbrains.kotlin.cli.jvm.modules.JavaVersionUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "()V", "roots", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "clearRoots", "", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getProtocol", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "cli"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    private final ConcurrentMap<String, CoreJrtVirtualFile> roots;
    private static final ConcurrentMap<File, URLClassLoader> jrtFsClassLoaderCache;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path2) {
        void jdkHomePath;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Pair<String, String> pair = Companion.splitPath(path2);
        String string2 = (String)pair.component1();
        String pathInImage = (String)pair.component2();
        CoreJrtVirtualFile coreJrtVirtualFile = (CoreJrtVirtualFile)this.roots.get(jdkHomePath);
        if (coreJrtVirtualFile == null) {
            return null;
        }
        CoreJrtVirtualFile root2 = coreJrtVirtualFile;
        CharSequence charSequence2 = pathInImage;
        if (charSequence2.length() == 0) {
            return root2;
        }
        return root2.findFileByRelativePath(pathInImage);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.findFileByPath(path2);
    }

    public final void clearRoots() {
        this.roots.clear();
    }

    public CoreJrtFileSystem() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(new Function(this){
            final /* synthetic */ CoreJrtFileSystem this$0;

            public final CoreJrtVirtualFile fun(String jdkHomePath) {
                FileSystem fileSystem2;
                File jdkHome = new File(jdkHomePath);
                URI rootUri = URI.create("jrt:/");
                File file2 = org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem$Companion.access$loadJrtFsJar(CoreJrtFileSystem.Companion, jdkHome);
                if (file2 == null) {
                    return null;
                }
                File jrtFsJar = file2;
                if (JavaVersionUtilsKt.isAtLeastJava9()) {
                    fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"java.home", (Object)jdkHome.getAbsolutePath())));
                } else {
                    URLClassLoader classLoader2 = (URLClassLoader)CoreJrtFileSystem.access$getJrtFsClassLoaderCache$cp().computeIfAbsent(jrtFsJar, new java.util.function.Function(jrtFsJar){
                        final /* synthetic */ File $jrtFsJar;

                        public final URLClassLoader apply(File it) {
                            return new URLClassLoader(new URL[]{this.$jrtFsJar.toURI().toURL()}, null);
                        }
                        {
                            this.$jrtFsJar = file2;
                        }
                    });
                    fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader2);
                }
                FileSystem fileSystem3 = fileSystem2;
                String string2 = jdkHomePath;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdkHomePath");
                Path path2 = fileSystem3.getPath("", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fileSystem.getPath(\"\")");
                return new CoreJrtVirtualFile(this.this$0, string2, path2, null);
            }
            {
                this.this$0 = coreJrtFileSystem;
            }
        });
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026 parent = null)\n        }");
        this.roots = concurrentMap;
    }

    static {
        Companion = new Companion(null);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"ContainerUtil.createConc\u2026p<File, URLClassLoader>()");
        jrtFsClassLoaderCache = concurrentMap;
    }

    public static final /* synthetic */ ConcurrentMap access$getJrtFsClassLoaderCache$cp() {
        return jrtFsClassLoaderCache;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fR/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "()V", "jrtFsClassLoaderCache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/io/File;", "kotlin.jvm.PlatformType", "Ljava/net/URLClassLoader;", "Lorg/jetbrains/annotations/NotNull;", "isModularJdk", "", "jdkHome", "loadJrtFsJar", "splitPath", "Lkotlin/Pair;", "", "path", "cli"})
    @SourceDebugExtension(value={"SMAP\nCoreJrtFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJrtFileSystem.kt\norg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    public static final class Companion {
        private final File loadJrtFsJar(File jdkHome) {
            File file2;
            File p1 = file2 = new File(jdkHome, "lib/jrt-fs.jar");
            boolean bl = false;
            return p1.exists() ? file2 : null;
        }

        public final boolean isModularJdk(@NotNull File jdkHome) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            return this.loadJrtFsJar(jdkHome) != null;
        }

        @NotNull
        public final Pair<String, String> splitPath(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            int separator = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (separator < 0) {
                throw (Throwable)new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path2);
            }
            String string2 = path2;
            int n = 0;
            String string3 = string2.substring(n, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String localPath = string3;
            String string4 = path2;
            int n2 = separator + "!/".length();
            String string5 = string4.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            String pathInJar = string5;
            return new Pair((Object)localPath, (Object)pathInJar);
        }

        private Companion() {
        }

        public static final /* synthetic */ File access$loadJrtFsJar(Companion $this, File jdkHome) {
            return $this.loadJrtFsJar(jdkHome);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

