/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassIdWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsToModifiers;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J \u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0016R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/FunctionClsStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/CallableClsStubBuilder;", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "outerContext", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "functionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;)V", "contextReceiverTypes", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "getContextReceiverTypes", "()Ljava/util/List;", "receiverAnnotations", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClassIdWithTarget;", "getReceiverAnnotations", "receiverType", "getReceiverType", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "returnType", "getReturnType", "createModifierListStub", "", "createValueParameterList", "doCreateCallableStub", "decompiler-to-stubs"})
@SourceDebugExtension(value={"SMAP\nCallableClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/FunctionClsStubBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1549#2:307\n1620#2,3:308\n*S KotlinDebug\n*F\n+ 1 CallableClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/FunctionClsStubBuilder\n*L\n141#1:307\n141#1:308,3\n*E\n"})
final class FunctionClsStubBuilder
extends CallableClsStubBuilder {
    @NotNull
    private final ProtoBuf.Function functionProto;

    public FunctionClsStubBuilder(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Function functionProto) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkNotNullParameter((Object)functionProto, (String)"functionProto");
        List<ProtoBuf.TypeParameter> list2 = functionProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionProto.typeParameterList");
        super(parent2, outerContext, protoContainer, list2);
        this.functionProto = functionProto;
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReceiverType() {
        return ProtoTypeTableUtilKt.receiverType(this.functionProto, this.getC().getTypeTable());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassIdWithTarget> getReceiverAnnotations() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getC().getComponents().getAnnotationLoader().loadExtensionReceiverParameterAnnotations(this.getProtoContainer(), this.functionProto, AnnotatedCallableKind.FUNCTION);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClassIdWithTarget((ClassId)it, AnnotationUseSiteTarget.RECEIVER));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ProtoBuf.Type getReturnType() {
        return ProtoTypeTableUtilKt.returnType(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    @NotNull
    public List<ProtoBuf.Type> getContextReceiverTypes() {
        return ProtoTypeTableUtilKt.contextReceiverTypes(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    public void createValueParameterList() {
        TypeClsStubBuilder typeClsStubBuilder = this.getTypeStubBuilder();
        StubElement<? extends PsiElement> stubElement = this.getCallableStub();
        MessageLite messageLite = this.functionProto;
        List<ProtoBuf.ValueParameter> list2 = this.functionProto.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionProto.valueParameterList");
        typeClsStubBuilder.createValueParameterListStub(stubElement, messageLite, list2, this.getProtoContainer());
    }

    @Override
    public void createModifierListStub() {
        List modalityModifier = this.isTopLevel() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)FlagsKt.getMODALITY());
        Object[] objectArray = new FlagsToModifiers[]{FlagsKt.getVISIBILITY(), FlagsKt.getOPERATOR(), FlagsKt.getINFIX(), FlagsKt.getEXTERNAL_FUN(), FlagsKt.getINLINE(), FlagsKt.getTAILREC(), FlagsKt.getSUSPEND(), FlagsKt.getEXPECT_FUNCTION()};
        KotlinModifierListStubImpl modifierListStubImpl = ClsStubBuildingKt.createModifierListStubForDeclaration$default(this.getCallableStub(), this.functionProto.getFlags(), CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)modalityModifier), null, 8, null);
        if (!Flags.HAS_ANNOTATIONS.get(this.functionProto.getFlags()).booleanValue()) {
            return;
        }
        List<ClassId> annotationIds = this.getC().getComponents().getAnnotationLoader().loadCallableAnnotations(this.getProtoContainer(), this.functionProto, AnnotatedCallableKind.FUNCTION);
        ClsStubBuildingKt.createAnnotationStubs(annotationIds, modifierListStubImpl);
    }

    @Override
    @NotNull
    public StubElement<? extends PsiElement> doCreateCallableStub(@NotNull StubElement<? extends PsiElement> parent2) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Name callableName = NameResolverUtilKt.getName(this.getC().getNameResolver(), this.functionProto.getName());
        StringRef stringRef = ClsStubBuildingKt.ref(callableName);
        boolean bl = this.isTopLevel();
        FqName fqName2 = this.getC().getContainerFqName().child(callableName);
        boolean bl2 = ProtoTypeTableUtilKt.hasReceiver(this.functionProto);
        boolean bl3 = Flags.MODALITY.get(this.functionProto.getFlags()) != ProtoBuf.Modality.ABSTRACT;
        List<ProtoBuf.TypeParameter> list2 = this.functionProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionProto.typeParameterList");
        return new KotlinFunctionStubImpl(parent2, stringRef, bl, fqName2, bl2, true, bl3, !((Collection)list2).isEmpty(), this.functionProto.hasContract());
    }
}

