/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiExpressionListImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaResolveUtil {
    public static PsiClass getContextClass(@NotNull PsiElement element) {
        if (element == null) {
            JavaResolveUtil.$$$reportNull$$$0(0);
        }
        PsiElement prev = element;
        for (PsiElement scope2 = element.getContext(); scope2 != null; scope2 = scope2.getContext()) {
            if (scope2 instanceof PsiClass && (prev instanceof PsiMember || prev instanceof PsiDocComment)) {
                return (PsiClass)scope2;
            }
            prev = scope2;
        }
        return null;
    }

    public static PsiElement findParentContextOfClass(PsiElement element, Class<?> aClass, boolean strict) {
        PsiElement scope2;
        PsiElement psiElement = scope2 = strict ? element.getContext() : element;
        while (scope2 != null && !aClass.isInstance(scope2)) {
            scope2 = scope2.getContext();
        }
        return scope2;
    }

    public static boolean isAccessible(@NotNull PsiMember member2, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope) {
        if (member2 == null) {
            JavaResolveUtil.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(2);
        }
        return JavaResolveUtil.isAccessible(member2, memberClass, modifierList2, place, accessObjectClass, fileResolveScope, place.getContainingFile());
    }

    public static boolean isAccessible(@NotNull PsiMember member2, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope, @Nullable PsiFile placeFile) {
        PsiClass clazz;
        PsiFile file2;
        PsiClass containingClass;
        if (member2 == null) {
            JavaResolveUtil.$$$reportNull$$$0(3);
        }
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(4);
        }
        if (modifierList2 == null || JavaResolveUtil.isInJavaDoc(place)) {
            return true;
        }
        if (placeFile instanceof JavaCodeFragment) {
            JavaCodeFragment fragment = (JavaCodeFragment)placeFile;
            JavaCodeFragment.VisibilityChecker visibilityChecker = fragment.getVisibilityChecker();
            if (visibilityChecker != null) {
                JavaCodeFragment.VisibilityChecker.Visibility visibility2 = visibilityChecker.isDeclarationVisible(member2, place);
                if (visibility2 == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE) {
                    return true;
                }
                if (visibility2 == JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE) {
                    return false;
                }
            }
        } else if (JavaResolveUtil.ignoreReferencedElementAccessibility(placeFile)) {
            return true;
        }
        if (accessObjectClass != null && !JavaResolveUtil.isAccessible(accessObjectClass, containingClass = accessObjectClass.getContainingClass(), accessObjectClass.getModifierList(), place, null, null, placeFile)) {
            return false;
        }
        PsiFile psiFile = file2 = placeFile == null ? null : FileContextUtil.getContextFile(placeFile);
        if (PsiImplUtil.isInServerPage(file2) && PsiImplUtil.isInServerPage(member2.getContainingFile())) {
            return true;
        }
        int effectiveAccessLevel = PsiUtil.getAccessLevel(modifierList2);
        if (JavaResolveUtil.ignoreReferencedElementAccessibility(file2) || effectiveAccessLevel == 4) {
            return true;
        }
        PsiManager manager = member2.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (effectiveAccessLevel == 3) {
            PsiClass contextClass;
            if (facade.arePackagesTheSame(member2, place)) {
                return true;
            }
            if (memberClass == null) {
                return false;
            }
            if (member2 instanceof PsiClass) {
                contextClass = JavaResolveUtil.getContextClass(place);
            } else {
                contextClass = PsiTreeUtil.getContextOfType(place, PsiClass.class, false);
                if (JavaResolveUtil.isInClassAnnotationParameterList(place, contextClass)) {
                    return false;
                }
            }
            return JavaResolveUtil.canAccessProtectedMember(member2, memberClass, accessObjectClass, contextClass, modifierList2.hasModifierProperty("static"));
        }
        if (effectiveAccessLevel == 1) {
            if (memberClass == null) {
                return true;
            }
            if (accessObjectClass != null) {
                PsiClass topAccessClass;
                PsiClass topMemberClass = JavaResolveUtil.getTopLevelClass(memberClass, accessObjectClass);
                if (!manager.areElementsEquivalent(topMemberClass, topAccessClass = JavaResolveUtil.getTopLevelClass(accessObjectClass, memberClass))) {
                    return false;
                }
                if (accessObjectClass instanceof PsiAnonymousClass && accessObjectClass.isInheritor(memberClass, true) && !(place instanceof PsiAnonymousClass)) {
                    return false;
                }
            }
            PsiClass memberTopLevelClass = JavaResolveUtil.getTopLevelClass(memberClass, null);
            if (fileResolveScope == null) {
                PsiClass placeTopLevelClass = JavaResolveUtil.getTopLevelClass(place, null);
                return manager.areElementsEquivalent(placeTopLevelClass, memberTopLevelClass) && !JavaResolveUtil.isInClassAnnotationParameterList(place, placeTopLevelClass);
            }
            PsiClass scopeTopLevelClass = JavaResolveUtil.getTopLevelClass(fileResolveScope, null);
            return manager.areElementsEquivalent(scopeTopLevelClass, memberTopLevelClass) && fileResolveScope instanceof PsiClass && !((PsiClass)fileResolveScope).isInheritor(memberClass, true);
        }
        if (!facade.arePackagesTheSame(member2, place)) {
            return false;
        }
        PsiClass placeClass = JavaResolveUtil.getContextClass(place);
        if (memberClass == null || placeClass == null) {
            return true;
        }
        if (memberClass.isInterface() || placeClass.isInterface()) {
            return true;
        }
        PsiClass psiClass = clazz = accessObjectClass != null ? accessObjectClass : placeClass.getSuperClass();
        if (clazz != null && clazz.isInheritor(memberClass, true)) {
            PsiClass superClass = clazz;
            while (!manager.areElementsEquivalent(superClass, memberClass)) {
                if (superClass == null || !facade.arePackagesTheSame(superClass, memberClass)) {
                    return false;
                }
                superClass = superClass.getSuperClass();
            }
        }
        return true;
    }

    public static boolean canAccessProtectedMember(@NotNull PsiMember member2, @NotNull PsiClass memberClass, @Nullable PsiClass accessObjectClass, @Nullable PsiClass contextClass, boolean isStatic) {
        if (member2 == null) {
            JavaResolveUtil.$$$reportNull$$$0(5);
        }
        if (memberClass == null) {
            JavaResolveUtil.$$$reportNull$$$0(6);
        }
        while (contextClass != null) {
            if (InheritanceUtil.isInheritorOrSelf(contextClass, memberClass, true) && (member2 instanceof PsiClass || isStatic || accessObjectClass == null || InheritanceUtil.isInheritorOrSelf(accessObjectClass, contextClass, true))) {
                return true;
            }
            contextClass = JavaResolveUtil.getContextClass(contextClass);
        }
        return false;
    }

    private static boolean isInClassAnnotationParameterList(@NotNull PsiElement place, @Nullable PsiClass contextClass) {
        PsiAnnotation annotation2;
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(7);
        }
        return contextClass != null && (annotation2 = PsiTreeUtil.getContextOfType(place, PsiAnnotation.class, true)) != null && PsiTreeUtil.isAncestor(contextClass.getModifierList(), annotation2, false);
    }

    private static boolean ignoreReferencedElementAccessibility(PsiFile placeFile) {
        return placeFile instanceof FileResolveScopeProvider && ((FileResolveScopeProvider)((Object)placeFile)).ignoreReferencedElementAccessibility() && !PsiImplUtil.isInServerPage(placeFile);
    }

    public static boolean isInJavaDoc(@NotNull PsiElement place) {
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(8);
        }
        for (PsiElement scope2 = place; scope2 != null; scope2 = scope2.getContext()) {
            if (scope2 instanceof PsiDocComment) {
                return true;
            }
            if (!(scope2 instanceof PsiMember) && !(scope2 instanceof PsiMethodCallExpression) && !(scope2 instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    private static PsiClass getTopLevelClass(@NotNull PsiElement place, PsiClass memberClass) {
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(9);
        }
        PsiClass lastClass = null;
        Boolean isAtLeast17 = null;
        for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
            if (!(placeParent instanceof PsiClass) || placeParent instanceof PsiAnonymousClass) continue;
            boolean isTypeParameter = placeParent instanceof PsiTypeParameter;
            if (isTypeParameter && isAtLeast17 == null) {
                isAtLeast17 = JavaVersionService.getInstance().isAtLeast(placeParent, JavaSdkVersion.JDK_1_7);
            }
            if (isTypeParameter && !isAtLeast17.booleanValue()) continue;
            PsiClass aClass = (PsiClass)placeParent;
            if (memberClass != null && aClass.isInheritor(memberClass, true)) {
                return aClass;
            }
            lastClass = aClass;
        }
        return lastClass;
    }

    public static boolean processImplicitlyImportedPackages(PsiScopeProcessor processor2, ResolveState state, PsiElement place, PsiManager manager) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage("");
        if (defaultPackage != null && !defaultPackage.processDeclarations(processor2, state, null, place)) {
            return false;
        }
        PsiPackage langPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage("java.lang");
        return langPackage == null || langPackage.processDeclarations(processor2, state, null, place);
    }

    public static void substituteResults(final @NotNull PsiJavaCodeReferenceElement ref, JavaResolveResult @NotNull [] result2) {
        if (ref == null) {
            JavaResolveUtil.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            JavaResolveUtil.$$$reportNull$$$0(11);
        }
        if (result2.length > 0 && result2[0].getElement() instanceof PsiClass) {
            for (int i = 0; i < result2.length; ++i) {
                CandidateInfo resolveResult = (CandidateInfo)result2[i];
                final PsiElement resultElement = resolveResult.getElement();
                if (!(resultElement instanceof PsiClass) || !((PsiClass)resultElement).hasTypeParameters()) continue;
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                result2[i] = new CandidateInfo(resolveResult, substitutor2){

                    @Override
                    @NotNull
                    public PsiSubstitutor getSubstitutor() {
                        PsiType[] parameters2 = ref.getTypeParameters();
                        PsiSubstitutor psiSubstitutor = super.getSubstitutor().putAll((PsiClass)resultElement, parameters2);
                        if (psiSubstitutor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiSubstitutor;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/JavaResolveUtil$1", "getSubstitutor"));
                    }
                };
            }
        }
    }

    public static <T extends PsiPolyVariantReference> JavaResolveResult @NotNull [] resolveWithContainingFile(@NotNull T ref, @NotNull ResolveCache.PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        Project project;
        ResolveResult[] results;
        if (ref == null) {
            JavaResolveUtil.$$$reportNull$$$0(12);
        }
        if (resolver == null) {
            JavaResolveUtil.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            JavaResolveUtil.$$$reportNull$$$0(14);
        }
        JavaResolveResult[] javaResolveResultArray = (results = ResolveCache.getInstance(project = containingFile.getProject()).resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, containingFile)).length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            JavaResolveUtil.$$$reportNull$$$0(15);
        }
        return javaResolveResultArray;
    }

    public static PsiElement resolveImaginarySuperCallInThisPlace(@NotNull PsiMember place, @NotNull Project project, @NotNull PsiClass superClassWhichTheSuperCallMustResolveTo) {
        if (place == null) {
            JavaResolveUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            JavaResolveUtil.$$$reportNull$$$0(17);
        }
        if (superClassWhichTheSuperCallMustResolveTo == null) {
            JavaResolveUtil.$$$reportNull$$$0(18);
        }
        PsiExpressionListImpl expressionList = new PsiExpressionListImpl();
        DummyHolder result2 = DummyHolderFactory.createHolder(PsiManager.getInstance(project), place);
        FileElement holder2 = result2.getTreeElement();
        holder2.rawAddChildren((TreeElement)expressionList.getNode());
        return PsiResolveHelper.SERVICE.getInstance(project).resolveConstructor(PsiTypesUtil.getClassType(superClassWhichTheSuperCallMustResolveTo), expressionList, place).getElement();
    }

    @Nullable
    public static PsiPackage getContainingPackage(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            JavaResolveUtil.$$$reportNull$$$0(19);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return null;
        }
        PsiDirectory directory = file2.getContainingDirectory();
        if (directory == null) {
            return null;
        }
        return JavaDirectoryService.getInstance().getPackage(directory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/JavaResolveUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassWhichTheSuperCallMustResolveTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithContainingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canAccessProtectedMember";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInClassAnnotationParameterList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInJavaDoc";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "substituteResults";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithContainingFile";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveImaginarySuperCallInThisPlace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

