/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParserKt;
import org.jetbrains.kotlin.cli.jvm.plugins.ServiceLoaderLite;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J5\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\u000f\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser;", "", "()V", "loadPlugins", "", "pluginClasspaths", "", "", "pluginOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "loadPluginsSafe", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "", "([Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "processPluginOptions", "classLoader", "Ljava/net/URLClassLoader;", "cli"})
public final class PluginCliParser {
    @NotNull
    public static final PluginCliParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable String[] pluginClasspaths, @Nullable String[] pluginOptions, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return PluginCliParser.loadPluginsSafe(pluginClasspaths != null ? ArraysKt.asIterable((Object[])pluginClasspaths) : null, pluginOptions != null ? ArraysKt.asIterable((Object[])pluginOptions) : null, configuration2);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable Iterable<String> pluginClasspaths, @Nullable Iterable<String> pluginOptions, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        try {
            PluginCliParser.loadPlugins(pluginClasspaths, pluginOptions, configuration2);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, message, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string2 = e.getMessage();
            Intrinsics.checkNotNull((Object)string2);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string2, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector2, t);
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void loadPlugins(@Nullable Iterable<String> pluginClasspaths, @Nullable Iterable<String> pluginOptions, @NotNull CompilerConfiguration configuration2) {
        URL[] uRLArray;
        block4: {
            block3: {
                void $this$toTypedArray$iv;
                Collection<URL> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
                uRLArray = pluginClasspaths;
                if (pluginClasspaths == null) break block3;
                URL[] uRLArray2 = uRLArray;
                boolean $i$f$map = false;
                void var6_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    URL uRL = new File((String)it).toURI().toURL();
                    collection.add(uRL);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray != null) break block4;
            }
            uRLArray = new URL[]{};
        }
        ClassLoader classLoader2 = INSTANCE.getClass().getClassLoader();
        URL[] uRLArray3 = uRLArray;
        URLClassLoader classLoader3 = new URLClassLoader(uRLArray3, classLoader2);
        List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader3);
        configuration2.addAll(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), (Collection)componentRegistrars);
        INSTANCE.processPluginOptions(pluginOptions, configuration2, classLoader3);
    }

    private final void processPluginOptions(Iterable<String> pluginOptions, CompilerConfiguration configuration2, URLClassLoader classLoader2) {
        List<CommandLineProcessor> commandLineProcessors = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader2);
        PluginCliParserKt.processCompilerPluginsOptions(configuration2, pluginOptions, commandLineProcessors);
    }

    private PluginCliParser() {
    }

    static {
        PluginCliParser pluginCliParser;
        INSTANCE = pluginCliParser = new PluginCliParser();
    }
}

