/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J$\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J$\u0010\"\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J$\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002J*\u0010$\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0007J$\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0007J\u000e\u0010(\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002J\f\u0010)\u001a\u00020\u000b*\u00020\u000bH\u0002J(\u0010*\u001a\u00020\t*\u00020\u000b2\u0006\u0010+\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0!H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copySourceMap", "", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "getSuggestedPath", "path", "isKotlinJavascriptIrLibrary", "candidate", "isKotlinJavascriptLibrary", "isZippedKlib", "isZippedKlibInZip", "processDirectory", "action", "Lkotlin/Function1;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "contentIfExists", "correspondingSourceMapFile", "runIfFileExists", "relativePath", "js.config"})
public final class JsLibraryUtils {
    @NotNull
    public static final JsLibraryUtils INSTANCE = new JsLibraryUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String META_INF_RESOURCES;

    private JsLibraryUtils() {
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return !((Collection)KotlinJavascriptMetadataUtils.loadMetadata(library)).isEmpty();
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptIrLibrary(@NotNull File candidate2) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        return INSTANCE.isZippedKlib(candidate2) ? true : (FileUtil.isJarOrZip(candidate2) ? INSTANCE.isZippedKlibInZip(candidate2) : (!FilesKt.resolve((File)candidate2, (String)"default").isDirectory() ? false : (!FilesKt.resolve((File)FilesKt.resolve((File)candidate2, (String)"default"), (String)"manifest").isFile() ? false : FilesKt.resolve((File)FilesKt.resolve((File)candidate2, (String)"default"), (String)"ir").isDirectory())));
    }

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        Intrinsics.checkNotNullParameter((Object)outputLibraryJsPath, (String)"outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Library " + library + " not found";
                throw new AssertionError((Object)string2);
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    public static /* synthetic */ void copyJsFilesFromLibraries$default(List list2, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list2, string2, bl);
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkNotNullParameter(libs, (String)"libs");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = libs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        block2: {
            File jsFile;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)lib, (String)"lib");
                    Intrinsics.checkNotNullParameter(action, (String)"action");
                    if (!lib.isDirectory()) break block1;
                    INSTANCE.traverseDirectory(lib, action);
                    break block2;
                }
                if (!FileUtil.isJarOrZip(lib)) break block3;
                INSTANCE.traverseArchive(lib, action);
                break block2;
            }
            String string2 = lib.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lib.name");
            if (!StringsKt.endsWith$default((String)string2, (String)".js", (boolean)false, (int)2, null)) break block2;
            String string3 = lib.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lib.path");
            INSTANCE.runIfFileExists(lib, string3, action);
            File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file2 != null) {
                String string4 = jsFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jsFile.path");
                INSTANCE.runIfFileExists(file2, string4, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isZippedKlibInZip(File candidate2) {
        boolean manifestFound = false;
        boolean irFound = false;
        Closeable closeable = new ZipFile(candidate2);
        Throwable throwable = null;
        try {
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = it.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"it.entries()");
            Iterator iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                ZipEntry entry = (ZipEntry)iterator2.next();
                if (Intrinsics.areEqual((Object)entry.getName(), (Object)"default/manifest")) {
                    manifestFound = true;
                }
                if (!Intrinsics.areEqual((Object)entry.getName(), (Object)"default/ir/")) continue;
                irFound = true;
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return manifestFound && irFound;
    }

    private final boolean isZippedKlib(File candidate2) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)candidate2), (Object)"klib");
    }

    private final void runIfFileExists(File $this$runIfFileExists, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($this$runIfFileExists.isFile()) {
            action.invoke((Object)new JsLibrary(FilesKt.readText$default((File)$this$runIfFileExists, null, (int)1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($this$runIfFileExists)), $this$runIfFileExists));
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir, (Function1<? super JsLibrary, Unit>)((Function1)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;
            {
                this.$outputLibraryJsPath = $outputLibraryJsPath;
                this.$copySourceMap = $copySourceMap;
                super(1);
            }

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
        }));
    }

    private final String contentIfExists(File $this$contentIfExists) {
        return $this$contentIfExists.exists() ? FilesKt.readText$default((File)$this$contentIfExists, null, (int)1, null) : null;
    }

    private final File correspondingSourceMapFile(File $this$correspondingSourceMapFile) {
        return new File($this$correspondingSourceMapFile.getParentFile(), $this$correspondingSourceMapFile.getName() + ".map");
    }

    private final void processDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir, arg_0 -> JsLibraryUtils.processDirectory$lambda-3(dir, action, arg_0));
    }

    private final void traverseDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, (Function1<? super JsLibrary, Unit>)((Function1)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;
            {
                this.$outputLibraryJsPath = $outputLibraryJsPath;
                this.$copySourceMap = $copySourceMap;
                super(1);
            }

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
        }));
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        block1: {
            File targetFile = new File(outputPath, library.getPath());
            targetFile.getParentFile().mkdirs();
            FilesKt.writeText$default((File)targetFile, (String)library.getContent(), null, (int)2, null);
            if (!copySourceMap) break block1;
            String string2 = library.getSourceMapContent();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                FilesKt.writeText$default((File)new File(targetFile.getParent(), targetFile.getName() + ".map"), (String)it, null, (int)2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        ZipFile zipFile2;
        try {
            zipFile2 = new ZipFile(file2.getPath());
        }
        catch (ZipException e) {
            throw new IOException("Failed to open zip file: " + file2, e);
        }
        try (ZipFile zipFile3 = zipFile2;){
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String correspondingJsPath;
            Object entry;
            Enumeration<? extends ZipEntry> zipEntries = zipFile3.entries();
            List librariesWithoutSourceMaps = new ArrayList();
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                entry = zipEntries.nextElement();
                String entryName = ((ZipEntry)entry).getName();
                if (((ZipEntry)entry).isDirectory()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
                if (StringsKt.endsWith$default((String)entryName, (String)".js", (boolean)false, (int)2, null)) {
                    String relativePath;
                    if (this.getSuggestedPath(entryName) == null) continue;
                    InputStream stream = zipFile3.getInputStream((ZipEntry)entry);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    ((Collection)librariesWithoutSourceMaps).add(new JsLibrary(content, relativePath, null, null));
                    continue;
                }
                if (!StringsKt.endsWith$default((String)entryName, (String)".js.map", (boolean)false, (int)2, null)) continue;
                correspondingJsPath = StringsKt.removeSuffix((String)entryName, (CharSequence)".js.map") + ".js";
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                possibleMapFiles.put(correspondingJsPath, entry);
            }
            entry = librariesWithoutSourceMaps;
            boolean $i$f$map = false;
            correspondingJsPath = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                JsLibrary jsLibrary2 = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    InputStream stream = zipFile3.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                collection.add(jsLibrary);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }
    }

    private final String getSuggestedPath(String path2) {
        String string2 = FileUtil.toSystemIndependentName(path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(path)");
        String systemIndependentPath = string2;
        if (StringsKt.startsWith$default((String)systemIndependentPath, (String)LibraryUtils.INSTANCE.getMETA_INF(), (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)systemIndependentPath, (String)META_INF_RESOURCES, (boolean)false, (int)2, null)) {
                String string3 = path2.substring(META_INF_RESOURCES.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                return string3;
            }
            return null;
        }
        return path2;
    }

    private static final boolean processDirectory$lambda-3(File $dir, Function1 $action, File file2) {
        Intrinsics.checkNotNullParameter((Object)$dir, (String)"$dir");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        String string2 = FileUtil.getRelativePath($dir, file2);
        if (string2 == null) {
            throw new IllegalArgumentException("relativePath should not be null " + $dir + ' ' + file2);
        }
        String relativePath = string2;
        if (StringsKt.endsWith$default((String)relativePath, (String)".js", (boolean)false, (int)2, null)) {
            String string3 = INSTANCE.getSuggestedPath(relativePath);
            if (string3 == null) {
                return true;
            }
            String suggestedRelativePath = string3;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            INSTANCE.runIfFileExists(file2, suggestedRelativePath, (Function1<? super JsLibrary, Unit>)$action);
        }
        return true;
    }

    public static final /* synthetic */ void access$copyLibrary(JsLibraryUtils $this, String outputPath, JsLibrary library, boolean copySourceMap) {
        $this.copyLibrary(outputPath, library, copySourceMap);
    }

    static {
        Logger logger = Logger.getInstance(JsLibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(JsLibraryUtils::class.java)");
        LOG = logger;
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }
}

