/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.caches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.caches.StubsForCollectionClass;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "preComputedStubs", "", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "getPreComputedStubs", "()Ljava/util/Collection;", "preComputedStubs$delegate", "Lkotlin/Lazy;", "stubsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "computeStubsForCollectionClasses", "irClass", "stubsForCollectionClasses", "LazyStubsForCollectionClass", "backend.jvm"})
public final class CollectionStubComputer {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Lazy preComputedStubs$delegate;
    @NotNull
    private final ConcurrentHashMap<IrClass, List<StubsForCollectionClass>> stubsCache;

    public CollectionStubComputer(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.preComputedStubs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends LazyStubsForCollectionClass>>(this){
            final /* synthetic */ CollectionStubComputer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<LazyStubsForCollectionClass> invoke() {
                JvmSymbols $this$invoke_u24lambda_u2d0 = this.this$0.getContext().getIr().getSymbols();
                boolean bl = false;
                Object[] objectArray = new LazyStubsForCollectionClass[]{new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getCollection(), $this$invoke_u24lambda_u2d0.getMutableCollection()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getSet(), $this$invoke_u24lambda_u2d0.getMutableSet()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getList(), $this$invoke_u24lambda_u2d0.getMutableList()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getMap(), $this$invoke_u24lambda_u2d0.getMutableMap()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getMapEntry(), $this$invoke_u24lambda_u2d0.getMutableMapEntry()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getIterable(), $this$invoke_u24lambda_u2d0.getMutableIterable()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getIterator(), $this$invoke_u24lambda_u2d0.getMutableIterator()), new LazyStubsForCollectionClass($this$invoke_u24lambda_u2d0.getListIterator(), $this$invoke_u24lambda_u2d0.getMutableListIterator())};
                return CollectionsKt.listOf((Object[])objectArray);
            }
        }));
        this.stubsCache = new ConcurrentHashMap();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final Collection<StubsForCollectionClass> getPreComputedStubs() {
        Lazy lazy = this.preComputedStubs$delegate;
        return (Collection)lazy.getValue();
    }

    @NotNull
    public final List<StubsForCollectionClass> stubsForCollectionClasses(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        ConcurrentMap $this$getOrPut$iv = this.stubsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(irClass2);
        if (object == null) {
            boolean bl = false;
            List<StubsForCollectionClass> default$iv = this.computeStubsForCollectionClasses(irClass2);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(irClass2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"stubsCache.getOrPut(irCl\u2026lasses(irClass)\n        }");
        return (List)object;
    }

    private final List<StubsForCollectionClass> computeStubsForCollectionClasses(IrClass irClass2) {
        StubsForCollectionClass it;
        Iterable $this$filterTo$iv$iv;
        if (IrUtilsKt.isFromJava(irClass2)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = this.getPreComputedStubs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StubsForCollectionClass)element$iv$iv;
            boolean bl = false;
            if (!(IrTypeUtilsKt.isStrictSubtypeOfClass(irClass2.getSymbol(), it.getReadOnlyClass()) && !IrTypeUtilsKt.isSubtypeOfClass(irClass2.getSymbol(), it.getMutableClass()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stubs = (List)destination$iv$iv;
        $this$filter$iv = stubs;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                it = (StubsForCollectionClass)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = stubs;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        StubsForCollectionClass other = (StubsForCollectionClass)element$iv;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getReadOnlyClass(), (Object)other.getReadOnlyClass()) && IrTypeUtilsKt.isSubtypeOfClass(other.getReadOnlyClass(), it.getReadOnlyClass()))) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer$LazyStubsForCollectionClass;", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "readOnlyClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "mutableClass", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)V", "candidatesForStubs", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getCandidatesForStubs", "()Ljava/util/Collection;", "candidatesForStubs$delegate", "Lkotlin/Lazy;", "getMutableClass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getReadOnlyClass", "backend.jvm"})
    private static final class LazyStubsForCollectionClass
    implements StubsForCollectionClass {
        @NotNull
        private final IrClassSymbol readOnlyClass;
        @NotNull
        private final IrClassSymbol mutableClass;
        @NotNull
        private final Lazy candidatesForStubs$delegate;

        public LazyStubsForCollectionClass(@NotNull IrClassSymbol readOnlyClass, @NotNull IrClassSymbol mutableClass) {
            Intrinsics.checkNotNullParameter((Object)readOnlyClass, (String)"readOnlyClass");
            Intrinsics.checkNotNullParameter((Object)mutableClass, (String)"mutableClass");
            this.readOnlyClass = readOnlyClass;
            this.mutableClass = mutableClass;
            this.candidatesForStubs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends IrSimpleFunction>>(this){
                final /* synthetic */ LazyStubsForCollectionClass this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<IrSimpleFunction> invoke() {
                    return SequencesKt.toList((Sequence)SequencesKt.filter(IrUtilsKt.getFunctions((IrClass)this.this$0.getMutableClass().getOwner()), (Function1)((Function1)new Function1<IrSimpleFunction, Boolean>(this.this$0){
                        final /* synthetic */ LazyStubsForCollectionClass this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        @NotNull
                        public final Boolean invoke(@NotNull IrSimpleFunction memberFun) {
                            boolean bl;
                            block9: {
                                block8: {
                                    boolean bl2;
                                    block7: {
                                        void $this$none$iv;
                                        Intrinsics.checkNotNullParameter((Object)memberFun, (String)"memberFun");
                                        if (!memberFun.isFakeOverride()) break block8;
                                        if (memberFun.getModality() != Modality.ABSTRACT) break block9;
                                        Iterable iterable = memberFun.getOverriddenSymbols();
                                        LazyStubsForCollectionClass lazyStubsForCollectionClass = this.this$0;
                                        boolean $i$f$none = false;
                                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                            bl2 = true;
                                        } else {
                                            for (T element$iv : $this$none$iv) {
                                                IrSimpleFunctionSymbol overriddenFun = (IrSimpleFunctionSymbol)element$iv;
                                                boolean bl3 = false;
                                                if (!Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass((IrDeclaration)overriddenFun.getOwner()).getSymbol(), (Object)lazyStubsForCollectionClass.getReadOnlyClass())) continue;
                                                bl2 = false;
                                                break block7;
                                            }
                                            bl2 = true;
                                        }
                                    }
                                    if (!bl2) break block9;
                                }
                                bl = true;
                                return bl;
                            }
                            bl = false;
                            return bl;
                        }
                    })));
                }
            }));
        }

        @Override
        @NotNull
        public IrClassSymbol getReadOnlyClass() {
            return this.readOnlyClass;
        }

        @Override
        @NotNull
        public IrClassSymbol getMutableClass() {
            return this.mutableClass;
        }

        @Override
        @NotNull
        public Collection<IrSimpleFunction> getCandidatesForStubs() {
            Lazy lazy = this.candidatesForStubs$delegate;
            return (Collection)lazy.getValue();
        }
    }
}

