/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponentsKt;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataElement;
import org.jetbrains.kotlin.fir.resolve.PersistentImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B=\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0004j\u0002`\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u001c\u0010\u001c\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0004j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirTowerDataContext;", "", "()V", "towerDataElements", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/resolve/FirTowerDataElement;", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "localScopes", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/resolve/FirLocalScopes;", "nonLocalTowerDataElements", "(Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;Lkotlinx/collections/immutable/PersistentList;Lkotlinx/collections/immutable/PersistentList;)V", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "getLocalScopes", "()Lkotlinx/collections/immutable/PersistentList;", "getNonLocalTowerDataElements", "getTowerDataElements", "addLocalScope", "localScope", "addNonLocalScope", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "addNonLocalScopeIfNotNull", "addNonLocalTowerDataElements", "newElements", "", "addReceiver", "name", "Lorg/jetbrains/kotlin/name/Name;", "implicitReceiverValue", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "setLastLocalScope", "newLastScope", "resolve"})
public final class FirTowerDataContext {
    @NotNull
    private final PersistentList<FirTowerDataElement> towerDataElements;
    @NotNull
    private final PersistentImplicitReceiverStack implicitReceiverStack;
    @NotNull
    private final PersistentList<FirLocalScope> localScopes;
    @NotNull
    private final PersistentList<FirTowerDataElement> nonLocalTowerDataElements;

    private FirTowerDataContext(PersistentList<FirTowerDataElement> towerDataElements, PersistentImplicitReceiverStack implicitReceiverStack, PersistentList<FirLocalScope> localScopes, PersistentList<FirTowerDataElement> nonLocalTowerDataElements) {
        this.towerDataElements = towerDataElements;
        this.implicitReceiverStack = implicitReceiverStack;
        this.localScopes = localScopes;
        this.nonLocalTowerDataElements = nonLocalTowerDataElements;
    }

    @NotNull
    public final PersistentList<FirTowerDataElement> getTowerDataElements() {
        return this.towerDataElements;
    }

    @NotNull
    public final PersistentImplicitReceiverStack getImplicitReceiverStack() {
        return this.implicitReceiverStack;
    }

    @NotNull
    public final PersistentList<FirLocalScope> getLocalScopes() {
        return this.localScopes;
    }

    @NotNull
    public final PersistentList<FirTowerDataElement> getNonLocalTowerDataElements() {
        return this.nonLocalTowerDataElements;
    }

    public FirTowerDataContext() {
        this(ExtensionsKt.persistentListOf(), new PersistentImplicitReceiverStack(), ExtensionsKt.persistentListOf(), ExtensionsKt.persistentListOf());
    }

    @NotNull
    public final FirTowerDataContext setLastLocalScope(@NotNull FirLocalScope newLastScope) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)newLastScope, (String)"newLastScope");
            FirLocalScope oldLastScope = (FirLocalScope)CollectionsKt.last((List)this.localScopes);
            List $this$indexOfLast$iv = this.towerDataElements;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                FirTowerDataElement it = (FirTowerDataElement)iterator$iv.previous();
                boolean bl = false;
                if (!(it.getScope() == oldLastScope)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        int indexOfLastLocalScope = n;
        return new FirTowerDataContext(this.towerDataElements.set(indexOfLastLocalScope, BodyResolveComponentsKt.asTowerDataElement(newLastScope, true)), this.implicitReceiverStack, this.localScopes.set(CollectionsKt.getLastIndex((List)this.localScopes), newLastScope), this.nonLocalTowerDataElements);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirTowerDataContext addNonLocalTowerDataElements(@NotNull List<FirTowerDataElement> newElements) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(newElements, (String)"newElements");
        Iterable iterable = newElements;
        PersistentImplicitReceiverStack persistentImplicitReceiverStack = this.implicitReceiverStack;
        PersistentList<FirTowerDataElement> persistentList = this.towerDataElements.addAll((Collection<FirTowerDataElement>)newElements);
        boolean $i$f$mapNotNull = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImplicitReceiverValue<?> implicitReceiverValue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTowerDataElement it = (FirTowerDataElement)element$iv$iv;
            boolean bl2 = false;
            ImplicitReceiverValue<?> implicitReceiverValue2 = it.getImplicitReceiver();
            if (implicitReceiverValue2 == null) continue;
            ImplicitReceiverValue<?> it$iv$iv = implicitReceiverValue = implicitReceiverValue2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        PersistentList<FirTowerDataElement> persistentList2 = this.nonLocalTowerDataElements.addAll((Collection<FirTowerDataElement>)newElements);
        PersistentList<FirLocalScope> persistentList3 = this.localScopes;
        PersistentImplicitReceiverStack persistentImplicitReceiverStack2 = persistentImplicitReceiverStack.addAll(list2);
        PersistentList<FirTowerDataElement> persistentList4 = persistentList;
        return new FirTowerDataContext(persistentList4, persistentImplicitReceiverStack2, persistentList3, persistentList2);
    }

    @NotNull
    public final FirTowerDataContext addLocalScope(@NotNull FirLocalScope localScope) {
        Intrinsics.checkNotNullParameter((Object)localScope, (String)"localScope");
        return new FirTowerDataContext(this.towerDataElements.add(BodyResolveComponentsKt.asTowerDataElement(localScope, true)), this.implicitReceiverStack, this.localScopes.add(localScope), this.nonLocalTowerDataElements);
    }

    @NotNull
    public final FirTowerDataContext addReceiver(@Nullable Name name, @NotNull ImplicitReceiverValue<?> implicitReceiverValue) {
        Intrinsics.checkNotNullParameter(implicitReceiverValue, (String)"implicitReceiverValue");
        FirTowerDataElement element = BodyResolveComponentsKt.asTowerDataElement(implicitReceiverValue);
        return new FirTowerDataContext(this.towerDataElements.add(element), this.implicitReceiverStack.add(name, implicitReceiverValue), this.localScopes, this.nonLocalTowerDataElements.add(element));
    }

    @NotNull
    public final FirTowerDataContext addNonLocalScopeIfNotNull(@Nullable FirScope scope2) {
        if (scope2 == null) {
            return this;
        }
        return this.addNonLocalScope(scope2);
    }

    private final FirTowerDataContext addNonLocalScope(FirScope scope2) {
        FirTowerDataElement element = BodyResolveComponentsKt.asTowerDataElement(scope2, false);
        return new FirTowerDataContext(this.towerDataElements.add(element), this.implicitReceiverStack, this.localScopes, this.nonLocalTowerDataElements.add(element));
    }
}

