/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SafeJdomFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.AttributeType;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;

final class SafeStAXStreamBuilder {
    static final SafeJdomFactory FACTORY = new SafeJdomFactory.BaseSafeJdomFactory();

    static Element build(@NotNull XMLStreamReader stream, boolean isIgnoreBoundaryWhitespace, @NotNull SafeJdomFactory factory2) throws JDOMException, XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(1);
        }
        if (factory2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(2);
        }
        if (7 != (state = stream.getEventType())) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace, factory2);
                    break;
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new JDOMException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    private static Element processElementFragment(@NotNull XMLStreamReader reader, boolean isIgnoreBoundaryWhitespace, @NotNull SafeJdomFactory factory2) throws XMLStreamException, JDOMException {
        Element fragment;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(3);
        }
        if (factory2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(4);
        }
        if (reader.getEventType() != 1) {
            throw new JDOMException("JDOM requires that the XMLStreamReader is at the START_ELEMENT state when retrieving an Element Fragment.");
        }
        Element current2 = fragment = SafeStAXStreamBuilder.processElement(reader, factory2);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilder.processElement(reader, factory2);
                    current2.addContent(tmp);
                    current2 = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    current2 = current2.getParentElement();
                    --depth;
                    continue block8;
                }
                case 12: {
                    current2.addContent(factory2.cdata(reader.getText()));
                    continue block8;
                }
                case 6: {
                    if (!isIgnoreBoundaryWhitespace) {
                        current2.addContent(factory2.text(reader.getText(), current2));
                    }
                }
                case 4: {
                    if (isIgnoreBoundaryWhitespace && reader.isWhiteSpace()) continue block8;
                    current2.addContent(factory2.text(reader.getText(), current2));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new JDOMException("Unexpected XMLStream event " + reader.getEventType());
        }
        return fragment;
    }

    @NotNull
    private static Element processElement(@NotNull XMLStreamReader reader, @NotNull SafeJdomFactory factory2) {
        int i;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(5);
        }
        if (factory2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(6);
        }
        Element element = factory2.element(reader.getLocalName(), Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()));
        int len = reader.getAttributeCount();
        for (i = 0; i < len; ++i) {
            element.setAttribute(factory2.attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i), AttributeType.getAttributeType(reader.getAttributeType(i)), Namespace.getNamespace(reader.getAttributePrefix(i), reader.getAttributeNamespace(i))));
        }
        len = reader.getNamespaceCount();
        for (i = 0; i < len; ++i) {
            element.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
        }
        Element element2 = element;
        if (element2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(7);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDocument";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementFragment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

