/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "Kind", "kotlin-build-common"})
public final class ConstantsMapExternalizer
implements DataExternalizer<Map<String, ? extends Object>> {
    public static final ConstantsMapExternalizer INSTANCE;

    @Override
    public void save(@NotNull DataOutput output, @Nullable Map<String, ? extends Object> map2) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Map<String, ? extends Object> map3 = map2;
        if (map3 == null) {
            Intrinsics.throwNpe();
        }
        output.writeInt(map3.size());
        for (String name : CollectionsKt.sorted((Iterable)map2.keySet())) {
            Object value2;
            Object object;
            IOUtil.writeString(name, output);
            if (map2.get(name) == null) {
                Intrinsics.throwNpe();
            }
            if ((object = value2) instanceof Integer) {
                output.writeByte(Kind.INT.ordinal());
                output.writeInt(((Number)value2).intValue());
                continue;
            }
            if (object instanceof Float) {
                output.writeByte(Kind.FLOAT.ordinal());
                output.writeFloat(((Number)value2).floatValue());
                continue;
            }
            if (object instanceof Long) {
                output.writeByte(Kind.LONG.ordinal());
                output.writeLong(((Number)value2).longValue());
                continue;
            }
            if (object instanceof Double) {
                output.writeByte(Kind.DOUBLE.ordinal());
                output.writeDouble(((Number)value2).doubleValue());
                continue;
            }
            if (object instanceof String) {
                output.writeByte(Kind.STRING.ordinal());
                IOUtil.writeString((String)value2, output);
                continue;
            }
            throw (Throwable)new IllegalStateException("Unexpected constant class: " + value2.getClass());
        }
    }

    @Override
    @Nullable
    public Map<String, Object> read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int size = input.readInt();
        HashMap map2 = new HashMap(size);
        boolean bl = false;
        int n = 0;
        int n2 = size;
        for (n = 0; n < n2; ++n) {
            String name;
            Object object;
            int it = n;
            boolean bl2 = false;
            if (IOUtil.readString(input) == null) {
                Intrinsics.throwNpe();
            }
            Kind kind = Kind.values()[input.readByte()];
            switch (ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    object = input.readInt();
                    break;
                }
                case 2: {
                    object = Float.valueOf(input.readFloat());
                    break;
                }
                case 3: {
                    object = input.readLong();
                    break;
                }
                case 4: {
                    object = input.readDouble();
                    break;
                }
                case 5: {
                    object = IOUtil.readString(input);
                    if (object != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Object value2 = object;
            ((Map)map2).put(name, value2);
        }
        return map2;
    }

    private ConstantsMapExternalizer() {
    }

    static {
        ConstantsMapExternalizer constantsMapExternalizer;
        INSTANCE = constantsMapExternalizer = new ConstantsMapExternalizer();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING", "kotlin-build-common"})
    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INT;
        public static final /* enum */ Kind FLOAT;
        public static final /* enum */ Kind LONG;
        public static final /* enum */ Kind DOUBLE;
        public static final /* enum */ Kind STRING;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[5];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = INT = new Kind();
            kindArray[1] = FLOAT = new Kind();
            kindArray[2] = LONG = new Kind();
            kindArray[3] = DOUBLE = new Kind();
            kindArray[4] = STRING = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string2) {
            return Enum.valueOf(Kind.class, string2);
        }
    }
}

