/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.container.ClashResolutionDescriptor;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0000J \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "()V", "registrationMap", "Ljava/util/HashMap;", "Ljava/lang/reflect/Type;", "Lkotlin/collections/HashMap;", "addAll", "", "descriptors", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "other", "buildRegistrationMap", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "resolveClashesIfAny", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "clashResolvers", "", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "tryGetEntry", "request"})
public final class ComponentRegistry {
    @NotNull
    private final HashMap<Type, Object> registrationMap = new HashMap();

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap<Type, ComponentDescriptor> registrationMap = new MultiMap<Type, ComponentDescriptor>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue(registration, componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap<Type, ComponentDescriptor> newRegistrationMap = this.buildRegistrationMap(descriptors);
        for (Map.Entry<Type, Collection<ComponentDescriptor>> entry : newRegistrationMap.entrySet()) {
            Object object;
            Map map;
            Object oldEntries = this.registrationMap.get(entry.getKey());
            if (oldEntries != null || entry.getValue().size() > 1) {
                List list2 = new ArrayList();
                if (oldEntries instanceof Collection) {
                    list2.addAll((Collection)oldEntries);
                } else if (oldEntries != null) {
                    list2.add((ComponentDescriptor)oldEntries);
                }
                Collection<ComponentDescriptor> collection = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"entry.value");
                list2.addAll(collection);
                map = this.registrationMap;
                Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"entry.key");
                Object object2 = (ComponentDescriptor)CollectionsKt.singleOrNull((List)list2);
                if (object2 == null) {
                    object2 = list2;
                }
                ComponentDescriptor componentDescriptor = object2;
                map.put(object, componentDescriptor);
                continue;
            }
            Map map2 = this.registrationMap;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"entry.key");
            Collection<ComponentDescriptor> collection = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"entry.value");
            Intrinsics.checkNotNullExpressionValue((Object)CollectionsKt.single((Iterable)collection), (String)"entry.value.single()");
            map2.put(map, object);
        }
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Collection collection;
        Object value2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = value2 = this.registrationMap.get(request);
        if (object instanceof Collection) {
            Object object2 = value2;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
            }
            collection = (Collection)object2;
        } else if (object == null) {
            collection = CollectionsKt.emptyList();
        } else {
            Object object3 = value2;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
            }
            collection = CollectionsKt.listOf((Object)((ComponentDescriptor)object3));
        }
        return collection;
    }

    public final void addAll(@NotNull ComponentRegistry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.registrationMap.isEmpty()) {
            throw new IllegalStateException("Can only copy entries from another component registry into an empty component registry");
        }
        ((Map)this.registrationMap).putAll((Map)other.registrationMap);
    }

    public final void resolveClashesIfAny(@NotNull ComponentContainer container, @NotNull List<? extends PlatformExtensionsClashResolver<?>> clashResolvers) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(clashResolvers, (String)"clashResolvers");
        for (PlatformExtensionsClashResolver<?> resolver : clashResolvers) {
            Collection clashedComponents;
            Object object = this.registrationMap.get(resolver.getApplicableTo());
            Collection collection = object instanceof Collection ? (Collection)object : null;
            if (collection == null || (clashedComponents = collection).size() <= 1) continue;
            ClashResolutionDescriptor substituteDescriptor = new ClashResolutionDescriptor(container, resolver, CollectionsKt.toList((Iterable)clashedComponents));
            ((Map)this.registrationMap).put(resolver.getApplicableTo(), substituteDescriptor);
        }
    }
}

