/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeCheckerContext;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002J0\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001a2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002J4\u0010\u001d\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u001e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\u001f\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010 \u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010#\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010$\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010%\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010&\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010'\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010(\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010)\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0016*\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0\u0016*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010-\u001a\u00020.*\u00020.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001e2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "typeCheckerContext", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkMutability", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkReturnType", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "retrieveDirectOverriddenOf", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeTypeCheckerContext typeCheckerContext = SessionUtilsKt.getTypeContext(context2.getSession()).newBaseTypeCheckerContext(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        for (FirDeclaration it : declaration2.getDeclarations()) {
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirSimpleFunction) {
                this.checkFunction((FirSimpleFunction)it, reporter, typeCheckerContext, firTypeScope, context2);
                continue;
            }
            if (!(firDeclaration instanceof FirProperty)) continue;
            this.checkProperty((FirProperty)it, reporter, typeCheckerContext, firTypeScope, context2);
        }
    }

    private final List<FirFunctionSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirSimpleFunction function2) {
        $this$retrieveDirectOverriddenOf.processFunctionsByName(function2.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)retrieveDirectOverriddenOf.1.INSTANCE));
        return FirTypeScopeKt.getDirectOverriddenFunctions($this$retrieveDirectOverriddenOf, function2.getSymbol());
    }

    private final List<FirPropertySymbol> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirProperty property2) {
        $this$retrieveDirectOverriddenOf.processPropertiesByName(property2.getName(), retrieveDirectOverriddenOf.2.INSTANCE);
        return FirTypeScopeKt.getDirectOverriddenProperties($this$retrieveDirectOverriddenOf, property2.getSymbol());
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableMemberDeclaration<?> overrideDeclaration, FirCallableDeclaration<?> baseDeclaration, CheckerContext context2) {
        FirTypeParametersOwner firTypeParametersOwner;
        if (overrideDeclaration.getTypeParameters().isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        FirCallableDeclaration<?> $this$safeAs$iv22 = baseDeclaration;
        boolean $i$f$safeAs = false;
        FirCallableDeclaration<?> firCallableDeclaration = $this$safeAs$iv22;
        if (!(firCallableDeclaration instanceof FirTypeParametersOwner)) {
            firCallableDeclaration = null;
        }
        if ((firTypeParametersOwner = (FirTypeParametersOwner)((Object)firCallableDeclaration)) == null) {
            return $this$substituteAllTypeParameters;
        }
        FirTypeParametersOwner parametersOwner = firTypeParametersOwner;
        boolean $this$safeAs$iv22 = false;
        Map map = new LinkedHashMap();
        int n = 0;
        int size = ((Number)((Object)AddToStdlibKt.min(overrideDeclaration.getTypeParameters().size(), parametersOwner.getTypeParameters().size()))).intValue();
        if (n < size) {
            do {
                int it = n++;
                FirTypeParameterRef to = overrideDeclaration.getTypeParameters().get(it);
                FirTypeParameter from = parametersOwner.getTypeParameters().get(it);
                Map map2 = map;
                FirTypeParameterSymbol firTypeParameterSymbol = from.getSymbol();
                ConeKotlinType coneKotlinType = FirNestedClassifierScopeKt.toConeType(to);
                boolean bl = false;
                map2.put(firTypeParameterSymbol, coneKotlinType);
            } while (n < size);
        }
        return SubstitutorsKt.substitutorByMap(map, context2.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableDeclaration<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        for (FirCallableSymbol<?> overridden : overriddenSymbols2) {
            Modality modality;
            boolean isEffectivelyFinal;
            if (!(overridden.getFir() instanceof FirMemberDeclaration) || !(isEffectivelyFinal = (modality = ((FirMemberDeclaration)overridden.getFir()).getStatus().getModality()) == null || modality == Modality.FINAL)) continue;
            return (FirCallableDeclaration)overridden.getFir();
        }
        return null;
    }

    private final FirMemberDeclaration checkMutability(FirProperty $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        FirMemberDeclaration firMemberDeclaration;
        Object v0;
        Object object;
        block7: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            object = overriddenSymbols2;
            boolean bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl3 = false;
                Object e = it.getFir();
                FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
                if (!Intrinsics.areEqual((Object)(firProperty == null ? null : Boolean.valueOf(firProperty.isVar())), (Object)true)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        FirCallableSymbol firCallableSymbol = v0;
        if (firCallableSymbol == null) {
            firMemberDeclaration = null;
        } else {
            object = (FirCallableDeclaration)firCallableSymbol.getFir();
            if (object == null) {
                firMemberDeclaration = null;
            } else {
                Object $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                Object object2 = $this$safeAs$iv;
                if (!(object2 instanceof FirMemberDeclaration)) {
                    object2 = null;
                }
                firMemberDeclaration = (FirMemberDeclaration)object2;
            }
        }
        return firMemberDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableMemberDeclaration<?> $this$checkVisibility, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context2) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv22;
        Iterable $this$mapNotNull$iv = overriddenSymbols2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getFir() instanceof FirMemberDeclaration)) {
                pair = null;
            } else {
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)it.getFir();
                boolean $i$f$getVisibility = false;
                pair = TuplesKt.to((Object)it, (Object)$this$visibility$iv.getStatus().getVisibility());
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$mapNotNullTo$iv$iv22 = false;
        List visibilities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>($this$checkVisibility){
            final /* synthetic */ FirCallableMemberDeclaration $this_checkVisibility$inlined;
            {
                this.$this_checkVisibility$inlined = firCallableMemberDeclaration;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair pair = (Pair)a;
                boolean bl2 = false;
                FirMemberDeclaration $this$visibility$iv = this.$this_checkVisibility$inlined;
                boolean $i$f$getVisibility = false;
                Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), (Visibility)pair.getSecond());
                int n2 = n == null ? Integer.MIN_VALUE : n;
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                $this$visibility$iv = this.$this_checkVisibility$inlined;
                $i$f$getVisibility = false;
                n = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), (Visibility)pair.getSecond());
                Integer n3 = n == null ? Integer.MIN_VALUE : n;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
            }
        });
        for (Pair pair : visibilities) {
            FirCallableSymbol overridden = (FirCallableSymbol)pair.component1();
            Visibility overriddenVisibility = (Visibility)pair.component2();
            FirMemberDeclaration $this$visibility$iv = $this$checkVisibility;
            boolean $i$f$getVisibility = false;
            Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getStatus().getVisibility(), overriddenVisibility);
            if (compare == null) {
                this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, (FirCallableDeclaration)overridden.getFir(), context2);
                return;
            }
            if (compare >= 0) continue;
            this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, (FirCallableDeclaration)overridden.getFir(), context2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirMemberDeclaration checkReturnType(FirCallableMemberDeclaration<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, AbstractTypeCheckerContext typeCheckerContext, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getReturnTypeRef());
        if (overridingReturnType instanceof ConeClassErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = ConeTypesKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)it.getFir())));
            collection.add(coneKotlinType);
        }
        int n = 0;
        List bounds = (List)destination$iv$iv;
        int n2 = bounds.size() + -1;
        if (n <= n2) {
            do {
                boolean isReturnTypeOkForOverride;
                int it = n++;
                FirCallableDeclaration overriddenDeclaration = (FirCallableDeclaration)overriddenSymbols2.get(it).getFir();
                ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context2);
                boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirProperty && ((FirProperty)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerContext, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerContext, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
                if (isReturnTypeOkForOverride) continue;
                FirCallableDeclaration $this$safeAs$iv = overriddenDeclaration;
                boolean $i$f$safeAs = false;
                FirCallableDeclaration firCallableDeclaration = $this$safeAs$iv;
                if (!(firCallableDeclaration instanceof FirMemberDeclaration)) {
                    firCallableDeclaration = null;
                }
                return (FirMemberDeclaration)((Object)firCallableDeclaration);
            } while (n <= n2);
        }
        return null;
    }

    private final void checkFunction(FirSimpleFunction function2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        boolean bl;
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        FirMemberDeclaration $this$isOverride$iv = function2;
        boolean $i$f$isOverride22 = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        List<FirFunctionSymbol<?>> overriddenFunctionSymbols = this.retrieveDirectOverriddenOf(firTypeScope, function2);
        if (overriddenFunctionSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, function2, context2);
            return;
        }
        FirCallableDeclaration<?> $i$f$isOverride22 = this.checkModality(overriddenFunctionSymbols);
        if ($i$f$isOverride22 != null) {
            firAnnotatedDeclaration = $i$f$isOverride22;
            boolean bl2 = false;
            bl = false;
            FirCallableDeclaration<?> it = firAnnotatedDeclaration;
            boolean bl3 = false;
            INSTANCE.reportOverridingFinalMember(reporter, function2, it, context2);
        }
        this.checkVisibility(function2, reporter, overriddenFunctionSymbols, context2);
        FirMemberDeclaration restriction = this.checkReturnType(function2, overriddenFunctionSymbols, typeCheckerContext, context2);
        firAnnotatedDeclaration = restriction;
        if (firAnnotatedDeclaration != null) {
            FirAnnotatedDeclaration firAnnotatedDeclaration2 = firAnnotatedDeclaration;
            bl = false;
            boolean bl4 = false;
            FirAnnotatedDeclaration it = firAnnotatedDeclaration2;
            boolean bl5 = false;
            INSTANCE.reportReturnTypeMismatchOnFunction(reporter, function2, (FirMemberDeclaration)it, context2);
        }
    }

    private final void checkProperty(FirProperty property2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        FirCallableDeclaration<?> it;
        boolean bl;
        boolean bl2;
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        FirMemberDeclaration $this$isOverride$iv = property2;
        boolean $i$f$isOverride22 = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        List<FirPropertySymbol> overriddenPropertySymbols = this.retrieveDirectOverriddenOf(firTypeScope, property2);
        if (overriddenPropertySymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, property2, context2);
            return;
        }
        FirAnnotatedDeclaration $i$f$isOverride22 = this.checkModality(overriddenPropertySymbols);
        if ($i$f$isOverride22 != null) {
            firAnnotatedDeclaration = $i$f$isOverride22;
            bl2 = false;
            bl = false;
            it = firAnnotatedDeclaration;
            boolean bl3 = false;
            INSTANCE.reportOverridingFinalMember(reporter, property2, it, context2);
        }
        $i$f$isOverride22 = this.checkMutability(property2, overriddenPropertySymbols);
        if ($i$f$isOverride22 != null) {
            firAnnotatedDeclaration = $i$f$isOverride22;
            bl2 = false;
            bl = false;
            it = firAnnotatedDeclaration;
            boolean bl4 = false;
            INSTANCE.reportVarOverriddenByVal(reporter, property2, (FirMemberDeclaration)((Object)it), context2);
        }
        this.checkVisibility(property2, reporter, overriddenPropertySymbols, context2);
        FirMemberDeclaration restriction = this.checkReturnType(property2, overriddenPropertySymbols, typeCheckerContext, context2);
        firAnnotatedDeclaration = restriction;
        if (firAnnotatedDeclaration != null) {
            FirAnnotatedDeclaration firAnnotatedDeclaration2 = firAnnotatedDeclaration;
            bl = false;
            boolean bl5 = false;
            FirAnnotatedDeclaration it2 = firAnnotatedDeclaration2;
            boolean bl6 = false;
            if (property2.isVar()) {
                INSTANCE.reportTypeMismatchOnVariable(reporter, property2, (FirMemberDeclaration)it2, context2);
            } else {
                INSTANCE.reportTypeMismatchOnProperty(reporter, property2, (FirMemberDeclaration)it2, context2);
            }
        }
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirMemberDeclaration declaration2, CheckerContext context2) {
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        FirSourceElement firSourceElement = overriding.getSource();
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement source = firSourceElement2;
            boolean bl3 = false;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
            if (coneClassLikeLookupTag != null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
                boolean bl4 = false;
                boolean bl5 = false;
                ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag2;
                boolean bl6 = false;
                $this$reportOverridingFinalMember.report((FirDiagnostic)FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER().on(source, overridden, containingClass.getName()), context2);
            }
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        FirSourceElement firSourceElement = overriding.getSource();
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportVarOverriddenByVal.report((FirDiagnostic)FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL().on(it, overriding, overridden), context2);
        }
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirMemberDeclaration $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn($this$reportCannotWeakenAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), $this$visibility$iv.getStatus().getVisibility(), overridden, containingClass.getName(), context2);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirMemberDeclaration overriding, FirCallableDeclaration<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirMemberDeclaration $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        DiagnosticReporterKt.reportOn($this$reportCannotChangeAccessPrivilege, overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), $this$visibility$iv.getStatus().getVisibility(), overridden, containingClass.getName(), context2);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn($this$reportReturnTypeMismatchOnFunction, overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn($this$reportTypeMismatchOnProperty, overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirMemberDeclaration overriding, FirMemberDeclaration overridden, CheckerContext context2) {
        DiagnosticReporterKt.reportOn($this$reportTypeMismatchOnVariable, overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, context2);
    }
}

