/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;

public final class AnnotationsUtils {
    private static final FqName JS_EXPORT = new FqName("kotlin.js.JsExport");
    public static final FqName JS_MODULE_ANNOTATION = new FqName("kotlin.js.JsModule");
    private static final FqName JS_NON_MODULE_ANNOTATION = new FqName("kotlin.js.JsNonModule");
    public static final FqName JS_QUALIFIER_ANNOTATION = new FqName("kotlin.js.JsQualifier");

    private AnnotationsUtils() {
    }

    public static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(0);
        }
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(1);
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(2);
        }
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(3);
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation2);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value2 = constant.getValue();
        assert (value2 instanceof String) : "Native function annotation should have one String parameter";
        return (String)value2;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            AnnotationsUtils.$$$reportNull$$$0(4);
        }
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(5);
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation2)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation2);
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(6);
        }
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(7);
        }
        String defaultJsName = AnnotationsUtils.getJsName(descriptor2);
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.Companion.getWITH_CUSTOM_NAME()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, annotation2);
            if (name == null) {
                name = defaultJsName;
            }
            return name != null ? name : descriptor2.getName().asString();
        }
        if (defaultJsName == null && (AnnotationsUtils.isEffectivelyExternalMember(descriptor2) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext))) {
            return descriptor2.getName().asString();
        }
        return defaultJsName;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(8);
        }
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(9);
        }
        return descriptor2.getAnnotations().findAnnotation(annotation2.getFqName());
    }

    public static boolean isExportedObject(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        MemberDescriptor memberDescriptor;
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(10);
        }
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(11);
        }
        if (descriptor2 instanceof MemberDescriptor && (memberDescriptor = (MemberDescriptor)descriptor2).getVisibility() != Visibilities.PUBLIC) {
            return false;
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, JS_EXPORT)) {
            return true;
        }
        return CollectionsKt.any(AnnotationsUtils.getContainingFileAnnotations(bindingContext, descriptor2), annotation2 -> JS_EXPORT.equals(annotation2.getFqName()));
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(12);
        }
        if (AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.NATIVE) || AnnotationsUtils.isEffectivelyExternalMember(descriptor2)) {
            return true;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyAccessorDescriptor accessor = (PropertyAccessorDescriptor)descriptor2;
            return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)accessor.getCorrespondingProperty(), PredefinedAnnotation.NATIVE);
        }
        return false;
    }

    public static boolean isNativeInterface(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(13);
        }
        return AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isInterface(descriptor2);
    }

    private static boolean isEffectivelyExternalMember(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(14);
        }
        return descriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(15);
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.LIBRARY);
    }

    @Nullable
    public static String getJsName(@NotNull DeclarationDescriptor descriptor2) {
        AnnotationDescriptor annotation2;
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(16);
        }
        if ((annotation2 = AnnotationsUtils.getJsNameAnnotation(descriptor2)) == null || annotation2.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> value2 = annotation2.getAllValueArguments().values().iterator().next();
        if (value2 == null) {
            return null;
        }
        Object result2 = value2.getValue();
        if (!(result2 instanceof String)) {
            return null;
        }
        return (String)result2;
    }

    @Nullable
    public static AnnotationDescriptor getJsNameAnnotation(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(17);
        }
        return descriptor2.getAnnotations().findAnnotation(new FqName("kotlin.js.JsName"));
    }

    @Nullable
    public static AnnotationDescriptor getJsExportAnnotation(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(18);
        }
        return descriptor2.getAnnotations().findAnnotation(JS_EXPORT);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(19);
        }
        if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
            return true;
        }
        if (AnnotationsUtils.isEffectivelyExternalMember(descriptor2)) {
            return true;
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(20);
        }
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(21);
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(22);
        }
        if (fqName2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(23);
        }
        if (descriptor2.getAnnotations().hasAnnotation(fqName2)) {
            return true;
        }
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(descriptor2);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqName2);
    }

    public static boolean hasJsNameInAccessors(@NotNull PropertyDescriptor property2) {
        if (property2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(24);
        }
        for (PropertyAccessorDescriptor accessor : property2.getAccessors()) {
            if (AnnotationsUtils.getJsName(accessor) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getModuleName(@NotNull DeclarationDescriptor declaration2) {
        AnnotationDescriptor annotation2;
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(25);
        }
        return (annotation2 = declaration2.getAnnotations().findAnnotation(JS_MODULE_ANNOTATION)) != null ? AnnotationsUtils.extractSingleStringArgument(annotation2) : null;
    }

    @Nullable
    public static String getFileModuleName(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration2) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(26);
        }
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(27);
        }
        return AnnotationsUtils.getSingleStringAnnotationArgument(bindingContext, declaration2, JS_MODULE_ANNOTATION);
    }

    @Nullable
    public static String getFileQualifier(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration2) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(28);
        }
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(29);
        }
        return AnnotationsUtils.getSingleStringAnnotationArgument(bindingContext, declaration2, JS_QUALIFIER_ANNOTATION);
    }

    @Nullable
    private static String getSingleStringAnnotationArgument(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration2, @NotNull FqName annotationFqName) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(30);
        }
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(31);
        }
        if (annotationFqName == null) {
            AnnotationsUtils.$$$reportNull$$$0(32);
        }
        for (AnnotationDescriptor annotation2 : AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration2)) {
            if (!annotationFqName.equals(annotation2.getFqName())) continue;
            return AnnotationsUtils.extractSingleStringArgument(annotation2);
        }
        return null;
    }

    public static boolean isNonModule(@NotNull DeclarationDescriptor declaration2) {
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(33);
        }
        return declaration2.getAnnotations().findAnnotation(JS_NON_MODULE_ANNOTATION) != null;
    }

    public static boolean isFromNonModuleFile(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor declaration2) {
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(34);
        }
        if (declaration2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(35);
        }
        return CollectionsKt.any(AnnotationsUtils.getContainingFileAnnotations(bindingContext, declaration2), annotation2 -> JS_NON_MODULE_ANNOTATION.equals(annotation2.getFqName()));
    }

    @Nullable
    private static String extractSingleStringArgument(@NotNull AnnotationDescriptor annotation2) {
        if (annotation2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(36);
        }
        if (annotation2.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> importValue = annotation2.getAllValueArguments().values().iterator().next();
        if (importValue == null) {
            return null;
        }
        if (!(importValue.getValue() instanceof String)) {
            return null;
        }
        return (String)importValue.getValue();
    }

    @NotNull
    public static List<AnnotationDescriptor> getContainingFileAnnotations(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        PackageFragmentDescriptor containingPackage;
        if (bindingContext == null) {
            AnnotationsUtils.$$$reportNull$$$0(37);
        }
        if (descriptor2 == null) {
            AnnotationsUtils.$$$reportNull$$$0(38);
        }
        if ((containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false)) instanceof KotlinJavascriptPackageFragment) {
            List<AnnotationDescriptor> list2 = ((KotlinJavascriptPackageFragment)containingPackage).getContainingFileAnnotations(descriptor2);
            if (list2 == null) {
                AnnotationsUtils.$$$reportNull$$$0(39);
            }
            return list2;
        }
        KtFile kotlinFile = AnnotationsUtils.getFile(descriptor2);
        if (kotlinFile != null) {
            ArrayList<AnnotationDescriptor> annotations2 = new ArrayList<AnnotationDescriptor>();
            for (KtAnnotationEntry psiAnnotation : kotlinFile.getAnnotationEntries()) {
                AnnotationDescriptor annotation2 = bindingContext.get(BindingContext.ANNOTATION, psiAnnotation);
                if (annotation2 == null) continue;
                annotations2.add(annotation2);
            }
            ArrayList<AnnotationDescriptor> arrayList = annotations2;
            if (arrayList == null) {
                AnnotationsUtils.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        List<AnnotationDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            AnnotationsUtils.$$$reportNull$$$0(41);
        }
        return list3;
    }

    @Nullable
    private static KtFile getFile(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        SourceFile file2 = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile();
        if (!(file2 instanceof PsiSourceFile)) {
            return null;
        }
        PsiFile psiFile = ((PsiSourceFile)file2).getPsiFile();
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        return (KtFile)psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 7: 
            case 11: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqName";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFileAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationStringParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameForAnnotatedObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExportedObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNativeObject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNativeInterface";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyExternalMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryObject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getJsName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJsNameAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJsExportAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedObject";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationOrInsideAnnotatedClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasJsNameInAccessors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileModuleName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFileQualifier";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStringAnnotationArgument";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNonModule";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isFromNonModuleFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractSingleStringArgument";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFileAnnotations";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

