/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.components;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(0);
        }
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            ServiceManager.$$$reportNull$$$0(1);
        }
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(2);
        }
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        PicoContainer picoContainer;
        Object instance;
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(3);
        }
        if ((instance = (picoContainer = componentManager.getPicoContainer()).getComponentInstance(serviceClass.getName())) == null) {
            ProgressManager.checkCanceled();
            instance = componentManager.getComponent(serviceClass);
            if (instance != null) {
                Application app = ApplicationManager.getApplication();
                String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
                if (app.isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
            }
        }
        return (T)instance;
    }

    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ServiceManager.$$$reportNull$$$0(4);
        }
        NotNullLazyKey<Object, Project> notNullLazyKey = NotNullLazyKey.create("Service: " + serviceClass.getName(), project -> {
            if (serviceClass == null) {
                ServiceManager.$$$reportNull$$$0(6);
            }
            return ServiceManager.getService(project, serviceClass);
        });
        if (notNullLazyKey == null) {
            ServiceManager.$$$reportNull$$$0(5);
        }
        return notNullLazyKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/components/ServiceManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLazyKey";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLazyKey$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

