/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileSystemUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandlerBase;
import org.jetbrains.kotlin.com.intellij.util.io.FileAccessorCache;
import org.jetbrains.kotlin.com.intellij.util.io.ResourceHandle;

public class ZipHandler
extends ZipHandlerBase {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        protected ZipFile createAccessor(ZipHandler handler2) throws IOException {
            String canonicalPathToZip = handler2.getCanonicalPathToZip();
            ZipHandler.setFileAttributes(handler2, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        @Override
        protected void disposeAccessor(ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path2) {
        if (path2 == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path2);
    }

    protected static synchronized void setFileAttributes(ZipHandler zipHandler, String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes(pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    protected static synchronized boolean isSameFileAttributes(ZipHandler zipHandler, FileAttributes attributes) {
        return attributes.lastModified == zipHandler.myFileStamp && attributes.length == zipHandler.myFileLength;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        String string = value;
        if (string == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle<ZipFile> handle;
            FileAccessorCache.Handle<ZipFile> handle2 = handle = createIfNeeded ? ourZipFileFileAccessorCache.get(this) : ourZipFileFileAccessorCache.getIfCached(this);
            if (handle != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes(this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (ZipHandler.isSameFileAttributes(this, attributes)) {
                    return handle;
                }
                this.clearCaches();
                handle.release();
                handle = ourZipFileFileAccessorCache.get(this);
            }
            return handle;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Override
    protected void clearCaches() {
        ourZipFileFileAccessorCache.remove(this);
        super.clearCaches();
    }

    @NotNull
    protected File getFileToUse() {
        File file2 = this.getFile();
        if (file2 == null) {
            ZipHandler.$$$reportNull$$$0(2);
        }
        return file2;
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle<ZipFile> handle = this.getCachedZipFileHandle(true);
        if (handle == null) {
            ZipHandler.$$$reportNull$$$0(3);
        }
        return handle;
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPathToZip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

