/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.PluginClasspath;
import org.jetbrains.kotlin.build.PluginClasspathComparator;
import org.jetbrains.kotlin.build.SerializationUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.incremental.storage.RelativeFileToPathConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u001a\u001a\u00020\u0007J0\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001f\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "", "converter", "Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;)V", "argumentsListForSpecialCheck", "", "", "getArgumentsListForSpecialCheck", "()Ljava/util/List;", "getConverter", "()Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "excludedProperties", "getExcludedProperties", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "compareIsChanged", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "deserializeMapFromString", "inputString", "obtainReasonForRebuild", "currentCompilerArgumentsMap", "previousCompilerArgsMap", "serializeArgsToString", "serializeMapToString", "myList", "CustomKeys", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetaInfo.kt\norg/jetbrains/kotlin/build/BuildMetaInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n135#2,9:135\n215#2:144\n216#2:146\n144#2:147\n125#2:158\n152#2,3:159\n1#3:145\n1#3:148\n766#4:149\n857#4,2:150\n1179#4,2:152\n1253#4,4:154\n*S KotlinDebug\n*F\n+ 1 BuildMetaInfo.kt\norg/jetbrains/kotlin/build/BuildMetaInfo\n*L\n22#1:135,9\n22#1:144\n22#1:146\n22#1:147\n92#1:158\n92#1:159,3\n22#1:145\n89#1:149\n89#1:150,2\n90#1:152,2\n90#1:154,4\n*E\n"})
public abstract class BuildMetaInfo {
    @Nullable
    private final RelativeFileToPathConverter converter;
    @NotNull
    private final List<String> excludedProperties;
    @NotNull
    private final List<String> argumentsListForSpecialCheck;

    public BuildMetaInfo(@Nullable RelativeFileToPathConverter converter) {
        this.converter = converter;
        Object[] objectArray = new String[]{"languageVersion", "apiVersion", "pluginClasspaths", "metadataVersion", "dumpDirectory", "dumpOnlyFqName", "dumpPerf", "errors", "extraHelp", "freeArgs", "help", "intellijPluginRoot", "kotlinHome", "listPhases", "phasesToDump", "phasesToDumpAfter", "phasesToDumpBefore", "profilePhases", "renderInternalDiagnosticNames", "reportOutputFiles", "reportPerf", "script", "verbose", "verbosePhases", "version"};
        this.excludedProperties = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"allowAnyScriptsInSourceRoots", "allowKotlinPackage", "allowResultReturnType", "noCheckActual", "skipMetadataVersionCheck", "skipPrereleaseCheck", "suppressVersionWarnings", "suppressWarnings", "IS_EAP"};
        this.argumentsListForSpecialCheck = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final RelativeFileToPathConverter getConverter() {
        return this.converter;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String obtainReasonForRebuild(@NotNull Map<String, String> currentCompilerArgumentsMap, @NotNull Map<String, String> previousCompilerArgsMap) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(currentCompilerArgumentsMap, (String)"currentCompilerArgumentsMap");
        Intrinsics.checkNotNullParameter(previousCompilerArgsMap, (String)"previousCompilerArgsMap");
        if (!Intrinsics.areEqual(currentCompilerArgumentsMap.keySet(), previousCompilerArgsMap.keySet())) {
            return "Compiler arguments version was changed";
        }
        Map<String, String> $this$mapNotNull$iv = currentCompilerArgumentsMap;
        boolean $i$f$mapNotNull = false;
        Map<String, String> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            String previousValue;
            String currentValue;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            String key = (String)it.getKey();
            if ((previousCompilerArgsMap.get(it.getKey()) == null ? key : (this.compareIsChanged(key, currentValue = (String)it.getValue(), previousValue) ? key : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changedCompilerArguments = (List)destination$iv$iv;
        if (!((Collection)changedCompilerArguments).isEmpty()) {
            String rebuildReason = (changedCompilerArguments.size() == 1 ? "One of compiler arguments was changed: " : "Some compiler arguments were changed: ") + SerializationUtilsKt.joinToReadableString(changedCompilerArguments);
            return rebuildReason;
        }
        return null;
    }

    private final boolean compareIsChanged(String key, String currentValue, String previousValue) {
        Object object = this.checkIfPlatformSpecificCompilerArgumentWasChanged(key, currentValue, previousValue);
        if (object != null) {
            boolean comparisonResult = (Boolean)object;
            boolean bl = false;
            return comparisonResult;
        }
        switch (key) {
            case "LANGUAGE_VERSION_STRING": {
                return LanguageVersion.Companion.fromVersionString(currentValue) != LanguageVersion.Companion.fromVersionString(previousValue);
            }
            case "API_VERSION_STRING": {
                return !Intrinsics.areEqual((Object)ApiVersion.Companion.parse(currentValue), (Object)ApiVersion.Companion.parse(previousValue));
            }
            case "PLUGIN_CLASSPATHS": {
                return !new PluginClasspathComparator(previousValue, currentValue).equals();
            }
        }
        if (this.getArgumentsListForSpecialCheck().contains(key)) {
            return Intrinsics.areEqual((Object)previousValue, (Object)"true") && !Intrinsics.areEqual((Object)currentValue, (Object)"true");
        }
        return !Intrinsics.areEqual((Object)previousValue, (Object)currentValue);
    }

    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter((Object)previousValue, (String)"previousValue");
        return null;
    }

    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args) {
        String string;
        Map resultMap;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                resultMap = MapsKt.toMutableMap(SerializationUtilsKt.transformClassToPropertiesMap(args, this.getExcludedProperties()));
                string = args.getLanguageVersion();
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(it);
                string = languageVersion;
                if (languageVersion != null) break block5;
            }
            string = LanguageVersion.LATEST_STABLE;
        }
        String languageVersion = string;
        String languageVersionSting = languageVersion.getVersionString();
        resultMap.put("LANGUAGE_VERSION_STRING", languageVersionSting);
        boolean isEAP = !languageVersion.isStable();
        resultMap.put("IS_EAP", String.valueOf(isEAP));
        String string2 = args.getApiVersion();
        if (string2 == null) {
            string2 = languageVersionSting;
        }
        String apiVersionString = string2;
        resultMap.put("API_VERSION_STRING", apiVersionString);
        String pluginClasspath = new PluginClasspath(args.getPluginClasspaths(), this.converter).serialize();
        resultMap.put("PLUGIN_CLASSPATHS", pluginClasspath);
        return resultMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> deserializeMapFromString(@NotNull String inputString) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)inputString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)p0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (String)"=", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (String)"=", null, (int)2, null));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final String serializeMapToString(Map<String, String> myList) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = myList;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey() + '=' + (String)it.getValue());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String serializeArgsToString(@NotNull CommonCompilerArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.serializeMapToString(this.createPropertiesMapFromCompilerArguments(args));
    }

    @NotNull
    public List<String> getExcludedProperties() {
        return this.excludedProperties;
    }

    @NotNull
    public List<String> getArgumentsListForSpecialCheck() {
        return this.argumentsListForSpecialCheck;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/build/BuildMetaInfo$CustomKeys;", "", "(Ljava/lang/String;I)V", "LANGUAGE_VERSION_STRING", "IS_EAP", "METADATA_VERSION_STRING", "PLUGIN_CLASSPATHS", "API_VERSION_STRING", "kotlin-build-common"})
    public static final class CustomKeys
    extends Enum<CustomKeys> {
        public static final /* enum */ CustomKeys LANGUAGE_VERSION_STRING = new CustomKeys();
        public static final /* enum */ CustomKeys IS_EAP = new CustomKeys();
        public static final /* enum */ CustomKeys METADATA_VERSION_STRING = new CustomKeys();
        public static final /* enum */ CustomKeys PLUGIN_CLASSPATHS = new CustomKeys();
        public static final /* enum */ CustomKeys API_VERSION_STRING = new CustomKeys();
        private static final /* synthetic */ CustomKeys[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CustomKeys[] values() {
            return (CustomKeys[])$VALUES.clone();
        }

        public static CustomKeys valueOf(String value) {
            return Enum.valueOf(CustomKeys.class, value);
        }

        @NotNull
        public static EnumEntries<CustomKeys> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = customKeysArray = new CustomKeys[]{CustomKeys.LANGUAGE_VERSION_STRING, CustomKeys.IS_EAP, CustomKeys.METADATA_VERSION_STRING, CustomKeys.PLUGIN_CLASSPATHS, CustomKeys.API_VERSION_STRING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

