/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClassWithSource;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\nH\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/JavaClassesTrackerImpl;", "Lorg/jetbrains/kotlin/load/java/JavaClassesTracker;", "cache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "untrackedJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/util/Set;)V", "classDescriptors", "", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "classToSourceSerialized", "", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClassWithSource;", "javaClassesUpdates", "", "getJavaClassesUpdates", "()Ljava/util/Collection;", "onCompletedAnalysis", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "reportClass", "classDescriptor", "wasContentRequested", "", "kotlin-build-common"})
public final class JavaClassesTrackerImpl
implements JavaClassesTracker {
    private final Map<ClassId, SerializedJavaClassWithSource> classToSourceSerialized;
    private final List<JavaClassDescriptor> classDescriptors;
    private final IncrementalJvmCache cache;
    private final Set<ClassId> untrackedJavaClasses;

    @NotNull
    public final Collection<SerializedJavaClassWithSource> getJavaClassesUpdates() {
        return this.classToSourceSerialized.values();
    }

    public void reportClass(@NotNull JavaClassDescriptor classDescriptor) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        ClassId classId2 = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)classDescriptor));
        if (classId2 == null) {
            Intrinsics.throwNpe();
        }
        if (!this.cache.isJavaClassToTrack(classId = classId2) || JavaClassesTrackerImplKt.access$getJavaSourceFile$p(classDescriptor) == null) {
            return;
        }
        this.classDescriptors.add(classDescriptor);
    }

    public void onCompletedAnalysis(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        for (ClassId classId : CollectionsKt.plus(this.cache.getObsoleteJavaClasses(), (Iterable)this.untrackedJavaClasses)) {
            FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)classId);
        }
        for (JavaClassDescriptor classDescriptor : CollectionsKt.toList((Iterable)this.classDescriptors)) {
            ClassId classId;
            if (DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)classDescriptor)) == null) {
                Intrinsics.throwNpe();
            }
            if (!this.cache.isJavaClassAlreadyInCache(classId) && !this.untrackedJavaClasses.contains(classId) && !this.wasContentRequested(classDescriptor)) continue;
            Map<ClassId, SerializedJavaClassWithSource> map = this.classToSourceSerialized;
            boolean bl = false;
            Map<ClassId, SerializedJavaClassWithSource> map2 = map;
            boolean bl2 = false;
            boolean bl3 = !map2.containsKey(classId);
            bl = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string = "Duplicated JavaClassDescriptor " + classId + " reported to IC";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.classToSourceSerialized.put(classId, (SerializedJavaClassWithSource)JavaClassesTrackerImplKt.getCONVERTING_JAVA_CLASSES_TO_PROTO().time((Function0)new Function0<SerializedJavaClassWithSource>(classDescriptor){
                final /* synthetic */ JavaClassDescriptor $classDescriptor;

                @NotNull
                public final SerializedJavaClassWithSource invoke() {
                    return JavaClassesTrackerImplKt.convertToProto(this.$classDescriptor);
                }
                {
                    this.$classDescriptor = javaClassDescriptor;
                    super(0);
                }
            }));
        }
    }

    private final boolean wasContentRequested(@NotNull JavaClassDescriptor $this$wasContentRequested) {
        JavaClassDescriptor $this$safeAs$iv = $this$wasContentRequested;
        boolean $i$f$safeAs = false;
        JavaClassDescriptor javaClassDescriptor = $this$safeAs$iv;
        if (!(javaClassDescriptor instanceof LazyJavaClassDescriptor)) {
            javaClassDescriptor = null;
        }
        LazyJavaClassDescriptor lazyJavaClassDescriptor = (LazyJavaClassDescriptor)javaClassDescriptor;
        return lazyJavaClassDescriptor == null || lazyJavaClassDescriptor.wasScopeContentRequested();
    }

    public JavaClassesTrackerImpl(@NotNull IncrementalJvmCache cache, @NotNull Set<ClassId> untrackedJavaClasses) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        Intrinsics.checkParameterIsNotNull(untrackedJavaClasses, (String)"untrackedJavaClasses");
        this.cache = cache;
        this.untrackedJavaClasses = untrackedJavaClasses;
        JavaClassesTrackerImpl javaClassesTrackerImpl = this;
        boolean bl = false;
        Object object = new HashMap();
        javaClassesTrackerImpl.classToSourceSerialized = (Map)object;
        javaClassesTrackerImpl = this;
        bl = false;
        javaClassesTrackerImpl.classDescriptors = object = (List)new ArrayList();
    }
}

