/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.synthetic.diagnostic;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.synthetic.descriptors.AndroidSyntheticPackageFragmentDescriptor;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.android.synthetic.res.AndroidSyntheticProperty;
import org.jetbrains.kotlin.android.synthetic.res.SyntheticDescriptorGenerationKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u0004*\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/android/synthetic/diagnostic/AndroidExtensionPropertiesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findLeftOutermostQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtElement;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkDeprecated", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "expression", "packageDescriptor", "Lorg/jetbrains/kotlin/android/synthetic/descriptors/AndroidSyntheticPackageFragmentDescriptor;", "checkPartiallyDefinedResource", "property", "Lorg/jetbrains/kotlin/android/synthetic/res/AndroidSyntheticProperty;", "checkUnresolvedWidgetType", "android-extensions-compiler"})
public final class AndroidExtensionPropertiesCallChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        PropertyDescriptor propertyDescriptor;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtExpression ktExpression2 = ktExpression = reportOn instanceof KtExpression ? (KtExpression)reportOn : null;
        if (ktExpression == null) {
            return;
        }
        Object object = resolvedCall.getResultingDescriptor();
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
        Object object2 = propertyDescriptor3.getContainingDeclaration();
        AndroidSyntheticPackageFragmentDescriptor androidSyntheticPackageFragmentDescriptor = object = object2 instanceof AndroidSyntheticPackageFragmentDescriptor ? (AndroidSyntheticPackageFragmentDescriptor)((Object)object2) : null;
        if (object == null) {
            return;
        }
        Object containingPackage = object;
        AndroidSyntheticProperty androidSyntheticProperty = object2 = propertyDescriptor3 instanceof AndroidSyntheticProperty ? (AndroidSyntheticProperty)propertyDescriptor3 : null;
        if (object2 == null) {
            return;
        }
        Object androidSyntheticProperty2 = object2;
        Object $this$check_u24lambda_u2d0 = object2 = context2.getTrace();
        boolean bl = false;
        this.checkUnresolvedWidgetType((DiagnosticSink)$this$check_u24lambda_u2d0, (KtExpression)reportOn, (AndroidSyntheticProperty)androidSyntheticProperty2);
        this.checkDeprecated((DiagnosticSink)$this$check_u24lambda_u2d0, (KtExpression)reportOn, (AndroidSyntheticPackageFragmentDescriptor)((Object)containingPackage));
        this.checkPartiallyDefinedResource((DiagnosticSink)$this$check_u24lambda_u2d0, resolvedCall, (AndroidSyntheticProperty)androidSyntheticProperty2, context2);
    }

    private final void checkDeprecated(DiagnosticSink $this$checkDeprecated, KtExpression expression, AndroidSyntheticPackageFragmentDescriptor packageDescriptor) {
        if (packageDescriptor.getPackageData().isDeprecated()) {
            $this$checkDeprecated.report((Diagnostic)ErrorsAndroid.SYNTHETIC_DEPRECATED_PACKAGE.on((PsiElement)expression));
        }
    }

    private final void checkUnresolvedWidgetType(DiagnosticSink $this$checkUnresolvedWidgetType, KtExpression expression, AndroidSyntheticProperty property2) {
        if (!SyntheticDescriptorGenerationKt.isErrorType(property2)) {
            return;
        }
        String string = property2.getErrorType();
        if (string == null) {
            return;
        }
        String type = string;
        DiagnosticFactory1<KtExpression, String> warning = StringsKt.contains$default((CharSequence)type, (char)'.', (boolean)false, (int)2, null) ? ErrorsAndroid.SYNTHETIC_UNRESOLVED_WIDGET_TYPE : ErrorsAndroid.SYNTHETIC_INVALID_WIDGET_TYPE;
        $this$checkUnresolvedWidgetType.report((Diagnostic)warning.on((PsiElement)expression, (Object)type));
    }

    private final void checkPartiallyDefinedResource(DiagnosticSink $this$checkPartiallyDefinedResource, ResolvedCall<?> resolvedCall, AndroidSyntheticProperty property2, CallCheckerContext context2) {
        KtExpression ktExpression;
        if (!property2.getResource().getPartiallyDefined()) {
            return;
        }
        KtExpression ktExpression2 = resolvedCall.getCall().getCalleeExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression calleeExpression = ktExpression = ktExpression2;
        ktExpression2 = context2.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"context.resolutionContext.expectedType");
        KtExpression expectedType = ktExpression2;
        if (!(TypeUtils.noExpectedType((KotlinType)expectedType) || expectedType.isMarkedNullable() || FlexibleTypesKt.isFlexible((KotlinType)expectedType))) {
            $this$checkPartiallyDefinedResource.report((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression));
            return;
        }
        KtElement ktElement = this.findLeftOutermostQualifiedExpression(calleeExpression);
        if (ktElement == null) {
            return;
        }
        KtElement outermostQualifiedExpression = ktElement;
        PsiElement usage = outermostQualifiedExpression.getParent();
        if (usage instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)usage).getReceiverExpression(), (Object)outermostQualifiedExpression)) {
            $this$checkPartiallyDefinedResource.report((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression));
        }
    }

    private final KtElement findLeftOutermostQualifiedExpression(KtExpression calleeExpression) {
        PsiElement psiElement;
        KtExpression ktExpression = calleeExpression;
        PsiElement psiElement2 = psiElement = ktExpression == null ? null : ktExpression.getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement;
        if (parent instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getSelectorExpression(), (Object)calleeExpression)) {
            return this.findLeftOutermostQualifiedExpression((KtExpression)parent);
        }
        return (KtElement)calleeExpression;
    }
}

