/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.ProtoBuf;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.deserialization.VersionSpecificBehaviorKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.BinaryModuleData;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.protobuf.ProtocolStringList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "", "version", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/JvmMetadataVersion;", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/PackageParts;", "moduleData", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/BinaryModuleData;", "debugName", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;Ljava/util/Map;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;Ljava/lang/String;)V", "getModuleData", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "getPackageFqName2Parts", "()Ljava/util/Map;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "findPackageParts", "packageFqName", "toString", "Companion", "metadata.jvm"})
public final class ModuleMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmMetadataVersion version;
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    @NotNull
    private final String debugName;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "EMPTY");
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "CORRUPTED");
    public static final int STRICT_METADATA_VERSION_SEMANTICS_FLAG = 1;

    private ModuleMapping(JvmMetadataVersion version, Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData, String debugName) {
        this.version = version;
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData;
        this.debugName = debugName;
    }

    @NotNull
    public final JvmMetadataVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    public /* synthetic */ ModuleMapping(JvmMetadataVersion version, Map packageFqName2Parts, BinaryModuleData moduleData, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(version, packageFqName2Parts, moduleData, debugName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J<\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J6\u0010\u0017\u001a\u0004\u0018\u00010\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "STRICT_METADATA_VERSION_SEMANTICS_FLAG", "", "emptyBinaryData", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/BinaryModuleData;", "loadModuleMapping", "bytes", "", "debugName", "skipMetadataVersionCheck", "", "isJvmPackageNameSupported", "reportIncompatibleVersionError", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/jvm/deserialization/JvmMetadataVersion;", "", "loadMultiFileFacadeInternalName", "multifileFacadeIds", "", "multifileFacadeShortNames", "index", "packageFqName", "readVersionNumber", "", "stream", "Ljava/io/DataInputStream;", "metadata.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final int[] readVersionNumber(@NotNull DataInputStream stream) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            try {
                int n = 0;
                int n2 = stream.readInt();
                int[] nArray2 = new int[n2];
                while (n < n2) {
                    int n3 = n++;
                    nArray2[n3] = stream.readInt();
                }
                nArray = nArray2;
            }
            catch (IOException e) {
                nArray = null;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull Function1<? super JvmMetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            Object packageParts;
            Object jvmPackageName;
            Object packageParts2;
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter(reportIncompatibleVersionError, (String)"reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int[] nArray = this.readVersionNumber(stream);
            if (nArray == null) {
                return CORRUPTED;
            }
            int[] versionNumber = nArray;
            JvmMetadataVersion preVersion = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !preVersion.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            JvmMetadataVersion version = new JvmMetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck && !version.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)version);
                return EMPTY;
            }
            ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
            Object p0 = extensionRegistryLite;
            boolean bl = false;
            BuiltInsProtoBuf.registerAllExtensions((ExtensionRegistryLite)p0);
            ExtensionRegistryLite extensions = extensionRegistryLite;
            p0 = JvmModuleProtoBuf.Module.parseFrom(stream, extensions);
            if (p0 == null) {
                return EMPTY;
            }
            Object moduleProto = p0;
            LinkedHashMap result = new LinkedHashMap();
            for (JvmModuleProtoBuf.PackageParts packageParts3 : ((JvmModuleProtoBuf.Module)moduleProto).getPackagePartsList()) {
                String partShortName;
                int index;
                Object object;
                Iterator $this$getOrPut$iv2;
                String packageFqName = packageParts3.getPackageFqName();
                Map map = result;
                Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
                String key$iv232 = packageFqName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv2.get(key$iv232);
                if (value$iv == null) {
                    boolean bl2 = false;
                    PackageParts answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv2.put(key$iv232, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts2 = (PackageParts)object;
                $this$getOrPut$iv2 = packageParts3.getShortClassNameList().iterator();
                int key$iv232 = 0;
                while ($this$getOrPut$iv2.hasNext()) {
                    index = key$iv232++;
                    partShortName = (String)$this$getOrPut$iv2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)partShortName, (String)"partShortName");
                    String string = ModuleMappingKt.access$internalNameOf(packageFqName, partShortName);
                    ProtocolStringList answer$iv = packageParts3.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(answer$iv, (String)"proto.multifileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList = answer$iv;
                    answer$iv = packageParts3.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts2).addPart(string, this.loadMultiFileFacadeInternalName(protocolStringList, answer$iv, index, packageFqName));
                }
                if (!isJvmPackageNameSupported) continue;
                $this$getOrPut$iv2 = packageParts3.getClassWithJvmPackageNameShortNameList().iterator();
                key$iv232 = 0;
                while ($this$getOrPut$iv2.hasNext()) {
                    int n;
                    ProtocolStringList protocolStringList;
                    index = key$iv232++;
                    partShortName = (String)$this$getOrPut$iv2.next();
                    ProtocolStringList protocolStringList2 = packageParts3.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList2, (String)"proto.classWithJvmPackageNamePackageIdList");
                    Integer n2 = (Integer)CollectionsKt.getOrNull(protocolStringList2, (int)index);
                    if (n2 == null) {
                        protocolStringList = packageParts3.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkNotNullExpressionValue(protocolStringList, (String)"proto.classWithJvmPackageNamePackageIdList");
                        protocolStringList2 = (Integer)CollectionsKt.lastOrNull((List)protocolStringList);
                        if (protocolStringList2 == null) continue;
                        n = (Integer)((Object)protocolStringList2);
                    } else {
                        n = n2;
                    }
                    int packageId = n;
                    protocolStringList = ((JvmModuleProtoBuf.Module)moduleProto).getJvmPackageNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"moduleProto.jvmPackageNameList");
                    protocolStringList2 = (String)CollectionsKt.getOrNull((List)protocolStringList, (int)packageId);
                    if (protocolStringList2 == null) continue;
                    jvmPackageName = protocolStringList2;
                    Intrinsics.checkNotNullExpressionValue((Object)partShortName, (String)"partShortName");
                    String string = ModuleMappingKt.access$internalNameOf((String)jvmPackageName, partShortName);
                    protocolStringList2 = packageParts3.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList2, (String)"proto.classWithJvmPackag\u2026fileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList3 = protocolStringList2;
                    protocolStringList2 = packageParts3.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts2).addPart(string, this.loadMultiFileFacadeInternalName(protocolStringList3, protocolStringList2, index, (String)jvmPackageName));
                }
            }
            for (JvmModuleProtoBuf.PackageParts packageParts4 : ((JvmModuleProtoBuf.Module)moduleProto).getMetadataPartsList()) {
                Object object;
                ProtocolStringList $this$getOrPut$iv;
                packageParts2 = result;
                String $this$getOrPut$iv2 = packageParts4.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv2, (String)"proto.packageFqName");
                String key$iv = $this$getOrPut$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String packageId = packageParts4.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)packageId, (String)"proto.packageFqName");
                    PackageParts answer$iv = new PackageParts(packageId);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts = (PackageParts)object;
                $this$getOrPut$iv = packageParts4.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"proto.shortClassNameList");
                Iterable $this$forEach$iv = $this$getOrPut$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p02 = (String)element$iv;
                    boolean bl4 = false;
                    ((PackageParts)packageParts).addMetadataPart(p02);
                }
            }
            ProtoBuf.StringTable stringTable = ((JvmModuleProtoBuf.Module)moduleProto).getStringTable();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"moduleProto.stringTable");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = ((JvmModuleProtoBuf.Module)moduleProto).getQualifiedNameTable();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"moduleProto.qualifiedNameTable");
            NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            packageParts = ((JvmModuleProtoBuf.Module)moduleProto).getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(packageParts, (String)"moduleProto.annotationList");
            Iterable $this$map$iv = (Iterable)packageParts;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto3;
                jvmPackageName = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                String string = nameResolver.getQualifiedClassName(proto3.getId());
                collection.add(string);
            }
            List list = (List)destination$iv$iv;
            Map map = result;
            List<ProtoBuf.Class> list2 = ((JvmModuleProtoBuf.Module)moduleProto).getOptionalAnnotationClassList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"moduleProto.optionalAnnotationClassList");
            return new ModuleMapping(version, map, new BinaryModuleData(list, list2, nameResolver), debugName, null);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index, String packageFqName) {
            String string;
            Integer n;
            String string2;
            Integer n2 = (Integer)CollectionsKt.getOrNull(multifileFacadeIds, (int)index);
            Integer multifileFacadeId = n2 == null ? null : Integer.valueOf(n2 - 1);
            Integer n3 = multifileFacadeId;
            if (n3 == null) {
                string2 = null;
            } else {
                n = n3;
                int p0 = ((Number)n).intValue();
                boolean bl = false;
                string2 = (String)CollectionsKt.getOrNull(multifileFacadeShortNames, (int)p0);
            }
            String facadeShortName = string2;
            n3 = facadeShortName;
            if (n3 == null) {
                string = null;
            } else {
                Integer it = n = n3;
                boolean bl = false;
                string = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
            }
            return string;
        }

        private final BinaryModuleData emptyBinaryData() {
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            GeneratedMessageLite generatedMessageLite = ProtoBuf.StringTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"getDefaultInstance()");
            ProtoBuf.StringTable stringTable = generatedMessageLite;
            generatedMessageLite = ProtoBuf.QualifiedNameTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"getDefaultInstance()");
            return new BinaryModuleData(list, list2, new NameResolverImpl(stringTable, (ProtoBuf.QualifiedNameTable)generatedMessageLite));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ BinaryModuleData access$emptyBinaryData(Companion $this) {
            return $this.emptyBinaryData();
        }
    }
}

