/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.Date;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlinx/datetime/LocalDate;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalDate", "instant", "", "nonNullValueAsDefaultString", "", "value", "nonNullValueToString", "notNullValueToDB", "", "kotlin.jvm.PlatformType", "sqlType", "valueFromDB", "Companion", "exposed-kotlin-datetime"})
public final class KotlinLocalDateColumnType
extends ColumnType<LocalDate>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalDateColumnType INSTANCE = new KotlinLocalDateColumnType();

    public KotlinLocalDateColumnType() {
        super(false, 1, null);
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = Instant.Companion.fromEpochMilliseconds(TimeZoneKt.atStartOfDayIn((LocalDate)value, (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).toEpochMilliseconds());
        if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            return KotlinDateColumnTypeKt.access$oracleDateLiteral(instant);
        }
        return '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + '\'';
    }

    @NotNull
    public LocalDate valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        return object instanceof LocalDate ? (LocalDate)value : (object instanceof Date ? this.longToLocalDate(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value).longValue()) : (object instanceof String ? LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)((CharSequence)value), null, (int)2, null) : LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)value.toString(), null, (int)2, null))))));
    }

    public Object notNullValueToDB(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? KotlinDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaLocalDate((LocalDate)value)) : new Date(KotlinDateColumnTypeKt.access$getMillis(value));
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::date" : super.nonNullValueAsDefaultString((Object)value);
    }

    private final LocalDate longToLocalDate(long instant) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(instant), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).getDate();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalDateColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

