/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlinx/datetime/Instant;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueAsDefaultString", "", "value", "nonNullValueToString", "notNullValueToDB", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-kotlin-datetime"})
public final class KotlinInstantColumnType
extends ColumnType<kotlinx.datetime.Instant>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinInstantColumnType INSTANCE = new KotlinInstantColumnType();

    public KotlinInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull kotlinx.datetime.Instant value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value);
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? KotlinDateColumnTypeKt.access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() : KotlinDateColumnTypeKt.access$getMYSQL_DATE_TIME_STRING_FORMATTER();
            string = '\'' + formatter.format(instant) + '\'';
        } else {
            string = dialect instanceof SQLiteDialect ? '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant) + '\'' : (dialect instanceof OracleDialect ? KotlinDateColumnTypeKt.access$oracleDateTimeLiteral(value) : '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(instant) + '\'');
        }
        return string;
    }

    @NotNull
    public kotlinx.datetime.Instant valueFromDB(@NotNull Object value) {
        kotlinx.datetime.Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
            instant = ConvertersKt.toKotlinInstant((Instant)instant2);
        } else {
            instant = object instanceof String ? Instant.Companion.parse$default((Instant.Companion)kotlinx.datetime.Instant.Companion, (CharSequence)((CharSequence)value), null, (int)2, null) : this.valueFromDB(value.toString());
        }
        return instant;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getTimestamp(index);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull kotlinx.datetime.Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Timestamp timestamp = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value)) : Timestamp.from(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
        Intrinsics.checkNotNull((Object)timestamp);
        return timestamp;
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull kotlinx.datetime.Instant value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string3, (char[])cArray)).append("'::timestamp without time zone").toString();
        } else if (H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string4 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string5 = StringsKt.trimEnd((String)string4, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string5, (char[])cArray)).append('\'').toString();
        } else {
            string = super.nonNullValueAsDefaultString((Object)value);
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinInstantColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

