/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDurationColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinInstantColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalDateTimeColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalTimeColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinOffsetDateTimeColumnType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u0016H\u0002\u001a\u0010\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020>H\u0002\u001a\u0010\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020AH\u0002\u001a\u0010\u0010B\u001a\u00020>2\u0006\u0010@\u001a\u00020AH\u0002\u001a\u0010\u0010C\u001a\u00020>2\u0006\u0010D\u001a\u00020EH\u0002\u001a\u0018\u0010=\u001a\b\u0012\u0004\u0012\u0002070F*\u00020G2\u0006\u0010H\u001a\u00020>\u001a\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020J0F*\u00020G2\u0006\u0010H\u001a\u00020>\u001a\u0018\u0010K\u001a\b\u0012\u0004\u0012\u00020L0F*\u00020G2\u0006\u0010H\u001a\u00020>\u001a\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020N0F*\u00020G2\u0006\u0010H\u001a\u00020>\u001a\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020A0F*\u00020G2\u0006\u0010H\u001a\u00020>\u001a\u0018\u0010P\u001a\b\u0012\u0004\u0012\u00020E0F*\u00020G2\u0006\u0010H\u001a\u00020>\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"#\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\b\u0010\u0004\"#\u0010\n\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\u0006\u001a\u0004\b\u000b\u0010\u0004\"#\u0010\r\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u000e\u0010\u0004\"\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\"#\u0010\u0017\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0006\u001a\u0004\b\u0018\u0010\u0004\"#\u0010\u001a\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0006\u001a\u0004\b\u001b\u0010\u0004\"#\u0010\u001d\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0006\u001a\u0004\b\u001e\u0010\u0004\"#\u0010 \u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0006\u001a\u0004\b!\u0010\u0004\"#\u0010#\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0006\u001a\u0004\b$\u0010\u0004\"#\u0010&\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0006\u001a\u0004\b'\u0010\u0004\"#\u0010)\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0006\u001a\u0004\b*\u0010\u0004\"#\u0010,\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0006\u001a\u0004\b-\u0010\u0004\"#\u0010/\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0006\u001a\u0004\b0\u0010\u0004\"#\u00102\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0006\u001a\u0004\b3\u0010\u0004\"\u0018\u00105\u001a\u000206*\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006Q"}, d2={"DEFAULT_DATE_STRING_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDEFAULT_DATE_STRING_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "DEFAULT_DATE_STRING_FORMATTER$delegate", "Lkotlin/Lazy;", "DEFAULT_DATE_TIME_STRING_FORMATTER", "getDEFAULT_DATE_TIME_STRING_FORMATTER", "DEFAULT_DATE_TIME_STRING_FORMATTER$delegate", "DEFAULT_OFFSET_DATE_TIME_FORMATTER", "getDEFAULT_OFFSET_DATE_TIME_FORMATTER", "DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate", "DEFAULT_TIME_STRING_FORMATTER", "getDEFAULT_TIME_STRING_FORMATTER", "DEFAULT_TIME_STRING_FORMATTER$delegate", "DEFAULT_TIME_ZONE", "Lkotlinx/datetime/TimeZone;", "getDEFAULT_TIME_ZONE", "()Lkotlinx/datetime/TimeZone;", "DEFAULT_TIME_ZONE$delegate", "MILLIS_IN_SECOND", "", "MYSQL_DATE_TIME_STRING_FORMATTER", "getMYSQL_DATE_TIME_STRING_FORMATTER", "MYSQL_DATE_TIME_STRING_FORMATTER$delegate", "MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER", "getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER", "MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate", "MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate", "MYSQL_OFFSET_DATE_TIME_FORMATTER", "getMYSQL_OFFSET_DATE_TIME_FORMATTER", "MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate", "MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER", "getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER", "MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate", "ORACLE_OFFSET_DATE_TIME_FORMATTER", "getORACLE_OFFSET_DATE_TIME_FORMATTER", "ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate", "ORACLE_TIME_STRING_FORMATTER", "getORACLE_TIME_STRING_FORMATTER", "ORACLE_TIME_STRING_FORMATTER$delegate", "POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate", "SQLITE_OFFSET_DATE_TIME_FORMATTER", "getSQLITE_OFFSET_DATE_TIME_FORMATTER", "SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate", "millis", "", "Lkotlinx/datetime/LocalDate;", "getMillis", "(Lkotlinx/datetime/LocalDate;)J", "dateTimeWithFractionFormat", "fraction", "formatterForDateString", "date", "", "oracleDateLiteral", "instant", "Lkotlinx/datetime/Instant;", "oracleDateTimeLiteral", "oracleDateTimeWithTimezoneLiteral", "dateTime", "Ljava/time/OffsetDateTime;", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/Table;", "name", "datetime", "Lkotlinx/datetime/LocalDateTime;", "duration", "Lkotlin/time/Duration;", "time", "Lkotlinx/datetime/LocalTime;", "timestamp", "timestampWithTimeZone", "exposed-kotlin-datetime"})
public final class KotlinDateColumnTypeKt {
    private static final int MILLIS_IN_SECOND = 1000;
    @NotNull
    private static final Lazy DEFAULT_TIME_ZONE$delegate = LazyKt.lazy((Function0)DEFAULT_TIME_ZONE.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_DATE_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy ORACLE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)ORACLE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy((Function0)SQLITE_OFFSET_DATE_TIME_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_OFFSET_DATE_TIME_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy((Function0)ORACLE_OFFSET_DATE_TIME_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_OFFSET_DATE_TIME_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate = LazyKt.lazy((Function0)POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate = LazyKt.lazy((Function0)MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER.2.INSTANCE);

    private static final TimeZone getDEFAULT_TIME_ZONE() {
        Lazy lazy = DEFAULT_TIME_ZONE$delegate;
        return (TimeZone)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = MYSQL_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getORACLE_TIME_STRING_FORMATTER() {
        Lazy lazy = ORACLE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getSQLITE_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getORACLE_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER() {
        Lazy lazy = MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        Lazy lazy = POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        Lazy lazy = MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter formatterForDateString(String date) {
        return KotlinDateColumnTypeKt.dateTimeWithFractionFormat(StringsKt.substringAfterLast((String)date, (char)'.', (String)"").length());
    }

    private static final DateTimeFormatter dateTimeWithFractionFormat(int fraction) {
        String string;
        String baseFormat = "yyyy-MM-dd HH:mm:ss";
        boolean bl = 1 <= fraction ? fraction < 10 : false;
        if (bl) {
            IntRange intRange = new IntRange(1, fraction);
            String string2 = baseFormat + '.';
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)intRange), (CharSequence)"", (CharSequence)string2, null, (int)0, null, (Function1)dateTimeWithFractionFormat.newFormat.1.INSTANCE, (int)28, null);
        } else {
            string = baseFormat;
        }
        String newFormat2 = string;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(newFormat2).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        return dateTimeFormatter;
    }

    private static final String oracleDateTimeLiteral(Instant instant) {
        return "TO_TIMESTAMP('" + KotlinDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
    }

    private static final String oracleDateTimeWithTimezoneLiteral(OffsetDateTime dateTime) {
        return "TO_TIMESTAMP_TZ('" + dateTime.format(KotlinDateColumnTypeKt.getORACLE_OFFSET_DATE_TIME_FORMATTER()) + "', 'YYYY-MM-DD HH24:MI:SS.FF6 TZH:TZM')";
    }

    private static final String oracleDateLiteral(Instant instant) {
        return "TO_DATE('" + KotlinDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + "', 'YYYY-MM-DD')";
    }

    private static final long getMillis(LocalDate $this$millis) {
        return TimeZoneKt.atStartOfDayIn((LocalDate)$this$millis, (TimeZone)TimeZone.Companion.currentSystemDefault()).getEpochSeconds() * (long)1000;
    }

    @NotNull
    public static final Column<LocalDate> date(@NotNull Table $this$date, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$date, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$date.registerColumn(name, (IColumnType)new KotlinLocalDateColumnType());
    }

    @NotNull
    public static final Column<LocalDateTime> datetime(@NotNull Table $this$datetime, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$datetime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$datetime.registerColumn(name, (IColumnType)new KotlinLocalDateTimeColumnType());
    }

    @NotNull
    public static final Column<LocalTime> time(@NotNull Table $this$time, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$time, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$time.registerColumn(name, (IColumnType)new KotlinLocalTimeColumnType());
    }

    @NotNull
    public static final Column<Instant> timestamp(@NotNull Table $this$timestamp, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestamp.registerColumn(name, (IColumnType)new KotlinInstantColumnType());
    }

    @NotNull
    public static final Column<OffsetDateTime> timestampWithTimeZone(@NotNull Table $this$timestampWithTimeZone, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampWithTimeZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestampWithTimeZone.registerColumn(name, (IColumnType)new KotlinOffsetDateTimeColumnType());
    }

    @NotNull
    public static final Column<Duration> duration(@NotNull Table $this$duration, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$duration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$duration.registerColumn(name, (IColumnType)new KotlinDurationColumnType());
    }

    public static final /* synthetic */ TimeZone access$getDEFAULT_TIME_ZONE() {
        return KotlinDateColumnTypeKt.getDEFAULT_TIME_ZONE();
    }

    public static final /* synthetic */ String access$oracleDateLiteral(Instant instant) {
        return KotlinDateColumnTypeKt.oracleDateLiteral(instant);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER();
    }

    public static final /* synthetic */ long access$getMillis(LocalDate $receiver) {
        return KotlinDateColumnTypeKt.getMillis($receiver);
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ String access$oracleDateTimeLiteral(Instant instant) {
        return KotlinDateColumnTypeKt.oracleDateTimeLiteral(instant);
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$formatterForDateString(String date) {
        return KotlinDateColumnTypeKt.formatterForDateString(date);
    }

    public static final /* synthetic */ DateTimeFormatter access$getORACLE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getORACLE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getSQLITE_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ String access$oracleDateTimeWithTimezoneLiteral(OffsetDateTime dateTime) {
        return KotlinDateColumnTypeKt.oracleDateTimeWithTimezoneLiteral(dateTime);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        return KotlinDateColumnTypeKt.getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER();
    }
}

