/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eH\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\u0019\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020%H\u0096\u0002J)\u0010&\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016\u00a2\u0006\u0002\u0010+J \u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u001c\u00100\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "statement", "Ljava/sql/PreparedStatement;", "wasGeneratedKeysRequested", "", "(Ljava/sql/PreparedStatement;Z)V", "value", "", "fetchSize", "getFetchSize", "()Ljava/lang/Integer;", "setFetchSize", "(Ljava/lang/Integer;)V", "resultSet", "Ljava/sql/ResultSet;", "getResultSet", "()Ljava/sql/ResultSet;", "getStatement", "()Ljava/sql/PreparedStatement;", "timeout", "getTimeout", "setTimeout", "getWasGeneratedKeysRequested", "()Z", "addBatch", "", "cancel", "closeIfPossible", "executeBatch", "", "executeMultiple", "Lorg/jetbrains/exposed/sql/statements/StatementResult;", "executeQuery", "executeUpdate", "set", "index", "", "setArray", "type", "", "array", "", "(ILjava/lang/String;[Ljava/lang/Object;)V", "setInputStream", "inputStream", "Ljava/io/InputStream;", "setAsBlobObject", "setNull", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcPreparedStatementImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcPreparedStatementImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n1#2:111\n11095#3:112\n11430#3,3:113\n*S KotlinDebug\n*F\n+ 1 JdbcPreparedStatementImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl\n*L\n97#1:112\n97#1:113,3\n*E\n"})
public final class JdbcPreparedStatementImpl
implements PreparedStatementApi {
    @NotNull
    private final PreparedStatement statement;
    private final boolean wasGeneratedKeysRequested;

    public JdbcPreparedStatementImpl(@NotNull PreparedStatement statement, boolean wasGeneratedKeysRequested) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.statement = statement;
        this.wasGeneratedKeysRequested = wasGeneratedKeysRequested;
    }

    @NotNull
    public final PreparedStatement getStatement() {
        return this.statement;
    }

    public final boolean getWasGeneratedKeysRequested() {
        return this.wasGeneratedKeysRequested;
    }

    @Nullable
    public ResultSet getResultSet() {
        return !this.wasGeneratedKeysRequested ? this.statement.getResultSet() : (DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? this.statement.getConnection().prepareStatement("select last_insert_rowid();").executeQuery() : this.statement.getGeneratedKeys());
    }

    @Nullable
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    public void setFetchSize(@Nullable Integer value) {
        block0: {
            Integer n = value;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.statement.setFetchSize(value);
        }
    }

    @Nullable
    public Integer getTimeout() {
        return this.statement.getQueryTimeout();
    }

    public void setTimeout(@Nullable Integer value) {
        block0: {
            Integer n = value;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.statement.setQueryTimeout(it);
        }
    }

    public void addBatch() {
        this.statement.addBatch();
    }

    @NotNull
    public ResultSet executeQuery() {
        ResultSet resultSet = this.statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
        return resultSet;
    }

    public int executeUpdate() {
        return this.statement.executeUpdate();
    }

    @NotNull
    public List<StatementResult> executeMultiple() {
        List list;
        if (this.statement.execute()) {
            ResultSet resultSet = this.statement.getResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"getResultSet(...)");
            list = CollectionsKt.listOf((Object)new StatementResult.Object(resultSet));
        } else {
            while (!this.statement.getMoreResults(1)) {
                if (this.statement.getUpdateCount() != -1) continue;
                return CollectionsKt.emptyList();
            }
            ResultSet resultSet = this.statement.getResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"getResultSet(...)");
            list = CollectionsKt.listOf((Object)new StatementResult.Object(resultSet));
        }
        return list;
    }

    public void set(int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.statement.setObject(index, value);
    }

    public void setNull(int index, @NotNull IColumnType<?> columnType) {
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        if (columnType instanceof BinaryColumnType || columnType instanceof BlobColumnType && !((BlobColumnType)columnType).getUseObjectIdentifier()) {
            this.statement.setNull(index, -4);
        } else {
            this.statement.setObject(index, null);
        }
    }

    public void setInputStream(int index, @NotNull InputStream inputStream, boolean setAsBlobObject) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        if (setAsBlobObject) {
            this.statement.setBlob(index, inputStream);
        } else {
            this.statement.setBinaryStream(index, inputStream, inputStream.available());
        }
    }

    public void setArray(int index, @NotNull String type, @NotNull Object[] array) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.statement.setArray(index, this.statement.getConnection().createArrayOf(type, array));
    }

    public void closeIfPossible() {
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Integer> executeBatch() {
        void $this$mapTo$iv$iv;
        int[] nArray = this.statement.executeBatch();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"executeBatch(...)");
        int[] $this$map$iv = nArray;
        boolean $i$f$map = false;
        int[] nArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (it) {
                case -2: {
                    n2 = 1;
                    break;
                }
                case -3: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = it;
                }
            }
            collection.add(n2);
        }
        return (List)destination$iv$iv;
    }

    public void cancel() {
        if (!this.statement.isClosed()) {
            this.statement.cancel();
        }
    }

    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args) {
        return PreparedStatementApi.DefaultImpls.fillParameters((PreparedStatementApi)this, args);
    }
}

