/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0016\u0010*\u001a\u00020(2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0,H\u0016J,\u0010\u0015\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002H-0/\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u00102J#\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f07H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0006H\u0016J\u0010\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020(H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\fH\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR$\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R&\u0010\"\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "connection", "(Ljava/sql/Connection;)V", "value", "", "autoCommit", "getAutoCommit", "()Z", "setAutoCommit", "(Z)V", "", "catalog", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "getConnection", "()Ljava/sql/Connection;", "isClosed", "metadata", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "getMetadata", "()Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "readOnly", "getReadOnly", "setReadOnly", "schema", "getSchema", "setSchema", "", "transactionIsolation", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "close", "", "commit", "executeInBatch", "sqls", "", "T", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "prepareStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "columns", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "returnKeys", "releaseSavepoint", "savepoint", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "rollback", "setSavepoint", "name", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcConnectionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1549#2:154\n1620#2,3:155\n2624#2,3:158\n*S KotlinDebug\n*F\n+ 1 JdbcConnectionImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl\n*L\n96#1:154\n96#1:155,3\n102#1:158,3\n*E\n"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    @NotNull
    private final Connection connection;
    private int transactionIsolation;
    @NotNull
    private final Lazy metadata$delegate;

    public JdbcConnectionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.transactionIsolation = -1;
        this.metadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JdbcDatabaseMetadataImpl>(this){
            final /* synthetic */ JdbcConnectionImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JdbcDatabaseMetadataImpl invoke() {
                String string = this.this$0.getCatalog();
                DatabaseMetaData databaseMetaData = this.this$0.getConnection().getMetaData();
                Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getMetaData(...)");
                return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
            }
        }));
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public String getCatalog() {
        String string;
        String string2;
        String string3;
        try {
            string3 = this.getConnection().getCatalog();
        }
        catch (Exception _) {
            string3 = null;
        }
        if ((string2 = string3) == null) {
            string2 = string = this.getConnection().getMetaData().getUserName();
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    public void setCatalog(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            this.getConnection().setCatalog(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public String getSchema() {
        String string;
        try {
            string = this.getConnection().getSchema();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception _) {
            string = "";
        }
        return string;
    }

    public void setSchema(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            this.getConnection().setSchema(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        this.getConnection().commit();
    }

    public void rollback() {
        this.getConnection().rollback();
    }

    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    public void close() {
        this.getConnection().close();
    }

    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    public void setAutoCommit(boolean value) {
        this.getConnection().setAutoCommit(value);
    }

    public boolean getReadOnly() {
        return this.getConnection().isReadOnly();
    }

    public void setReadOnly(boolean value) {
        this.getConnection().setReadOnly(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() {
        if (this.transactionIsolation == -1) {
            JdbcConnectionImpl jdbcConnectionImpl = this;
            synchronized (jdbcConnectionImpl) {
                boolean bl = false;
                this.transactionIsolation = this.getConnection().getTransactionIsolation();
                Unit unit = Unit.INSTANCE;
            }
        }
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int value) {
        if (this.transactionIsolation != value) {
            this.getConnection().setTransactionIsolation(value);
            this.transactionIsolation = value;
        }
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy = this.metadata$delegate;
        return (JdbcDatabaseMetadataImpl)((Object)lazy.getValue());
    }

    public <T> T metadata(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return (T)body.invoke((Object)this.getMetadata());
    }

    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, boolean returnKeys) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        int generated = returnKeys ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, generated);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, returnKeys, this.getConnection().getMetaData().supportsGetGeneratedKeys());
    }

    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, @NotNull String[] columns) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, columns);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"prepareStatement(...)");
        return new JdbcPreparedStatementImpl(preparedStatement, true, this.getConnection().getMetaData().supportsGetGeneratedKeys());
    }

    /*
     * WARNING - void declaration
     */
    public void executeInBatch(@NotNull List<String> sqls) {
        boolean bl;
        List types;
        Object object;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
            Iterable $this$map$iv = sqls;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementType statementType;
                Object v0;
                Collection collection;
                block8: {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = (Iterable)EntriesMappings.entries$0;
                    for (Object t : iterable) {
                        void stmt;
                        StatementType it = (StatementType)t;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith((String)stmt, (String)it.name(), (boolean)true)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                if ((statementType = (StatementType)v0) == null) {
                    statementType = StatementType.OTHER;
                }
                collection.add(statementType);
            }
            types = (List)destination$iv$iv;
            Iterable $this$none$iv = types;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatementType it = (StatementType)element$iv;
                    boolean bl4 = false;
                    if (!(it == StatementType.SELECT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = false;
            String $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = "SELECT statements are unsupported in batch execution";
            throw new IllegalStateException($i$a$-check-JdbcConnectionImpl$executeInBatch$32.toString());
        }
        StatementType statementType = (StatementType)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)types));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type = statementType;
        object = CollectionsKt.emptyList();
        Statement<Unit> prepStatement2 = new Statement<Unit>(type, this, sqls, (List<? extends Table>)object){
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List<String> $sqls;
            {
                this.this$0 = $receiver;
                this.$sqls = $sqls;
                super($type, $super_call_param$1);
            }

            @NotNull
            public PreparedStatementApi prepared(@NotNull Transaction transaction, @NotNull String sql) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                PreparedStatementApi originalStatement = super.prepared(transaction, StringsKt.substringBefore$default((String)sql, (char)'\n', null, (int)2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                List<String> list = this.$sqls;
                java.sql.Statement $this$prepared_u24lambda_u241 = statement;
                boolean bl = false;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    $this$prepared_u24lambda_u241.addBatch(it);
                }
                java.sql.Statement batchStatement = statement;
                return new PreparedStatementApi(originalStatement, batchStatement){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ PreparedStatementApi $originalStatement;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    {
                        this.$originalStatement = $originalStatement;
                        this.$batchStatement = $batchStatement;
                        this.$$delegate_0 = $originalStatement;
                    }

                    @Nullable
                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(@Nullable Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    @Nullable
                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    @Nullable
                    public Integer getTimeout() {
                        return this.$$delegate_0.getTimeout();
                    }

                    public void setTimeout(@Nullable Integer n) {
                        this.$$delegate_0.setTimeout(n);
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    public void cancel() {
                        this.$$delegate_0.cancel();
                    }

                    @NotNull
                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    @NotNull
                    public List<StatementResult> executeMultiple() {
                        return this.$$delegate_0.executeMultiple();
                    }

                    @NotNull
                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args) {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$$delegate_0.fillParameters(args);
                    }

                    public void set(int index, @NotNull Object value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.$$delegate_0.set(index, value);
                    }

                    public void setInputStream(int index, @NotNull InputStream inputStream) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        this.$$delegate_0.setInputStream(index, inputStream);
                    }

                    public void setNull(int index, @NotNull IColumnType columnType) {
                        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
                        this.$$delegate_0.setNull(index, columnType);
                    }

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                };
            }

            public void executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                $this$executeInternal.executeUpdate();
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return CollectionsKt.joinToString$default((Iterable)this.$sqls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }

            @NotNull
            public Iterable<Iterable<Pair<ColumnType, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
        };
        prepStatement2.execute(TransactionManager.Companion.current());
    }

    @NotNull
    public ExposedSavepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Savepoint savepoint = this.getConnection().setSavepoint(name);
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"setSavepoint(...)");
        return new JdbcSavepoint(name, savepoint);
    }

    public void releaseSavepoint(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    public void rollback(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().rollback(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<StatementType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])StatementType.values()));
        }
    }
}

