/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 _2\u00020\u0001:\u0002^_B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010A\u001a\u00020BH\u0016J3\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ3\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ/\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010J062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ-\u0010K\u001a\b\u0012\u0004\u0012\u0002HM0L\"\u0004\b\u0000\u0010M2\u0017\u0010N\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HM0O\u00a2\u0006\u0002\bPH\u0002J\b\u0010Q\u001a\u00020BH\u0016J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u0003H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J\u001c\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030U2\u0006\u0010V\u001a\u00020\u001cH\u0002J(\u0010W\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0\u001d062\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0016J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010Z\u001a\u00020\u0003H\u0002J\f\u0010[\u001a\u00020D*\u00020\\H\u0002J\u0012\u0010]\u001a\b\u0012\u0004\u0012\u00020D0\u001d*\u00020\\H\u0002R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u001b\u0010\u0012\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0013\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bj\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000f\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u000f\u001a\u0004\b0\u0010-R\u001b\u00102\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b3\u0010-R&\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001b\u00109\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000f\u001a\u0004\b:\u0010\tR\u001b\u0010<\u001a\u00020=8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u000f\u001a\u0004\b>\u0010?\u00a8\u0006`"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "database", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "_currentScheme", "get_currentScheme", "()Ljava/lang/String;", "currentScheme", "getCurrentScheme", "databaseDialectName", "getDatabaseDialectName", "databaseDialectName$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "databaseProductVersion", "getDatabaseProductVersion", "databaseProductVersion$delegate", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel$delegate", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Table;", "", "Lorg/jetbrains/exposed/sql/Index;", "Lkotlin/collections/HashMap;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "schemaNames", "getSchemaNames", "()Ljava/util/List;", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "tableNames", "", "getTableNames", "()Ljava/util/Map;", "url", "getUrl", "url$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "cleanCache", "", "columns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "existingIndices", "existingPrimaryKeys", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "lazyMetadata", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "resetCurrentScheme", "sanitizedDefault", "defaultValue", "tableCatalogAndSchema", "Lkotlin/Pair;", "table", "tableConstraints", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableNamesFor", "scheme", "asColumnMetadata", "Ljava/sql/ResultSet;", "extractColumns", "CachableMapWithDefault", "Companion", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,343:1\n1#2:344\n1#2:414\n1549#3:345\n1620#3,3:346\n1194#3,2:373\n1222#3,4:375\n3190#3,10:396\n1549#3:406\n1620#3,3:407\n1549#3:410\n1620#3,3:411\n1194#3,2:427\n1222#3,4:429\n1271#3,2:433\n1285#3,2:435\n1477#3:437\n1502#3,3:438\n1505#3,3:448\n1549#3:451\n1620#3,2:452\n2661#3,7:454\n1622#3:461\n1288#3:462\n10513#4:349\n10738#4,3:350\n10741#4,3:360\n9226#4,2:421\n9376#4,4:423\n372#5,7:353\n372#5,3:363\n372#5,7:366\n551#5:379\n536#5,6:380\n375#5,4:417\n372#5,7:441\n135#6,9:386\n215#6:395\n216#6:415\n144#6:416\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n*L\n235#1:414\n125#1:345\n125#1:346,3\n234#1:373,2\n234#1:375,4\n236#1:396,10\n237#1:406\n237#1:407,3\n243#1:410\n243#1:411,3\n271#1:427,2\n271#1:429,4\n272#1:433,2\n272#1:435,2\n301#1:437\n301#1:438,3\n301#1:448,3\n301#1:451\n301#1:452,2\n301#1:454,7\n301#1:461\n272#1:462\n139#1:349\n139#1:350,3\n139#1:360,3\n254#1:421,2\n254#1:423,4\n139#1:353,7\n198#1:363,3\n229#1:366,7\n235#1:379\n235#1:380,6\n198#1:417,4\n301#1:441,7\n235#1:386,9\n235#1:395\n235#1:415\n235#1:416\n*E\n"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMetaData metadata;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy databaseDialectName$delegate;
    @NotNull
    private final Lazy databaseProductVersion$delegate;
    @NotNull
    private final Lazy defaultIsolationLevel$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private String _currentScheme;
    @NotNull
    private final HashMap<Table, List<Index>> existingIndicesCache;
    @NotNull
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(@NotNull String database, @NotNull DatabaseMetaData metadata2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        super(database);
        this.metadata = metadata2;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @NotNull
    public String getUrl() {
        Lazy lazy = this.url$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-url>(...)");
        return (String)object;
    }

    @NotNull
    public BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        return (BigDecimal)lazy.getValue();
    }

    @NotNull
    public String getDatabaseDialectName() {
        Lazy lazy = this.databaseDialectName$delegate;
        return (String)lazy.getValue();
    }

    private final String getDatabaseName() {
        String string = this.getDatabaseDialectName();
        return (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) ? this.getCurrentScheme() : this.getDatabase();
    }

    @NotNull
    public String getDatabaseProductVersion() {
        Lazy lazy = this.databaseProductVersion$delegate;
        return (String)lazy.getValue();
    }

    public int getDefaultIsolationLevel() {
        Lazy lazy = this.defaultIsolationLevel$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-identifierManager>(...)");
        return (IdentifierManagerApi)object;
    }

    private final String get_currentScheme() {
        if (this._currentScheme == null) {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = this.getDatabaseDialectName();
                if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getCatalog();
                    if (string2 == null) {
                        string2 = "";
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)OracleDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = this.getDatabaseName();
                    }
                } else {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable _) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl._currentScheme = string;
        }
        String string = this._currentScheme;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public String getCurrentScheme() {
        String string = this.get_currentScheme();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public void resetCurrentScheme() {
        this._currentScheme = null;
    }

    @NotNull
    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(this, null, (Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull String schemeName) {
                Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, schemeName);
            }
        }, 1, null);
    }

    private final List<String> tableNamesFor(String scheme) {
        String string;
        CharSequence charSequence;
        Pair pair;
        DatabaseMetaData $this$tableNamesFor_u24lambda_u242 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            pair = TuplesKt.to((Object)scheme, (Object)"%");
        } else if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            CharSequence charSequence2;
            String string2 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string2;
                boolean bl2 = false;
                charSequence2 = this.getDatabaseName();
                string2 = string;
            } else {
                charSequence2 = charSequence;
            }
            pair = TuplesKt.to((Object)string2, (Object)charSequence2);
        } else {
            CharSequence charSequence3;
            String string3 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string3;
                boolean bl3 = false;
                charSequence3 = "%";
                string3 = string;
            } else {
                charSequence3 = charSequence;
            }
            pair = TuplesKt.to((Object)string3, (Object)charSequence3);
        }
        Pair pair2 = pair;
        String catalogName = (String)pair2.component1();
        String schemeName = (String)pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = $this$tableNamesFor_u24lambda_u242.getTables(catalogName, schemeName, "%", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, String>(useCatalogInsteadOfScheme, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = $useCatalogInsteadOfScheme;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResultSet $this$iterate) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                String string3 = $this$iterate.getString("TABLE_NAME");
                Intrinsics.checkNotNull((Object)string3);
                String tableName = string3;
                if (this.$useCatalogInsteadOfScheme) {
                    String string4 = $this$iterate.getString("TABLE_CAT");
                    if (string4 != null) {
                        String it = string4;
                        boolean bl = false;
                        string2 = it + '.' + tableName;
                    } else {
                        string2 = null;
                    }
                } else {
                    String string5 = $this$iterate.getString("TABLE_SCHEM");
                    if (string5 != null) {
                        String it = string5;
                        boolean bl = false;
                        string2 = it + '.' + tableName;
                    } else {
                        string2 = string = null;
                    }
                }
                if (string2 == null) {
                    string = tableName;
                }
                String fullTableName = string;
                return this.this$0.getIdentifierManager().inProperCase(fullTableName);
            }
        });
    }

    @NotNull
    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> schemaNames() {
        void $this$mapTo$iv$iv;
        List list;
        DatabaseMetaData $this$schemaNames_u24lambda_u244 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            ResultSet resultSet = $this$schemaNames_u24lambda_u244.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"catalogs");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            ResultSet resultSet = $this$schemaNames_u24lambda_u244.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"schemas");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        List schemas2 = list;
        Iterable $this$map$iv = schemas2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(identifierManagerApi.inProperCase((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final List<ColumnMetadata> extractColumns(ResultSet $this$extractColumns) {
        List result = new ArrayList();
        while ($this$extractColumns.next()) {
            result.add(this.asColumnMetadata($this$extractColumns));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Table, List<ColumnMetadata>> columns(Table ... tables) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Map result = new LinkedHashMap();
        boolean useSchemaInsteadOfDatabase = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        Table[] $this$groupBy$iv = tables;
        boolean $i$f$groupBy = false;
        Table[] tableArray = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void element$iv$iv;
            void it = element$iv$iv = $this$groupByTo$iv$iv[i];
            boolean bl = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            String string = it.getSchemaName();
            if (string == null) {
                string = this.getCurrentScheme();
            }
            String key$iv$iv = identifierManagerApi.inProperCase(string);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map tablesBySchema = destination$iv$iv;
        for (Map.Entry entry : tablesBySchema.entrySet()) {
            String schema = (String)entry.getKey();
            List schemaTables = (List)entry.getValue();
            for (Table table : schemaTables) {
                String catalog = !useSchemaInsteadOfDatabase || Intrinsics.areEqual((Object)schema, (Object)this.getCurrentScheme()) ? this.getDatabaseName() : schema;
                ResultSet rs = this.metadata.getColumns(catalog, schema, table.nameInDatabaseCaseUnquoted(), "%");
                Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
                List<ColumnMetadata> columns = this.extractColumns(rs);
                if (!(!((Collection)columns).isEmpty())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                result.put(table, columns);
                rs.close();
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnMetadata asColumnMetadata(ResultSet $this$asColumnMetadata) {
        Object object;
        void it3;
        String string;
        int n;
        String string2 = $this$asColumnMetadata.getString("COLUMN_DEF");
        if (string2 != null) {
            String it2 = string2;
            n = 0;
            string = this.sanitizedDefault(it2);
        } else {
            string = null;
        }
        String defaultDbValue = string;
        boolean autoIncrement = Intrinsics.areEqual((Object)$this$asColumnMetadata.getString("IS_AUTOINCREMENT"), (Object)"YES");
        int type = $this$asColumnMetadata.getInt("DATA_TYPE");
        String string3 = $this$asColumnMetadata.getString("COLUMN_NAME");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\"COLUMN_NAME\")");
        Object object2 = $this$asColumnMetadata.getInt("COLUMN_SIZE");
        n = ((Number)object2).intValue();
        boolean bl = $this$asColumnMetadata.getBoolean("NULLABLE");
        int n2 = type;
        String string4 = string3;
        boolean bl2 = false;
        Comparable<Boolean> comparable = it3 != false;
        String string5 = string4;
        int n3 = n2;
        boolean bl3 = bl;
        Object object3 = comparable != false ? object2 : null;
        boolean bl4 = autoIncrement;
        String string6 = defaultDbValue;
        if (string6 != null) {
            Object it3 = object2 = string6;
            boolean bl5 = bl4;
            comparable = object3;
            bl = bl3;
            n2 = n3;
            string4 = string5;
            boolean bl6 = false;
            boolean bl7 = !autoIncrement;
            string5 = string4;
            n3 = n2;
            bl3 = bl;
            object3 = comparable;
            bl4 = bl5;
            object = bl7 ? object2 : null;
        } else {
            object = null;
        }
        Object object4 = object;
        boolean bl8 = bl4;
        Integer n4 = object3;
        boolean bl9 = bl3;
        int n5 = n3;
        String string7 = string5;
        return new ColumnMetadata(string7, n5, bl9, n4, bl8, object4);
    }

    private final String sanitizedDefault(String defaultValue) {
        String string;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2Mode = H2Kt.getH2Mode((DatabaseDialect)dialect);
        if (dialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')', '\''};
            string = StringsKt.trim((String)defaultValue, (char[])cArray);
        } else if (dialect instanceof OracleDialect || h2Mode == H2Dialect.H2CompatibilityMode.Oracle) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)defaultValue)).toString(), (char[])cArray);
        } else if (dialect instanceof MysqlDialect || h2Mode == H2Dialect.H2CompatibilityMode.MySQL || h2Mode == H2Dialect.H2CompatibilityMode.MariaDB) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
        } else if (dialect instanceof PostgreSQLDialect || h2Mode == H2Dialect.H2CompatibilityMode.PostgreSQL) {
            if (StringsKt.startsWith$default((CharSequence)defaultValue, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)defaultValue, (char)'\'', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)defaultValue, (char[])cArray);
            } else {
                string = defaultValue;
            }
        } else {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)defaultValue, (char[])cArray);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        for (Table table : tables) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Column $this$getOrPut$iv;
            Iterable columnName;
            Transaction transaction = TransactionManager.Companion.current();
            Pair<String, String> pair = this.tableCatalogAndSchema(table);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            Map $this$getOrPut$iv2 = this.existingIndicesCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(table);
            if (value$iv != null) continue;
            boolean bl = false;
            ResultSet rs = this.metadata.getPrimaryKeys(catalog, tableSchema, table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            Object names = new ArrayList();
            while (rs.next()) {
                String string;
                String string2 = string = rs.getString("PK_NAME");
                if (string2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"PK_NAME\")");
                String it = string;
                boolean bl3 = false;
                ((Collection)names).add(it);
            }
            rs.close();
            ArrayList pkNames = names;
            String storedIndexTable = Intrinsics.areEqual((Object)tableSchema, (Object)this.getCurrentScheme()) ? table.nameInDatabaseCase() : table.nameInDatabaseCaseUnquoted();
            rs = this.metadata.getIndexInfo(catalog, tableSchema, storedIndexTable, false, false);
            HashMap tmpIndices = new HashMap();
            while (rs.next()) {
                Object object;
                String columnNameMetadata;
                Object object2 = names = rs.getString("INDEX_NAME");
                if (object2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getString(\"INDEX_NAME\")");
                Object indexName = names;
                boolean bl4 = false;
                String string = rs.getString("COLUMN_NAME");
                if (string == null) {
                    DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                    string = (databaseDialect instanceof MysqlDialect ? true : databaseDialect instanceof SQLiteDialect) ? "\"\"" : null;
                }
                if ((columnNameMetadata = string) == null) continue;
                boolean bl5 = false;
                String column = transaction.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary((String)((Object)columnName));
                boolean isUnique = !rs.getBoolean("NON_UNIQUE");
                Object object3 = rs.getString("FILTER_CONDITION");
                Op.TRUE isPartial = object3 == null || object3.length() == 0 ? null : Op.TRUE.INSTANCE;
                object3 = tmpIndices;
                Triple key$iv = new Triple(indexName, (Object)isUnique, (Object)isPartial);
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv.get(key$iv);
                if (value$iv2 == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((List)object).add(column);
            }
            rs.close();
            Iterable $this$associateBy$iv = table.getColumns();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            columnName = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                $this$getOrPut$iv = (Column)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl7 = false;
                map.put(transaction.identity((Column)it), element$iv$iv);
            }
            Map tColumns = destination$iv$iv;
            Map $this$filterNot$iv = tmpIndices;
            boolean $i$f$filterNot = false;
            Map capacity$iv22 = $this$filterNot$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator $i$f$associateByTo22 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while ($i$f$associateByTo22.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
                boolean bl8 = false;
                if (pkNames.contains(((Triple)it.getKey()).getFirst())) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filterNot$iv = destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Index index;
                List list;
                void $this$mapTo$iv$iv;
                Object element$iv2;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl9 = false;
                Map.Entry entry = element$iv$iv;
                boolean bl10 = false;
                Triple index2 = (Triple)entry.getKey();
                List columns = (List)entry.getValue();
                Iterable $this$partition$iv = CollectionsKt.distinct((Iterable)columns);
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $this$partition$iv) {
                    String cn = (String)element$iv2;
                    boolean bl11 = false;
                    if (tColumns.get(cn) == null) {
                        first$iv.add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List functionBased = (List)pair2.component1();
                List columnBased = (List)pair2.component2();
                Iterable $this$map$iv = columnBased;
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cn;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl12 = false;
                    Object v = tColumns.get(cn);
                    Intrinsics.checkNotNull(v);
                    collection.add((Column)v);
                }
                List c = list = (List)destination$iv$iv3;
                boolean bl13 = false;
                List list2 = c.size() + functionBased.size() == columns.size() ? list : null;
                if (list2 != null) {
                    Collection<LiteralOp> collection;
                    Collection<LiteralOp> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    c = list2;
                    boolean bl14 = false;
                    destination$iv$iv3 = functionBased;
                    Op op = (Op)index2.getThird();
                    Iterator iterator2 = null;
                    String string = (String)index2.getFirst();
                    boolean bl15 = (Boolean)index2.getSecond();
                    List list3 = c;
                    boolean $i$f$map2 = false;
                    void var49_72 = $this$map$iv2;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        String string3 = (String)item$iv$iv;
                        collection2 = destination$iv$iv4;
                        boolean bl16 = false;
                        collection2.add(OpKt.stringLiteral((String)it));
                    }
                    collection2 = (List)destination$iv$iv4;
                    List list4 = list3;
                    boolean bl17 = bl15;
                    String string4 = string;
                    Iterator iterator3 = iterator2;
                    Op op2 = op;
                    Collection<LiteralOp> collection3 = collection2;
                    if (collection3.isEmpty()) {
                        op = op2;
                        iterator2 = iterator3;
                        string = string4;
                        bl15 = bl17;
                        list3 = list4;
                        boolean bl18 = false;
                        collection2 = null;
                        list4 = list3;
                        bl17 = bl15;
                        string4 = string;
                        iterator3 = iterator2;
                        op2 = op;
                        collection = collection2;
                    } else {
                        collection = collection3;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 8;
                    Table table2 = !((Collection)functionBased).isEmpty() ? table : null;
                    List list5 = (List)collection;
                    Op op3 = op2;
                    Iterator iterator4 = iterator3;
                    String string5 = string4;
                    boolean bl19 = bl17;
                    List list6 = list4;
                    index = new Index(list6, bl19, string5, iterator4, op3, list5, table2, n, defaultConstructorMarker);
                } else {
                    index = null;
                }
                if (index == null) continue;
                Index it$iv$iv = index;
                boolean bl20 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv2;
            $this$getOrPut$iv2.put(table, answer$iv);
        }
        return new HashMap(this.existingIndicesCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Table[] $this$associateWith$iv = tables;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        Table[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void table;
            Table element$iv$iv;
            Table table2 = element$iv$iv = $this$associateWithTo$iv$iv[i];
            Table table3 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Pair<String, String> pair = this.tableCatalogAndSchema((Table)table);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            ResultSet rs = this.metadata.getPrimaryKeys(catalog, tableSchema, table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            List columnNames = new ArrayList();
            String pkName = null;
            pkName = "";
            while (rs.next()) {
                String string;
                String string2 = string = rs.getString("PK_NAME");
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"PK_NAME\")");
                    String it = string;
                    boolean bl3 = false;
                    pkName = it;
                }
                ((Collection)columnNames).add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            PrimaryKeyMetadata primaryKeyMetadata = ((CharSequence)pkName).length() == 0 ? null : new PrimaryKeyMetadata(pkName, columnNames);
            map.put(table3, primaryKeyMetadata);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(@NotNull List<? extends Table> tables) {
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.nameInDatabaseCaseUnquoted(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Iterable $this$associateWith$iv = allTables.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            List list$iv$iv;
            List answer$iv$iv$iv;
            ForeignKeyConstraint it;
            Iterable $this$groupByTo$iv$iv;
            void table;
            Object element$iv$iv2;
            element$iv$iv2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Object v = allTables.get(table);
            Intrinsics.checkNotNull(v);
            Pair<String, String> pair = this.tableCatalogAndSchema((Table)v);
            String catalog = (String)pair.component1();
            String tableSchema = (String)pair.component2();
            ResultSet resultSet = this.metadata.getImportedKeys(catalog, this.getIdentifierManager().inProperCase(tableSchema), (String)table);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"metadata.getImportedKeys\u2026Case(tableSchema), table)");
            Iterable $this$groupBy$iv = CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)allTables){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = $receiver;
                    this.$allTables = $allTables;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ForeignKeyConstraint invoke(@NotNull ResultSet $this$iterate) {
                    ReferenceOption referenceOption;
                    Object object;
                    String constraintName;
                    Object fromColumn;
                    block15: {
                        block14: {
                            Object v11;
                            block11: {
                                void $this$firstOrNull$iv;
                                Object element$iv2;
                                Object object2;
                                block13: {
                                    block12: {
                                        Object v4;
                                        block10: {
                                            void $this$firstOrNull$iv2;
                                            Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                                            String string = $this$iterate.getString("FKTABLE_NAME");
                                            Intrinsics.checkNotNull((Object)string);
                                            String fromTableName = string;
                                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                            String string2 = $this$iterate.getString("FKCOLUMN_NAME");
                                            Intrinsics.checkNotNull((Object)string2);
                                            String fromColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string2);
                                            object2 = this.$allTables.get(fromTableName);
                                            if (object2 == null || (object2 = object2.getColumns()) == null) break block12;
                                            Iterable iterable = (Iterable)object2;
                                            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                                            boolean $i$f$firstOrNull = false;
                                            for (Object element$iv2 : $this$firstOrNull$iv2) {
                                                Column it = (Column)element$iv2;
                                                boolean bl = false;
                                                if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.getName()), (Object)fromColumnName)) continue;
                                                v4 = element$iv2;
                                                break block10;
                                            }
                                            v4 = null;
                                        }
                                        if ((object2 = (Column)v4) != null) break block13;
                                    }
                                    return null;
                                }
                                fromColumn = object2;
                                String string = $this$iterate.getString("FK_NAME");
                                Intrinsics.checkNotNull((Object)string);
                                constraintName = string;
                                String string3 = $this$iterate.getString("PKTABLE_NAME");
                                Intrinsics.checkNotNull((Object)string3);
                                String targetTableName = string3;
                                IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                IdentifierManagerApi identifierManagerApi2 = this.this$0.getIdentifierManager();
                                String string4 = $this$iterate.getString("PKCOLUMN_NAME");
                                Intrinsics.checkNotNull((Object)string4);
                                String targetColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string4));
                                object = this.$allTables.get(targetTableName);
                                if (object == null || (object = object.getColumns()) == null) break block14;
                                element$iv2 = (Iterable)object;
                                JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv3 : $this$firstOrNull$iv) {
                                    Column it = (Column)element$iv3;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase()), (Object)targetColumnName)) continue;
                                    v11 = element$iv3;
                                    break block11;
                                }
                                v11 = null;
                            }
                            if ((object = (Column)v11) != null) break block15;
                        }
                        return null;
                    }
                    Object targetColumn = object;
                    Object object3 = $this$iterate.getObject("UPDATE_RULE");
                    if (object3 != null && (object3 = object3.toString()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null) {
                        int it = ((Number)object3).intValue();
                        boolean bl = false;
                        referenceOption = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc(it);
                    } else {
                        referenceOption = null;
                    }
                    ReferenceOption constraintUpdateRule = referenceOption;
                    ReferenceOption constraintDeleteRule = DatabaseDialectKt.getCurrentDialect().resolveRefOptionFromJdbc($this$iterate.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint((Column)targetColumn, (Column)fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName);
                }
            }));
            boolean $i$f$groupBy = false;
            Iterable iterable2 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
                Object object;
                it = (ForeignKeyConstraint)element$iv$iv3;
                boolean bl2 = false;
                String key$iv$iv = it.getFkName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv3);
            }
            Iterable $this$map$iv = destination$iv$iv2.values();
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (List)item$iv$iv;
                Object object = destination$iv$iv2;
                boolean bl4 = false;
                Iterable $this$reduce$iv = (Iterable)it;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    answer$iv$iv$iv = (ForeignKeyConstraint)iterator$iv.next();
                    ForeignKeyConstraint p0 = (ForeignKeyConstraint)accumulator$iv;
                    boolean bl5 = false;
                    accumulator$iv = p0.plus((ForeignKeyConstraint)p1);
                }
                object.add((ForeignKeyConstraint)accumulator$iv);
            }
            List list = (List)destination$iv$iv2;
            map.put(t, list);
        }
        return result$iv;
    }

    private final Pair<String, String> tableCatalogAndSchema(Table table) {
        IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
        String string = table.getSchemaName();
        if (string == null) {
            string = this.getCurrentScheme();
        }
        String tableSchema = identifierManagerApi.inProperCase(string);
        return DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect && !Intrinsics.areEqual((Object)tableSchema, (Object)this.getCurrentScheme()) ? TuplesKt.to((Object)tableSchema, (Object)tableSchema) : TuplesKt.to((Object)this.getDatabaseName(), (Object)tableSchema);
    }

    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> body) {
        return LazyKt.lazy((Function0)new Function0<T>(body, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = $body;
                this.this$0 = $receiver;
                super(0);
            }

            public final T invoke() {
                return (T)this.$body.invoke((Object)this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl $this, String scheme) {
        return $this.tableNamesFor(scheme);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "map", "", "default", "Lkotlin/Function1;", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getDefault", "()Lkotlin/jvm/functions/Function1;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "exposed-jdbc"})
    @SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,343:1\n372#2,7:344\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n*L\n85#1:344,7\n*E\n"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        @NotNull
        private final Map<K, V> map;
        @NotNull
        private final Function1<K, V> default;
        final /* synthetic */ JdbcDatabaseMetadataImpl this$0;

        public CachableMapWithDefault(@NotNull JdbcDatabaseMetadataImpl this$0, @NotNull Map<K, V> map, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter(function1, (String)"default");
            this.this$0 = this$0;
            this.map = map;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map map, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(jdbcDatabaseMetadataImpl, map, function1);
        }

        @NotNull
        public final Function1<K, V> getDefault() {
            return this.default;
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        @NotNull
        public Set<K> getKeys() {
            return this.map.keySet();
        }

        public int getSize() {
            return this.map.size();
        }

        @NotNull
        public Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        @Nullable
        public V get(Object key) {
            Object object;
            Map<Object, Object> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                Object answer$iv = this.default.invoke(key);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "()V", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

