/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/OffsetDateTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueAsDefaultString", "", "value", "nonNullValueToString", "notNullValueToDB", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaOffsetDateTimeColumnType
extends ColumnType<OffsetDateTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaOffsetDateTimeColumnType INSTANCE = new JavaOffsetDateTimeColumnType();

    public JavaOffsetDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampWithTimeZoneType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull OffsetDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? '\'' + value.format(JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof MysqlDialect ? '\'' + value.format(JavaDateColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof OracleDialect ? JavaDateColumnTypeKt.access$oracleTimestampWithTimezoneLiteral(value) : '\'' + value.format(JavaDateColumnTypeKt.access$getDEFAULT_OFFSET_DATE_TIME_FORMATTER()) + '\''));
    }

    @NotNull
    public OffsetDateTime valueFromDB(@NotNull Object value) {
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof OffsetDateTime) {
            offsetDateTime = (OffsetDateTime)value;
        } else if (object instanceof String) {
            OffsetDateTime offsetDateTime2 = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? OffsetDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : OffsetDateTime.parse((CharSequence)value);
            Intrinsics.checkNotNull((Object)offsetDateTime2);
            offsetDateTime = offsetDateTime2;
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return offsetDateTime;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? super.readObject(rs, index) : rs.getObject(index, OffsetDateTime.class);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull OffsetDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof SQLiteDialect ? value.format(JavaDateColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : (databaseDialect instanceof MysqlDialect ? value.format(JavaDateColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) : value);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull OffsetDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof PostgreSQLDialect ? '\'' + value.format(JavaDateColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + "+00'::timestamp with time zone" : (dialect instanceof H2Dialect && ((H2Dialect)dialect).getH2Mode() == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + value.format(JavaDateColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : (dialect instanceof MysqlDialect ? '\'' + value.format(JavaDateColumnTypeKt.access$getMYSQL_FRACTION_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : super.nonNullValueAsDefaultString((Object)value)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaOffsetDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

