/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalTime", "kotlin.jvm.PlatformType", "millis", "", "nonNullValueAsDefaultString", "", "value", "nonNullValueToString", "notNullValueToDB", "", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalTimeColumnType
extends ColumnType<LocalTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalTimeColumnType INSTANCE = new JavaLocalTimeColumnType();

    public JavaLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "TIMESTAMP '" + JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value) + '\'';
        }
        return '\'' + JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value) + '\'';
    }

    @NotNull
    public LocalTime valueFromDB(@NotNull Object value) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof LocalTime) {
            localTime = (LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            localTime = localTime2;
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"toLocalTime(...)");
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            localTime = localTime3;
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"toLocalTime(...)");
        } else if (object instanceof Integer) {
            LocalTime localTime4 = this.longToLocalTime(((Number)value).intValue());
            localTime = localTime4;
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"longToLocalTime(...)");
        } else if (object instanceof Long) {
            LocalTime localTime5 = this.longToLocalTime(((Number)value).longValue());
            localTime = localTime5;
            Intrinsics.checkNotNullExpressionValue((Object)localTime5, (String)"longToLocalTime(...)");
        } else if (object instanceof String) {
            DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
            DateTimeFormatter formatter = dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$formatterForDateString((String)value) : JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime6 = LocalTime.parse((CharSequence)value, formatter);
            Intrinsics.checkNotNull((Object)localTime6);
            localTime = localTime6;
        } else {
            localTime = this.valueFromDB(value.toString());
        }
        return localTime;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(value) : (H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? JavaDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(value) : Time.valueOf(value));
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::time without time zone" : (databaseDialect instanceof MysqlDialect ? '\'' + JavaDateColumnTypeKt.access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER().format(value) + '\'' : super.nonNullValueAsDefaultString((Object)value));
    }

    private final LocalTime longToLocalTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

