/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/time/Duration;", "()V", "nonNullValueToString", "", "value", "notNullValueToDB", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
@SourceDebugExtension(value={"SMAP\nJavaDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDateColumnType.kt\norg/jetbrains/exposed/sql/javatime/JavaDurationColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1#2:499\n*E\n"})
public final class JavaDurationColumnType
extends ColumnType<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavaDurationColumnType INSTANCE = new JavaDurationColumnType();

    public JavaDurationColumnType() {
        super(false, 1, null);
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().longType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "" + '\'' + value.toNanos() + '\'';
    }

    @NotNull
    public Duration valueFromDB(@NotNull Object value) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Long) {
            Duration duration2 = Duration.ofNanos(((Number)value).longValue());
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofNanos(...)");
        } else if (object instanceof Number) {
            Duration duration3 = Duration.ofNanos(((Number)value).longValue());
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofNanos(...)");
        } else if (object instanceof String) {
            Duration duration4 = Duration.parse((CharSequence)value);
            duration = duration4;
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"parse(...)");
        } else {
            duration = this.valueFromDB(value.toString());
        }
        return duration;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Long l = rs.getLong(index);
        long it = ((Number)l).longValue();
        boolean bl = false;
        return rs.getObject(index) != null ? l : null;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.toNanos();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaDurationColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

